/*
 * Decompiled with CFR 0.152.
 */
package org.fax4j.bridge.http;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import org.fax4j.FaxException;
import org.fax4j.FaxJob;
import org.fax4j.bridge.AbstractRequestParser;
import org.fax4j.bridge.FileInfo;
import org.fax4j.bridge.http.HTTPRequestParser;
import org.fax4j.common.ConfigurationHolderImpl;
import org.fax4j.spi.http.HTTPRequest;
import org.fax4j.util.IOHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiPartHTTPRequestParser
extends AbstractRequestParser<HTTPRequest>
implements HTTPRequestParser {
    protected String fileContentParameter;
    protected String fileNameParameter;
    protected String priorityParameter;
    protected String targetAddressParameter;
    protected String targetNameParameter;
    protected String senderNameParameter;
    protected String senderFaxNumberParameter;
    protected String senderEMailParameter;

    @Override
    protected void initializeImpl(Map<String, String> configuration) {
        ConfigurationHolderImpl configurationHolder = new ConfigurationHolderImpl(configuration);
        this.fileContentParameter = configurationHolder.getConfigurationValue(HTTPRequestParserConfigurationConstants.FILE_CONTENT_PARAMETER_NAME_PROPERTY_KEY);
        if (this.fileContentParameter == null) {
            this.fileContentParameter = "file";
        }
        this.fileNameParameter = configurationHolder.getConfigurationValue(HTTPRequestParserConfigurationConstants.FILE_NAME_PARAMETER_NAME_PROPERTY_KEY);
        if (this.fileNameParameter == null) {
            this.fileNameParameter = "filename";
        }
        this.priorityParameter = configurationHolder.getConfigurationValue(HTTPRequestParserConfigurationConstants.PRIORITY_PARAMETER_NAME_PROPERTY_KEY);
        if (this.priorityParameter == null) {
            this.priorityParameter = "priority";
        }
        this.targetAddressParameter = configurationHolder.getConfigurationValue(HTTPRequestParserConfigurationConstants.TARGET_ADDRESS_PARAMETER_NAME_PROPERTY_KEY);
        if (this.targetAddressParameter == null) {
            this.targetAddressParameter = "targetaddress";
        }
        this.targetNameParameter = configurationHolder.getConfigurationValue(HTTPRequestParserConfigurationConstants.TARGET_NAME_PARAMETER_NAME_PROPERTY_KEY);
        if (this.targetNameParameter == null) {
            this.targetNameParameter = "targetname";
        }
        this.senderNameParameter = configurationHolder.getConfigurationValue(HTTPRequestParserConfigurationConstants.SENDER_NAME_PARAMETER_NAME_PROPERTY_KEY);
        if (this.senderNameParameter == null) {
            this.senderNameParameter = "sendername";
        }
        this.senderFaxNumberParameter = configurationHolder.getConfigurationValue(HTTPRequestParserConfigurationConstants.SENDER_FAX_NUMBER_PARAMETER_NAME_PROPERTY_KEY);
        if (this.senderFaxNumberParameter == null) {
            this.senderFaxNumberParameter = "senderfaxnumber";
        }
        this.senderEMailParameter = configurationHolder.getConfigurationValue(HTTPRequestParserConfigurationConstants.SENDER_EMAIL_PARAMETER_NAME_PROPERTY_KEY);
        if (this.senderEMailParameter == null) {
            this.senderEMailParameter = "senderemail";
        }
    }

    @Override
    protected FileInfo getFileInfoFromInputDataImpl(HTTPRequest inputData) {
        Map<String, HTTPRequest.ContentPart<?>> contentPartsMap = this.getContentPartsAsMap(inputData);
        FileInfo fileInfo = null;
        HTTPRequest.ContentPart<?> contentPart = contentPartsMap.get(this.fileContentParameter);
        if (contentPart == null) {
            throw new FaxException("File info not provided.");
        }
        HTTPRequest.ContentPartType contentPartType = contentPart.getType();
        switch (contentPartType) {
            case FILE: {
                File file = (File)contentPart.getContent();
                fileInfo = new FileInfo(file);
                break;
            }
            case BINARY: {
                byte[] data = (byte[])contentPart.getContent();
                String fileName = this.getContentPartAsString(contentPartsMap, this.fileNameParameter);
                fileInfo = new FileInfo(fileName, data);
                break;
            }
            default: {
                throw new FaxException("Unsupported content part type: " + (Object)((Object)contentPartType));
            }
        }
        return fileInfo;
    }

    @Override
    protected void updateFaxJobFromInputDataImpl(HTTPRequest inputData, FaxJob faxJob) {
        Map<String, HTTPRequest.ContentPart<?>> contentPartsMap = this.getContentPartsAsMap(inputData);
        String value = this.getContentPartAsString(contentPartsMap, this.priorityParameter);
        if (value != null && value.length() > 0) {
            FaxJob.FaxJobPriority priority = FaxJob.FaxJobPriority.valueOf(value);
            faxJob.setPriority(priority);
        }
        if ((value = this.getContentPartAsString(contentPartsMap, this.targetAddressParameter)) == null || value.length() == 0) {
            throw new FaxException("Target address not provided.");
        }
        faxJob.setTargetAddress(value);
        value = this.getContentPartAsString(contentPartsMap, this.targetNameParameter);
        if (value != null && value.length() > 0) {
            faxJob.setTargetName(value);
        }
        if ((value = this.getContentPartAsString(contentPartsMap, this.senderNameParameter)) != null && value.length() > 0) {
            faxJob.setSenderName(value);
        }
        if ((value = this.getContentPartAsString(contentPartsMap, this.senderFaxNumberParameter)) != null && value.length() > 0) {
            faxJob.setSenderFaxNumber(value);
        }
        if ((value = this.getContentPartAsString(contentPartsMap, this.senderEMailParameter)) != null && value.length() > 0) {
            faxJob.setSenderEmail(value);
        }
    }

    protected String getContentPartAsString(Map<String, HTTPRequest.ContentPart<?>> contentPartsMap, String parameter) {
        String stringValue = null;
        HTTPRequest.ContentPart<?> contentPart = contentPartsMap.get(parameter);
        if (contentPart != null) {
            HTTPRequest.ContentPartType contentPartType = contentPart.getType();
            Object content = contentPart.getContent();
            if (content != null) {
                switch (contentPartType) {
                    case STRING: {
                        stringValue = (String)content;
                        break;
                    }
                    case BINARY: {
                        byte[] data = (byte[])content;
                        String encoding = IOHelper.getDefaultEncoding();
                        try {
                            stringValue = new String(data, encoding);
                            break;
                        }
                        catch (UnsupportedEncodingException exception) {
                            throw new FaxException("Unable to convert binary data to string for parameter: " + parameter, exception);
                        }
                    }
                    default: {
                        throw new FaxException("Unsupported content part type: " + (Object)((Object)contentPartType));
                    }
                }
            }
        }
        return stringValue;
    }

    protected Map<String, HTTPRequest.ContentPart<?>> getContentPartsAsMap(HTTPRequest httpRequest) {
        HashMap contentPartsMap = null;
        HTTPRequest.ContentType contentType = httpRequest.getContentType();
        switch (contentType) {
            case MULTI_PART: {
                contentPartsMap = new HashMap();
                HTTPRequest.ContentPart<?>[] contentParts = httpRequest.getContentAsParts();
                int amount = contentParts.length;
                HTTPRequest.ContentPart<?> contentPart = null;
                String partName = null;
                for (int index = 0; index < amount; ++index) {
                    contentPart = contentParts[index];
                    partName = contentPart.getName();
                    contentPartsMap.put(partName, contentPart);
                }
                break;
            }
            default: {
                throw new FaxException("Unsupported content type: " + (Object)((Object)contentType));
            }
        }
        return contentPartsMap;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum HTTPRequestParserConfigurationConstants {
        FILE_CONTENT_PARAMETER_NAME_PROPERTY_KEY("org.fax4j.bridge.http.request.parser.multi.part.file.content.parameter"),
        FILE_NAME_PARAMETER_NAME_PROPERTY_KEY("org.fax4j.bridge.http.request.parser.multi.part.file.name.parameter"),
        PRIORITY_PARAMETER_NAME_PROPERTY_KEY("org.fax4j.bridge.http.request.parser.multi.part.priority.parameter"),
        TARGET_ADDRESS_PARAMETER_NAME_PROPERTY_KEY("org.fax4j.bridge.http.request.parser.multi.part.target.address.parameter"),
        TARGET_NAME_PARAMETER_NAME_PROPERTY_KEY("org.fax4j.bridge.http.request.parser.multi.part.target.name.parameter"),
        SENDER_NAME_PARAMETER_NAME_PROPERTY_KEY("org.fax4j.bridge.http.request.parser.multi.part.sender.name.parameter"),
        SENDER_FAX_NUMBER_PARAMETER_NAME_PROPERTY_KEY("org.fax4j.bridge.http.request.parser.multi.part.sender.fax.number.parameter"),
        SENDER_EMAIL_PARAMETER_NAME_PROPERTY_KEY("org.fax4j.bridge.http.request.parser.multi.part.sender.email.parameter");

        private String value;

        private HTTPRequestParserConfigurationConstants(String value) {
            this.value = value;
        }

        public final String toString() {
            return this.value;
        }
    }
}

