/*
 * Decompiled with CFR 0.152.
 */
package org.fax4j.bridge.http;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.fax4j.FaxException;
import org.fax4j.FaxJob;
import org.fax4j.bridge.AbstractRequestParser;
import org.fax4j.bridge.FileInfo;
import org.fax4j.bridge.http.HTTPRequestParser;
import org.fax4j.spi.http.HTTPRequest;
import org.fax4j.util.IOHelper;
import org.fax4j.util.SpiUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleHTTPRequestParser
extends AbstractRequestParser<HTTPRequest>
implements HTTPRequestParser {
    @Override
    protected void initializeImpl(Map<String, String> configuration) {
    }

    @Override
    protected FileInfo getFileInfoFromInputDataImpl(HTTPRequest inputData) {
        Map<String, String> queryStringMap = this.convertParametersTextToMap(inputData);
        FileInfo fileInfo = this.getFileInfoFromRequestImpl(inputData, queryStringMap);
        return fileInfo;
    }

    @Override
    protected void updateFaxJobFromInputDataImpl(HTTPRequest inputData, FaxJob faxJob) {
        Map<String, String> queryStringMap = this.convertParametersTextToMap(inputData);
        this.updateFaxJobFromRequestImpl(inputData, faxJob, queryStringMap);
    }

    protected Map<String, String> convertParametersTextToMap(HTTPRequest request) {
        HashMap<String, String> map = new HashMap<String, String>();
        String parametersText = request.getParametersText();
        if (parametersText != null) {
            String[] keyValuePairs = parametersText.split("&");
            int pairsAmount = keyValuePairs.length;
            String keyValuePair = null;
            String[] parts = null;
            String key = null;
            String value = null;
            for (int index = 0; index < pairsAmount; ++index) {
                keyValuePair = keyValuePairs[index];
                parts = keyValuePair.split("=");
                if (parts.length != 2 || (key = parts[0]).length() <= 0) continue;
                key = SpiUtil.urlDecode(key);
                value = parts[1].trim();
                value = SpiUtil.urlDecode(value);
                map.put(key, value);
            }
        }
        return map;
    }

    protected FileInfo getFileInfoFromRequestImpl(HTTPRequest request, Map<String, String> queryStringMap) {
        String name = queryStringMap.get("file");
        if (name == null) {
            throw new FaxException("File name not provided in query string.");
        }
        byte[] content = null;
        HTTPRequest.ContentType contentType = request.getContentType();
        switch (contentType) {
            case BINARY: {
                content = request.getContentAsBinary();
                break;
            }
            case STRING: {
                String contentString = request.getContentAsString();
                content = IOHelper.convertStringToBinary(contentString, null);
                break;
            }
            default: {
                throw new FaxException("Unsupported content type: " + (Object)((Object)contentType));
            }
        }
        if (content == null || content.length == 0) {
            throw new FaxException("File content not provided in request payload.");
        }
        FileInfo fileInfo = new FileInfo(name, content);
        return fileInfo;
    }

    protected void updateFaxJobFromRequestImpl(HTTPRequest request, FaxJob faxJob, Map<String, String> queryStringMap) {
        String value = queryStringMap.get("priority");
        if (value != null) {
            FaxJob.FaxJobPriority priority = FaxJob.FaxJobPriority.valueOf(value);
            faxJob.setPriority(priority);
        }
        if ((value = queryStringMap.get("target_address")) == null) {
            throw new FaxException("Target address not provided in query string.");
        }
        faxJob.setTargetAddress(value);
        value = queryStringMap.get("target_name");
        if (value != null) {
            faxJob.setTargetName(value);
        }
        if ((value = queryStringMap.get("sender_name")) != null) {
            faxJob.setSenderName(value);
        }
        if ((value = queryStringMap.get("sender_fax_number")) != null) {
            faxJob.setSenderFaxNumber(value);
        }
        if ((value = queryStringMap.get("sender_email")) != null) {
            faxJob.setSenderEmail(value);
        }
        Iterator<Map.Entry<String, String>> iterator = queryStringMap.entrySet().iterator();
        Map.Entry<String, String> entry = null;
        String key = null;
        String propertyPrefix = "property:";
        int propertyPrefixLength = propertyPrefix.length();
        while (iterator.hasNext()) {
            entry = iterator.next();
            key = entry.getKey();
            if (!key.startsWith(propertyPrefix) || key.length() <= propertyPrefixLength) continue;
            key = key.substring(propertyPrefixLength);
            value = entry.getValue();
            faxJob.setProperty(key, value);
        }
    }
}

