/*
 * Decompiled with CFR 0.152.
 */
package org.fax4j.bridge.process;

import java.io.File;
import java.util.Map;
import org.fax4j.FaxException;
import org.fax4j.FaxJob;
import org.fax4j.bridge.AbstractRequestParser;
import org.fax4j.bridge.FileInfo;
import org.fax4j.bridge.process.CommandLineArgumentsParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultCommandLineArgumentsParser
extends AbstractRequestParser<String[]>
implements CommandLineArgumentsParser {
    @Override
    protected void initializeImpl(Map<String, String> configuration) {
    }

    @Override
    protected FileInfo getFileInfoFromInputDataImpl(String[] inputData) {
        int amount = inputData.length;
        FileInfo fileInfo = null;
        if (amount % 2 == 0) {
            String argument = null;
            String value = null;
            for (int index = 0; index < inputData.length; index += 2) {
                argument = inputData[index];
                value = inputData[index + 1];
                if (!argument.equals("-file")) continue;
                File file = new File(value);
                fileInfo = new FileInfo(file);
                break;
            }
        } else {
            throw new FaxException("Invalid input provided, expected even number of arguments.");
        }
        return fileInfo;
    }

    @Override
    protected void updateFaxJobFromInputDataImpl(String[] inputData, FaxJob faxJob) {
        int amount = inputData.length;
        if (amount % 2 == 0) {
            String argument = null;
            String key = null;
            String value = null;
            String propertyPrefix = "-property:";
            int propertyPrefixLength = propertyPrefix.length();
            for (int index = 0; index < inputData.length; index += 2) {
                argument = inputData[index];
                value = inputData[index + 1];
                if (argument.equals("-priority")) {
                    FaxJob.FaxJobPriority priority = FaxJob.FaxJobPriority.valueOf(value);
                    faxJob.setPriority(priority);
                    continue;
                }
                if (argument.equals("-target_address")) {
                    faxJob.setTargetAddress(value);
                    continue;
                }
                if (argument.equals("-target_name")) {
                    faxJob.setTargetName(value);
                    continue;
                }
                if (argument.equals("-sender_name")) {
                    faxJob.setSenderName(value);
                    continue;
                }
                if (argument.equals("-sender_fax_number")) {
                    faxJob.setSenderFaxNumber(value);
                    continue;
                }
                if (argument.equals("-sender_email")) {
                    faxJob.setSenderEmail(value);
                    continue;
                }
                if (argument.startsWith(propertyPrefix)) {
                    if (argument.length() <= propertyPrefixLength) continue;
                    key = argument.substring(propertyPrefixLength);
                    faxJob.setProperty(key, value);
                    continue;
                }
                if (argument.equals("-file")) continue;
                throw new FaxException("Invalid input provided, unsupported argument: " + argument);
            }
        } else {
            throw new FaxException("Invalid input provided, expected even number of arguments.");
        }
    }
}

