/*
 * Decompiled with CFR 0.152.
 */
package org.fax4j.common;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.fax4j.common.LogLevel;
import org.fax4j.common.Logger;

public abstract class AbstractLogger
implements Logger {
    private LogLevel logLevel;

    public AbstractLogger() {
        this.setLogLevel(LogLevel.NONE);
    }

    protected String formatLogMessage(LogLevel level, Object[] message, Throwable throwable) {
        String messageText = this.format(message);
        String throwableText = this.format(throwable);
        StringBuilder buffer = new StringBuilder();
        buffer.append("[fax4j][");
        buffer.append(level.getName());
        buffer.append("] ");
        if (messageText != null) {
            buffer.append(messageText);
            if (throwableText != null) {
                buffer.append(Logger.SYSTEM_EOL);
                buffer.append(throwableText);
            }
        } else if (throwableText != null) {
            buffer.append(throwableText);
        }
        String text = buffer.toString();
        return text;
    }

    protected String format(Object[] message) {
        String text = null;
        if (message != null) {
            StringBuilder buffer = new StringBuilder();
            int amount = message.length;
            Object object = null;
            for (int index = 0; index < amount; ++index) {
                object = message[index];
                buffer.append(object);
            }
            text = buffer.toString();
        }
        return text;
    }

    protected String format(Throwable throwable) {
        String text = null;
        if (throwable != null) {
            StringWriter writer = new StringWriter(1500);
            throwable.printStackTrace(new PrintWriter(writer));
            text = writer.toString();
        }
        return text;
    }

    public final void setLogLevel(LogLevel logLevel) {
        LogLevel updatedLogLevel = logLevel;
        if (updatedLogLevel == null) {
            updatedLogLevel = LogLevel.NONE;
        }
        this.logLevel = updatedLogLevel;
    }

    public final LogLevel getLogLevel() {
        return this.logLevel;
    }

    public void logDebug(Object[] message, Throwable throwable) {
        this.log(LogLevel.DEBUG, message, throwable);
    }

    public void logInfo(Object[] message, Throwable throwable) {
        this.log(LogLevel.INFO, message, throwable);
    }

    public void logError(Object[] message, Throwable throwable) {
        this.log(LogLevel.ERROR, message, throwable);
    }

    protected void log(LogLevel level, Object[] message, Throwable throwable) {
        if (level.getValue() >= this.logLevel.getValue()) {
            this.logImpl(level, message, throwable);
        }
    }

    protected abstract void logImpl(LogLevel var1, Object[] var2, Throwable var3);
}

