/*
 * Decompiled with CFR 0.152.
 */
package org.fax4j.common;

import java.util.Map;
import org.fax4j.FaxException;
import org.fax4j.Provider;
import org.fax4j.common.ConfigurationHolder;
import org.fax4j.common.ConfigurationHolderImpl;
import org.fax4j.common.Logger;
import org.fax4j.common.LoggerManager;
import org.fax4j.common.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractService
implements Service {
    private final Provider PROVIDER;
    private boolean initialized = false;
    private String propertyPart = null;
    private ConfigurationHolder serviceConfiguration;
    private Logger serviceLogger;

    public AbstractService(Provider provider) {
        this.PROVIDER = provider;
        if (this.PROVIDER == null) {
            throw new FaxException("Provider is null.");
        }
    }

    @Override
    public final Provider getProvider() {
        return this.PROVIDER;
    }

    @Override
    public final synchronized void initialize(Map<String, String> configuration) {
        if (this.initialized) {
            throw new FaxException("Service already initialized.");
        }
        this.initialized = true;
        this.serviceConfiguration = new ConfigurationHolderImpl(configuration, this.propertyPart);
        LoggerManager loggerManager = LoggerManager.getInstance();
        this.serviceLogger = loggerManager.getLogger();
        this.initializeImpl();
    }

    public final Logger getLogger() {
        return this.serviceLogger;
    }

    @Override
    public void setPropertyPart(String propertyPart) {
        this.propertyPart = propertyPart;
    }

    @Override
    public final String getPropertyPart() {
        return this.serviceConfiguration.getPropertyPart();
    }

    @Override
    public final Map<String, String> getConfiguration() {
        return this.serviceConfiguration.getConfiguration();
    }

    @Override
    public final String getConfigurationValue(String key) {
        String value = this.serviceConfiguration.getConfigurationValue(key);
        return value;
    }

    @Override
    public final String getConfigurationValue(Enum<?> key) {
        String value = this.serviceConfiguration.getConfigurationValue(key);
        return value;
    }

    protected abstract void initializeImpl();
}

