/*
 * Decompiled with CFR 0.152.
 */
package org.fax4j.common;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.fax4j.common.ConfigurationHolder;
import org.fax4j.common.Logger;
import org.fax4j.common.LoggerManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConfigurationHolderImpl
implements ConfigurationHolder {
    private final String PROPERTY_PART;
    private final Map<String, String> CONFIGURATION;
    private final Logger LOGGER;

    public ConfigurationHolderImpl(Map<String, String> map) {
        this(map, null);
    }

    public ConfigurationHolderImpl(Map<String, String> map, String propertyPart) {
        LoggerManager loggerManager = LoggerManager.getInstance();
        this.LOGGER = loggerManager.getLogger();
        HashMap<String, String> configuration = new HashMap<String, String>(map);
        this.CONFIGURATION = Collections.unmodifiableMap(configuration);
        this.PROPERTY_PART = propertyPart;
    }

    @Override
    public final String getPropertyPart() {
        return this.PROPERTY_PART;
    }

    @Override
    public final Map<String, String> getConfiguration() {
        return this.CONFIGURATION;
    }

    @Override
    public final String getConfigurationValue(String key) {
        String value;
        String propertyKey = key;
        if (this.PROPERTY_PART != null) {
            propertyKey = MessageFormat.format(key, this.PROPERTY_PART);
        }
        if ((value = this.CONFIGURATION.get(propertyKey)) != null && (value = value.trim()).length() == 0) {
            value = null;
        }
        this.LOGGER.logDebug(new Object[]{"Extracted configuration for key: ", propertyKey, " value: ", value}, null);
        return value;
    }

    @Override
    public final String getConfigurationValue(Enum<?> key) {
        String keyStr = key.toString();
        String value = this.getConfigurationValue(keyStr);
        return value;
    }
}

