/*
 * Decompiled with CFR 0.152.
 */
package org.fax4j.common;

import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;
import org.fax4j.FaxClient;
import org.fax4j.common.AbstractLogger;
import org.fax4j.common.LogLevel;

public class JDKLogger
extends AbstractLogger {
    protected final Logger JDK_LOGGER = JDKLogger.initializeLogger();

    protected static final Logger initializeLogger() {
        Logger logger = Logger.getLogger(FaxClient.class.getName());
        logger.setLevel(Level.ALL);
        logger.setFilter(null);
        logger.setUseParentHandlers(true);
        SimpleFormatter formatter = new SimpleFormatter();
        StreamHandler handler = new StreamHandler(System.out, formatter);
        handler.setLevel(logger.getLevel());
        handler.setFilter(logger.getFilter());
        logger.addHandler(handler);
        return logger;
    }

    protected void logImpl(LogLevel level, Object[] message, Throwable throwable) {
        int levelValue = level.getValue();
        Level jdkLevel = null;
        switch (levelValue) {
            case 0: {
                jdkLevel = Level.FINEST;
                break;
            }
            case 100: {
                jdkLevel = Level.SEVERE;
                break;
            }
            default: {
                jdkLevel = Level.FINE;
            }
        }
        if (jdkLevel != null) {
            String text = this.formatLogMessage(level, message, null);
            this.JDK_LOGGER.log(jdkLevel, text, throwable);
        }
    }
}

