/*
 * Decompiled with CFR 0.152.
 */
package org.fax4j.common;

import java.util.Map;
import org.fax4j.common.LogLevel;
import org.fax4j.common.Logger;
import org.fax4j.common.SimpleLogger;
import org.fax4j.util.LibraryConfigurationLoader;
import org.fax4j.util.ReflectionHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LoggerManager {
    private Logger logger;
    private static final LoggerManager INSTANCE = new LoggerManager();
    public static final String LOGGER_CLASS_NAME_PROPERTY_KEY = "org.fax4j.logger.class.name";
    public static final String LOGGER_LOG_LEVEL_PROPERTY_KEY = "org.fax4j.logger.log.level";

    private LoggerManager() {
        this.initializeLogger();
    }

    public static LoggerManager getInstance() {
        return INSTANCE;
    }

    private void initializeLogger() {
        Map<String, String> systemConfiguration = LibraryConfigurationLoader.getSystemConfiguration();
        this.createLogger(systemConfiguration);
    }

    public Logger getLogger() {
        return this.logger;
    }

    private void createLogger(Map<String, String> systemConfiguration) {
        String className = systemConfiguration.get(LOGGER_CLASS_NAME_PROPERTY_KEY);
        if (className == null || className.length() == 0) {
            className = SimpleLogger.class.getName();
        }
        Logger loggerInstance = (Logger)ReflectionHelper.createInstance(className);
        loggerInstance.setLogLevel(LogLevel.NONE);
        String logLevelName = systemConfiguration.get(LOGGER_LOG_LEVEL_PROPERTY_KEY);
        if (logLevelName != null) {
            if (logLevelName.equalsIgnoreCase(LogLevel.ERROR.getName())) {
                loggerInstance.setLogLevel(LogLevel.ERROR);
            } else if (logLevelName.equalsIgnoreCase(LogLevel.INFO.getName())) {
                loggerInstance.setLogLevel(LogLevel.INFO);
            } else if (logLevelName.equalsIgnoreCase(LogLevel.DEBUG.getName())) {
                loggerInstance.setLogLevel(LogLevel.DEBUG);
            }
        }
        this.logger = loggerInstance;
    }
}

