/*
 * Decompiled with CFR 0.152.
 */
package org.fax4j.common;

import org.fax4j.FaxException;
import org.fax4j.Provider;
import org.fax4j.common.Logger;

public class ProviderImpl
implements Provider {
    private final String NAME;
    private final String DESCRIPTION;

    public ProviderImpl(String name, String description) {
        if (name == null) {
            throw new FaxException("Provider name not provided.");
        }
        String updatedDescription = description;
        if (updatedDescription == null) {
            updatedDescription = "";
        }
        this.NAME = name;
        this.DESCRIPTION = updatedDescription;
    }

    public final String getName() {
        return this.NAME;
    }

    public final String getDescription() {
        return this.DESCRIPTION;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(250);
        buffer.append("Provider Name: ");
        buffer.append(this.NAME);
        buffer.append(Logger.SYSTEM_EOL);
        buffer.append("Provider Description: ");
        buffer.append(this.DESCRIPTION);
        String text = buffer.toString();
        return text;
    }

    public boolean equals(Object object) {
        Provider provider;
        boolean result = super.equals(object);
        if (!result && object instanceof Provider && this.NAME.equals((provider = (Provider)object).getName()) && this.DESCRIPTION.equals(provider.getDescription())) {
            result = true;
        }
        return result;
    }

    public int hashCode() {
        int hashCodeValue = this.NAME.hashCode() + this.DESCRIPTION.hashCode();
        return hashCodeValue;
    }
}

