/*
 * Decompiled with CFR 0.152.
 */
package org.fax4j.common;

import java.util.Map;
import org.fax4j.FaxException;
import org.fax4j.common.ConfigurationHolder;
import org.fax4j.common.Service;
import org.fax4j.util.ReflectionHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ServiceFactory {
    private ServiceFactory() {
    }

    public static Service createService(Enum<?> classNameKey, String defaultClassName, ConfigurationHolder configurationHolder, String propertyPart) {
        if (classNameKey == null) {
            throw new FaxException("Service class name key not provided.");
        }
        String classNameKeyString = classNameKey.toString();
        Service service = ServiceFactory.createService(classNameKeyString, defaultClassName, configurationHolder, propertyPart);
        return service;
    }

    public static Service createService(String classNameKey, String defaultClassName, ConfigurationHolder configurationHolder, String propertyPart) {
        if (configurationHolder == null) {
            throw new FaxException("Service configuration not provided.");
        }
        if (classNameKey == null) {
            throw new FaxException("Service class name key not provided.");
        }
        String className = configurationHolder.getConfigurationValue(classNameKey);
        if (className == null && (className = defaultClassName) == null) {
            throw new FaxException("Service class name not found in configuration and no default value provided.");
        }
        Map<String, String> configuration = configurationHolder.getConfiguration();
        Service service = (Service)ReflectionHelper.createInstance(className);
        service.setPropertyPart(propertyPart);
        service.initialize(configuration);
        return service;
    }
}

