/*
 * Decompiled with CFR 0.152.
 */
package org.fax4j.spi;

import org.fax4j.FaxJob;
import org.fax4j.FaxJobStatus;
import org.fax4j.Provider;
import org.fax4j.common.Fax4JProvider;
import org.fax4j.spi.AbstractFaxClientSpi;

public abstract class AbstractFax4JClientSpi
extends AbstractFaxClientSpi {
    public final Provider getProvider() {
        return Fax4JProvider.FAX4J_PROVIDER;
    }

    public boolean isFaxMonitorEventsSupported() {
        return false;
    }

    public final FaxJobStatus[] pollForFaxJobStatues(FaxJob[] faxJobs) {
        FaxJobStatus[] faxJobStatuses = null;
        if (faxJobs != null && faxJobs.length > 0 && this.isFaxMonitorEventsSupported()) {
            faxJobStatuses = this.pollForFaxJobStatuesImpl(faxJobs);
        }
        return faxJobStatuses;
    }

    protected void submitFaxJobImpl(FaxJob faxJob) {
        this.throwUnsupportedException();
    }

    protected void suspendFaxJobImpl(FaxJob faxJob) {
        this.throwUnsupportedException();
    }

    protected void resumeFaxJobImpl(FaxJob faxJob) {
        this.throwUnsupportedException();
    }

    protected void cancelFaxJobImpl(FaxJob faxJob) {
        this.throwUnsupportedException();
    }

    protected FaxJobStatus getFaxJobStatusImpl(FaxJob faxJob) {
        return FaxJobStatus.UNKNOWN;
    }

    protected FaxJobStatus[] pollForFaxJobStatuesImpl(FaxJob[] faxJobs) {
        int amount = faxJobs.length;
        FaxJobStatus[] faxJobStatuses = new FaxJobStatus[amount];
        FaxJob faxJob = null;
        FaxJobStatus faxJobStatus = null;
        for (int index = 0; index < amount; ++index) {
            faxJob = faxJobs[index];
            faxJobStatus = FaxJobStatus.UNKNOWN;
            if (faxJob != null) {
                try {
                    faxJobStatus = this.getFaxJobStatus(faxJob);
                }
                catch (RuntimeException exception) {
                    // empty catch block
                }
            }
            if (faxJobStatus == null) {
                faxJobStatus = FaxJobStatus.UNKNOWN;
            }
            faxJobStatuses[index] = faxJobStatus;
        }
        return faxJobStatuses;
    }
}

