/*
 * Decompiled with CFR 0.152.
 */
package org.fax4j.spi;

import java.io.File;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.fax4j.FaxClientActionEvent;
import org.fax4j.FaxClientActionEventListener;
import org.fax4j.FaxException;
import org.fax4j.FaxJob;
import org.fax4j.FaxJobStatus;
import org.fax4j.FaxMonitorEvent;
import org.fax4j.FaxMonitorEventListener;
import org.fax4j.common.ConfigurationHolder;
import org.fax4j.common.ConfigurationHolderImpl;
import org.fax4j.common.Logger;
import org.fax4j.spi.FaxClientSpi;
import org.fax4j.spi.FaxJobImpl;
import org.fax4j.spi.FaxJobMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFaxClientSpi
implements FaxClientSpi {
    private boolean initialized = false;
    private ConfigurationHolder spiConfiguration;
    private Logger spiLogger;
    private FaxJobMonitor spiFaxJobMonitor;
    private Set<FaxClientActionEventListener> faxClientActionEventListeners;
    private Set<FaxMonitorEventListener> faxMonitorEventListeners;

    @Override
    public final void initialize(Map<String, String> configuration, Logger logger, FaxJobMonitor faxJobMonitor) {
        if (this.initialized) {
            throw new FaxException("Fax client SPI already initialized.");
        }
        this.initialized = true;
        String propertyPart = this.getPropertyPart();
        this.spiConfiguration = new ConfigurationHolderImpl(configuration, propertyPart);
        this.spiLogger = logger;
        this.spiLogger.logDebug(new Object[]{"Initializing fax client SPI of type: ", this.getClass().getName(), "\nProvider Information:\n", this.getProvider(), "\nSPI Configuration:\n", configuration}, null);
        this.spiFaxJobMonitor = faxJobMonitor;
        this.faxClientActionEventListeners = new HashSet<FaxClientActionEventListener>();
        this.faxMonitorEventListeners = new HashSet<FaxMonitorEventListener>();
        this.initializeImpl();
    }

    @Override
    public final Logger getLogger() {
        return this.spiLogger;
    }

    @Override
    public final FaxJobMonitor getFaxJobMonitor() {
        return this.spiFaxJobMonitor;
    }

    @Override
    public String getPropertyPart() {
        return null;
    }

    @Override
    public Map<String, String> getConfiguration() {
        return this.spiConfiguration.getConfiguration();
    }

    @Override
    public final String getConfigurationValue(String key) {
        String value = this.spiConfiguration.getConfigurationValue(key);
        return value;
    }

    @Override
    public final String getConfigurationValue(Enum<?> key) {
        String value = this.spiConfiguration.getConfigurationValue(key);
        return value;
    }

    @Override
    public final void fireFaxMonitorEvent(FaxMonitorEvent.FaxMonitorEventID id, FaxJob faxJob, FaxJobStatus faxJobStatus) {
        this.fireFaxEvent(id, faxJob, faxJobStatus);
    }

    @Override
    public FaxJob createFaxJob() {
        FaxJob faxJob = this.createFaxJobImpl();
        this.fireFaxEvent(FaxClientActionEvent.FaxClientActionEventID.CREATE_FAX_JOB, faxJob);
        return faxJob;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void submitFaxJob(FaxJob faxJob) {
        this.invokeFaxJobNullValidation(faxJob);
        String targetAddress = faxJob.getTargetAddress();
        if (targetAddress == null || targetAddress.length() == 0) {
            throw new FaxException("Fax job target address not provided.");
        }
        File file = faxJob.getFile();
        if (file == null) {
            throw new FaxException("Fax job file not provided.");
        }
        if (!file.exists()) {
            throw new FaxException("Fax job file " + file.getPath() + " does not exist.");
        }
        if (!file.isFile()) {
            throw new FaxException("Fax job file " + file.getPath() + " is not a file.");
        }
        if (file.length() == 0L) {
            throw new FaxException("Fax job file " + file.getPath() + " is empty.");
        }
        this.submitFaxJobImpl(faxJob);
        this.fireFaxEvent(FaxClientActionEvent.FaxClientActionEventID.SUBMIT_FAX_JOB, faxJob);
        if (this.isFaxMonitorEventsSupported()) {
            Set<FaxMonitorEventListener> set = this.faxMonitorEventListeners;
            synchronized (set) {
                if (!this.faxMonitorEventListeners.isEmpty()) {
                    this.spiFaxJobMonitor.monitorFaxJob(this, faxJob);
                }
            }
        }
    }

    @Override
    public void suspendFaxJob(FaxJob faxJob) {
        this.invokeFaxJobIDValidation(faxJob);
        this.suspendFaxJobImpl(faxJob);
        this.fireFaxEvent(FaxClientActionEvent.FaxClientActionEventID.SUSPEND_FAX_JOB, faxJob);
    }

    @Override
    public void resumeFaxJob(FaxJob faxJob) {
        this.invokeFaxJobIDValidation(faxJob);
        this.resumeFaxJobImpl(faxJob);
        this.fireFaxEvent(FaxClientActionEvent.FaxClientActionEventID.RESUME_FAX_JOB, faxJob);
    }

    @Override
    public void cancelFaxJob(FaxJob faxJob) {
        this.invokeFaxJobIDValidation(faxJob);
        this.cancelFaxJobImpl(faxJob);
        this.fireFaxEvent(FaxClientActionEvent.FaxClientActionEventID.CANCEL_FAX_JOB, faxJob);
    }

    @Override
    public FaxJobStatus getFaxJobStatus(FaxJob faxJob) {
        this.invokeFaxJobIDValidation(faxJob);
        FaxJobStatus faxJobStatus = this.getFaxJobStatusImpl(faxJob);
        return faxJobStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addFaxClientActionEventListener(FaxClientActionEventListener listener) {
        Set<FaxClientActionEventListener> set = this.faxClientActionEventListeners;
        synchronized (set) {
            this.faxClientActionEventListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeFaxClientActionEventListener(FaxClientActionEventListener listener) {
        Set<FaxClientActionEventListener> set = this.faxClientActionEventListeners;
        synchronized (set) {
            this.faxClientActionEventListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAllFaxClientActionEventListeners() {
        Set<FaxClientActionEventListener> set = this.faxClientActionEventListeners;
        synchronized (set) {
            this.faxClientActionEventListeners.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addFaxMonitorEventListener(FaxMonitorEventListener listener) {
        boolean faxMonitorEventsSupported = this.isFaxMonitorEventsSupported();
        if (faxMonitorEventsSupported) {
            Set<FaxMonitorEventListener> set = this.faxMonitorEventListeners;
            synchronized (set) {
                this.faxMonitorEventListeners.add(listener);
            }
        } else {
            this.throwUnsupportedException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeFaxMonitorEventListener(FaxMonitorEventListener listener) {
        Set<FaxMonitorEventListener> set = this.faxMonitorEventListeners;
        synchronized (set) {
            this.faxMonitorEventListeners.remove(listener);
            this.checkAndStopMonitoringAllFaxJobs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAllFaxMonitorEventListeners() {
        Set<FaxMonitorEventListener> set = this.faxMonitorEventListeners;
        synchronized (set) {
            this.faxMonitorEventListeners.clear();
            this.checkAndStopMonitoringAllFaxJobs();
        }
    }

    private synchronized void checkAndStopMonitoringAllFaxJobs() {
        if (this.isFaxMonitorEventsSupported() && this.faxMonitorEventListeners.size() == 0) {
            this.spiFaxJobMonitor.stopMonitoringAllFaxJobs(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireFaxEvent(FaxClientActionEvent.FaxClientActionEventID id, FaxJob faxJob) {
        FaxClientActionEvent event = new FaxClientActionEvent(id, faxJob);
        FaxClientActionEventListener[] listeners = null;
        Set<FaxClientActionEventListener> set = this.faxClientActionEventListeners;
        synchronized (set) {
            listeners = this.faxClientActionEventListeners.toArray(new FaxClientActionEventListener[this.faxClientActionEventListeners.size()]);
        }
        int amount = listeners.length;
        FaxClientActionEventListener listener = null;
        block10: for (int index = 0; index < amount; ++index) {
            listener = listeners[index];
            if (listener == null) continue;
            switch (id) {
                case CREATE_FAX_JOB: {
                    listener.faxJobCreated(event);
                    continue block10;
                }
                case SUBMIT_FAX_JOB: {
                    listener.faxJobSubmitted(event);
                    continue block10;
                }
                case SUSPEND_FAX_JOB: {
                    listener.faxJobSuspended(event);
                    continue block10;
                }
                case RESUME_FAX_JOB: {
                    listener.faxJobResumed(event);
                    continue block10;
                }
                case CANCEL_FAX_JOB: {
                    listener.faxJobCancelled(event);
                    continue block10;
                }
                default: {
                    throw new FaxException("Unable to support fax event, for event ID: " + (Object)((Object)id));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireFaxEvent(FaxMonitorEvent.FaxMonitorEventID id, FaxJob faxJob, FaxJobStatus faxJobStatus) {
        FaxMonitorEvent event = new FaxMonitorEvent(id, faxJob, faxJobStatus);
        FaxMonitorEventListener[] listeners = null;
        Set<FaxClientActionEventListener> set = this.faxClientActionEventListeners;
        synchronized (set) {
            listeners = this.faxMonitorEventListeners.toArray(new FaxMonitorEventListener[this.faxMonitorEventListeners.size()]);
        }
        int amount = listeners.length;
        FaxMonitorEventListener listener = null;
        block6: for (int index = 0; index < amount; ++index) {
            listener = listeners[index];
            if (listener == null) continue;
            switch (id) {
                case FAX_JOB_STATUS_CHANGE: {
                    listener.faxJobStatusChanged(event);
                    continue block6;
                }
                default: {
                    throw new FaxException("Unable to support fax event, for event ID: " + (Object)((Object)id));
                }
            }
        }
    }

    protected void invokeFaxJobNullValidation(FaxJob faxJob) {
        if (faxJob == null) {
            throw new FaxException("Fax job not provided.");
        }
    }

    protected void invokeFaxJobIDValidation(FaxJob faxJob) {
        this.invokeFaxJobNullValidation(faxJob);
        String faxJobID = faxJob.getID();
        if (faxJobID == null || faxJobID.length() == 0) {
            throw new FaxException("Fax job ID not provided.");
        }
    }

    protected void throwUnsupportedException() {
        throw new FaxException("Operation not supported.");
    }

    protected FaxJob createFaxJobImpl() {
        FaxJobImpl faxJob = new FaxJobImpl();
        faxJob.setPriority(FaxJob.FaxJobPriority.MEDIUM_PRIORITY);
        return faxJob;
    }

    protected abstract void initializeImpl();

    protected abstract void submitFaxJobImpl(FaxJob var1);

    protected abstract void suspendFaxJobImpl(FaxJob var1);

    protected abstract void resumeFaxJobImpl(FaxJob var1);

    protected abstract void cancelFaxJobImpl(FaxJob var1);

    protected abstract FaxJobStatus getFaxJobStatusImpl(FaxJob var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FaxJobExtendedPropertyConstants {
        TEXT_FILE_ENCODING_FAX_JOB_PROPERTY_KEY("text.file.encoding");

        private String value;

        private FaxJobExtendedPropertyConstants(String value) {
            this.value = value;
        }

        public final String toString() {
            return this.value;
        }
    }
}

