/*
 * Decompiled with CFR 0.152.
 */
package org.fax4j.spi;

import java.lang.reflect.Method;
import org.fax4j.FaxException;
import org.fax4j.common.Logger;
import org.fax4j.spi.FaxClientSpi;
import org.fax4j.spi.FaxClientSpiInterceptor;
import org.fax4j.spi.FaxClientSpiProxy;

public abstract class AbstractFaxClientSpiProxy
implements FaxClientSpiProxy {
    private boolean initialized = false;
    private FaxClientSpi faxClientSpiInstance;
    private FaxClientSpiInterceptor[] faxClientSpiInterceptors;

    public final void initialize(FaxClientSpi faxClientSpi, FaxClientSpiInterceptor[] interceptors) {
        if (this.initialized) {
            throw new FaxException("Fax client SPI proxy already initialized.");
        }
        this.initialized = true;
        this.faxClientSpiInstance = faxClientSpi;
        if (interceptors == null) {
            this.faxClientSpiInterceptors = new FaxClientSpiInterceptor[0];
        } else {
            int amount = interceptors.length;
            this.faxClientSpiInterceptors = new FaxClientSpiInterceptor[amount];
            System.arraycopy(interceptors, 0, this.faxClientSpiInterceptors, 0, amount);
        }
        this.initializeImpl();
    }

    protected final FaxClientSpiInterceptor[] getFaxClientSpiInterceptors() {
        return this.faxClientSpiInterceptors;
    }

    protected final FaxClientSpi getFaxClientSpi() {
        return this.faxClientSpiInstance;
    }

    public final String getConfigurationValue(String key) {
        return this.faxClientSpiInstance.getConfigurationValue(key);
    }

    public final Logger getLogger() {
        return this.faxClientSpiInstance.getLogger();
    }

    public Object invoke(Object proxy, Method method, Object[] arguments) throws Throwable {
        this.invokeInterceptors(FaxClientSpiProxy.FaxClientSpiProxyEventType.PRE_EVENT_TYPE, method, arguments, null, null);
        Object output = null;
        Throwable generalError = null;
        try {
            output = method.invoke((Object)this.faxClientSpiInstance, arguments);
            this.invokeInterceptors(FaxClientSpiProxy.FaxClientSpiProxyEventType.POST_EVENT_TYPE, method, arguments, output, null);
        }
        catch (Throwable throwable) {
            generalError = throwable.getCause();
            if (generalError == null) {
                generalError = throwable;
            }
            this.invokeInterceptors(FaxClientSpiProxy.FaxClientSpiProxyEventType.ERROR_EVENT_TYPE, method, arguments, null, generalError);
        }
        if (generalError != null) {
            throw generalError;
        }
        return output;
    }

    protected abstract void initializeImpl();

    protected abstract void invokeInterceptors(FaxClientSpiProxy.FaxClientSpiProxyEventType var1, Method var2, Object[] var3, Object var4, Throwable var5);
}

