/*
 * Decompiled with CFR 0.152.
 */
package org.fax4j.spi;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.fax4j.FaxException;
import org.fax4j.FaxJob;
import org.fax4j.common.Logger;
import org.fax4j.spi.FaxClientSpi;
import org.fax4j.spi.FaxJobMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFaxJobMonitor
implements FaxJobMonitor {
    private boolean initialized;
    private Map<String, String> monitorConfiguration;
    private Logger monitorLogger;

    @Override
    public void initialize(Map<String, String> configuration, Logger logger) {
        if (this.initialized) {
            throw new FaxException("Fax job monitor already initialized.");
        }
        this.initialized = true;
        this.monitorConfiguration = new HashMap<String, String>(configuration);
        this.monitorConfiguration = Collections.unmodifiableMap(this.monitorConfiguration);
        this.monitorLogger = logger;
        this.monitorLogger.logDebug(new Object[]{"Initializing fax job monitor of type: ", this.getClass().getName(), "\nMonitor Configuration:\n", configuration}, null);
        this.initializeImpl();
    }

    protected final Logger getLogger() {
        return this.monitorLogger;
    }

    protected final String getConfigurationValue(String key) {
        String value = this.monitorConfiguration.get(key);
        if (value != null && (value = value.trim()).length() == 0) {
            value = null;
        }
        this.monitorLogger.logDebug(new Object[]{"Extracted configuration for key: ", key, " value: ", value}, null);
        return value;
    }

    @Override
    public void monitorFaxJob(FaxClientSpi faxClientSpi, FaxJob faxJob) {
        if (faxClientSpi == null) {
            throw new FaxException("Fax client SPI not provided.");
        }
        if (faxJob == null) {
            throw new FaxException("Fax job not provided.");
        }
        String id = faxJob.getID();
        if (id == null || id.length() == 0) {
            throw new FaxException("Missing fax job ID in provided fax job.");
        }
        this.monitorFaxJobImpl(faxClientSpi, faxJob);
    }

    @Override
    public void stopMonitoringAllFaxJobs(FaxClientSpi faxClientSpi) {
        if (faxClientSpi == null) {
            throw new FaxException("Fax client SPI not provided.");
        }
        this.stopMonitoringAllFaxJobsImpl(faxClientSpi);
    }

    protected abstract void initializeImpl();

    public abstract void monitorFaxJobImpl(FaxClientSpi var1, FaxJob var2);

    public abstract void stopMonitoringAllFaxJobsImpl(FaxClientSpi var1);
}

