/*
 * Decompiled with CFR 0.152.
 */
package org.fax4j.spi;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import org.fax4j.FaxException;
import org.fax4j.ProductInfo;
import org.fax4j.Provider;
import org.fax4j.common.Logger;
import org.fax4j.common.LoggerManager;
import org.fax4j.spi.FaxClientSpi;
import org.fax4j.spi.FaxClientSpiInterceptor;
import org.fax4j.spi.FaxClientSpiProxy;
import org.fax4j.spi.FaxClientSpiProxyImpl;
import org.fax4j.spi.FaxJobMonitor;
import org.fax4j.spi.FaxJobMonitorImpl;
import org.fax4j.util.LibraryConfigurationLoader;
import org.fax4j.util.ReflectionHelper;
import org.fax4j.util.SpiUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FaxClientSpiFactory {
    private static Logger logger;
    private static FaxJobMonitor faxJobMonitor;
    public static final String FAX_JOB_MONITOR_CLASS_NAME_PROPERTY_KEY = "org.fax4j.monitor.class.name";
    public static final String DEFAULT_SPI_TYPE_PROPERTY_KEY = "org.fax4j.spi.default.type";
    public static final String SPI_CLASS_NAME_TYPE_MAP_PROPERTY_KEY_PREFIX = "org.fax4j.spi.type.map.";
    public static final String SPI_PROXY_ENABLED_PROPERTY_KEY = "org.fax4j.proxy.enabled";
    public static final String SPI_PROXY_CLASS_NAME_PROPERTY_KEY = "org.fax4j.proxy.class.name";
    public static final String SPI_INTERCEPTOR_LIST_PROPERTY_KEY = "org.fax4j.proxy.interceptor.list";
    public static final String SPI_INTERCEPTOR_TYPE_PROPERTY_KEY_PREFIX = "org.fax4j.proxy.interceptor.type.";
    public static final String SPI_INTERCEPTOR_LIST_SEPARATOR = ";";

    private FaxClientSpiFactory() {
    }

    public static FaxClientSpi createFaxClientSpi(String type, Properties configuration) {
        FaxClientSpi faxClientSpi = FaxClientSpiFactory.createFaxClientSpiImpl(type, configuration, false);
        return faxClientSpi;
    }

    public static FaxClientSpi createChildFaxClientSpi(String type, Properties configuration) {
        FaxClientSpi faxClientSpi = FaxClientSpiFactory.createFaxClientSpiImpl(type, configuration, true);
        return faxClientSpi;
    }

    private static FaxClientSpi createFaxClientSpiImpl(String type, Properties configuration, boolean childSPI) {
        Provider provider;
        Map<String, String> layeredConfiguration = FaxClientSpiFactory.getConfiguration(configuration);
        String updatedType = type;
        if (!(updatedType != null && updatedType.length() != 0 || (updatedType = layeredConfiguration.get(DEFAULT_SPI_TYPE_PROPERTY_KEY)) != null && updatedType.length() != 0)) {
            throw new FaxException("Type value not provided and not configured in fax4j.properties");
        }
        String key = SPI_CLASS_NAME_TYPE_MAP_PROPERTY_KEY_PREFIX + updatedType;
        String className = layeredConfiguration.get(key);
        if (className == null || className.length() == 0) {
            throw new FaxException("Class name for type: " + updatedType + " not configured in fax4j.properties");
        }
        Logger spiLogger = FaxClientSpiFactory.getLogger();
        FaxJobMonitor spiFaxJobMonitor = FaxClientSpiFactory.getFaxJobMonitor();
        FaxClientSpi faxClientSpi = (FaxClientSpi)ReflectionHelper.createInstance(className);
        faxClientSpi.initialize(layeredConfiguration, spiLogger, spiFaxJobMonitor);
        FaxClientSpi faxClientSpiWrapper = faxClientSpi;
        if (!childSPI) {
            boolean enableProxy;
            String valueStr = faxClientSpi.getConfigurationValue(SPI_PROXY_ENABLED_PROPERTY_KEY);
            if (valueStr == null) {
                valueStr = Boolean.toString(true);
            }
            if (enableProxy = Boolean.parseBoolean(valueStr)) {
                FaxClientSpiProxy faxClientSpiProxy = FaxClientSpiFactory.createFaxClientSpiProxy(faxClientSpi);
                ClassLoader classLoader = ReflectionHelper.getThreadContextClassLoader();
                faxClientSpiWrapper = (FaxClientSpi)Proxy.newProxyInstance(classLoader, new Class[]{FaxClientSpi.class}, (InvocationHandler)faxClientSpiProxy);
            }
        }
        if ((provider = faxClientSpiWrapper.getProvider()) == null) {
            throw new FaxException("Provider information not available in SPI.");
        }
        String name = provider.getName();
        if (name == null) {
            throw new FaxException("Provider name not available in SPI.");
        }
        return faxClientSpiWrapper;
    }

    protected static Map<String, String> getConfiguration(Properties configuration) {
        Map<String, String> systemConfig = LibraryConfigurationLoader.getSystemConfiguration();
        HashMap<String, String> layeredConfiguration = new HashMap<String, String>(systemConfig);
        if (configuration != null) {
            SpiUtil.copyPropertiesToMap(configuration, layeredConfiguration);
        }
        return layeredConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Logger getLogger() {
        if (logger != null) return logger;
        Class<FaxClientSpiFactory> clazz = FaxClientSpiFactory.class;
        synchronized (FaxClientSpiFactory.class) {
            if (logger != null) return logger;
            LoggerManager loggerManager = LoggerManager.getInstance();
            Logger localLogger = loggerManager.getLogger();
            localLogger.logDebug(new Object[]{ProductInfo.getProductInfoPrintout()}, null);
            logger = localLogger;
            // ** MonitorExit[var0] (shouldn't be in output)
            return logger;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static FaxJobMonitor getFaxJobMonitor() {
        Map<String, String> systemConfig = LibraryConfigurationLoader.getSystemConfiguration();
        if (faxJobMonitor != null) return faxJobMonitor;
        Class<FaxClientSpiFactory> clazz = FaxClientSpiFactory.class;
        synchronized (FaxClientSpiFactory.class) {
            if (faxJobMonitor != null) return faxJobMonitor;
            FaxJobMonitor localFaxJobMonitor = FaxClientSpiFactory.createFaxJobMonitor(systemConfig);
            Logger localLogger = FaxClientSpiFactory.getLogger();
            localFaxJobMonitor.initialize(systemConfig, localLogger);
            faxJobMonitor = localFaxJobMonitor;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return faxJobMonitor;
        }
    }

    private static FaxJobMonitor createFaxJobMonitor(Map<String, String> systemConfig) {
        String className = systemConfig.get(FAX_JOB_MONITOR_CLASS_NAME_PROPERTY_KEY);
        if (className == null || className.length() == 0) {
            className = FaxJobMonitorImpl.class.getName();
        }
        FaxJobMonitor faxJobMonitorInstance = (FaxJobMonitor)ReflectionHelper.createInstance(className);
        return faxJobMonitorInstance;
    }

    private static FaxClientSpiProxy createFaxClientSpiProxy(FaxClientSpi faxClientSpi) {
        FaxClientSpiInterceptor[] interceptors = FaxClientSpiFactory.createFaxClientSpiInterceptors(faxClientSpi);
        String className = faxClientSpi.getConfigurationValue(SPI_PROXY_CLASS_NAME_PROPERTY_KEY);
        if (className == null) {
            className = FaxClientSpiProxyImpl.class.getName();
        }
        FaxClientSpiProxy faxClientSpiProxy = (FaxClientSpiProxy)ReflectionHelper.createInstance(className);
        faxClientSpiProxy.initialize(faxClientSpi, interceptors);
        return faxClientSpiProxy;
    }

    private static FaxClientSpiInterceptor[] createFaxClientSpiInterceptors(FaxClientSpi faxClientSpi) {
        String typeListStr = faxClientSpi.getConfigurationValue(SPI_INTERCEPTOR_LIST_PROPERTY_KEY);
        FaxClientSpiInterceptor[] interceptors = null;
        if (typeListStr != null) {
            String[] types = typeListStr.split(SPI_INTERCEPTOR_LIST_SEPARATOR);
            int amount = types.length;
            String type = null;
            String propertyKey = null;
            String className = null;
            FaxClientSpiInterceptor interceptor = null;
            LinkedList<FaxClientSpiInterceptor> interceptorList = new LinkedList<FaxClientSpiInterceptor>();
            for (int index = 0; index < amount; ++index) {
                type = types[index];
                if (type != null && type.length() > 0) {
                    propertyKey = SPI_INTERCEPTOR_TYPE_PROPERTY_KEY_PREFIX + type;
                    className = faxClientSpi.getConfigurationValue(propertyKey);
                    if (className == null) {
                        throw new FaxException("Class name not defined by property: " + propertyKey + " for SPI interceptor.");
                    }
                    interceptor = (FaxClientSpiInterceptor)ReflectionHelper.createInstance(className);
                    interceptor.initialize(faxClientSpi);
                    interceptorList.add(interceptor);
                }
                interceptors = interceptorList.toArray(new FaxClientSpiInterceptor[interceptorList.size()]);
            }
        }
        return interceptors;
    }
}

