/*
 * Decompiled with CFR 0.152.
 */
package org.fax4j.spi;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.fax4j.FaxException;
import org.fax4j.FaxJob;
import org.fax4j.FaxJobStatus;
import org.fax4j.FaxMonitorEvent;
import org.fax4j.spi.AbstractFaxJobMonitor;
import org.fax4j.spi.FaxClientSpi;

public class FaxJobMonitorImpl
extends AbstractFaxJobMonitor {
    protected long pollingInterval;
    protected boolean fixedPollingInterval;
    protected int pollingThreadPriority;
    protected PollerTask pollerTask;
    private Map<FaxClientSpi, Map<FaxJob, FaxJobStatus>> data;
    protected final Object LOCK = new Object();
    public static final String POLLING_INTERVAL_IN_MILLIES_PROPERTY_KEY = "org.fax4j.monitor.polling.interval";
    public static final String FIXED_POLLING_INTERVAL_PROPERTY_KEY = "org.fax4j.monitor.polling.interval.fixed";
    public static final String POLLING_THREAD_PRIORITY_PROPERTY_KEY = "org.fax4j.monitor.polling.thread.priority";

    protected void initializeImpl() {
        this.data = new HashMap<FaxClientSpi, Map<FaxJob, FaxJobStatus>>(20);
        String value = this.getConfigurationValue(POLLING_INTERVAL_IN_MILLIES_PROPERTY_KEY);
        this.pollingInterval = 5000L;
        if (value != null) {
            this.pollingInterval = Long.parseLong(value);
            if (this.pollingInterval <= 0L) {
                throw new FaxException("Polling interval set to an invalid value: " + this.pollingInterval);
            }
        }
        value = this.getConfigurationValue(FIXED_POLLING_INTERVAL_PROPERTY_KEY);
        this.fixedPollingInterval = Boolean.parseBoolean(value);
        value = this.getConfigurationValue(POLLING_THREAD_PRIORITY_PROPERTY_KEY);
        this.pollingThreadPriority = 2;
        if (value != null) {
            this.pollingThreadPriority = Integer.parseInt(value);
            if (this.pollingThreadPriority < 1 || this.pollingThreadPriority > 10) {
                throw new FaxException("Polling thread priority set to an invalid value: " + this.pollingThreadPriority);
            }
        }
        this.pollerTask = new PollerTask(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void monitorFaxJobImpl(FaxClientSpi faxClientSpi, FaxJob faxJob) {
        FaxJobStatus faxJobStatus = faxClientSpi.getFaxJobStatus(faxJob);
        if (faxJobStatus == null) {
            throw new FaxException("Unable to extract fax job status for fax job: " + faxJob.getID());
        }
        Object object = this.LOCK;
        synchronized (object) {
            Map<FaxJob, FaxJobStatus> faxJobMap = this.data.get(faxClientSpi);
            if (faxJobMap == null) {
                faxJobMap = new HashMap<FaxJob, FaxJobStatus>(500);
                this.data.put(faxClientSpi, faxJobMap);
            }
            faxJobMap.put(faxJob, faxJobStatus);
            if (!this.pollerTask.isRunning()) {
                this.pollerTask.startTask();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopMonitoringAllFaxJobsImpl(FaxClientSpi faxClientSpi) {
        Object object = this.LOCK;
        synchronized (object) {
            this.data.remove(faxClientSpi);
        }
        this.checkAndStopMonitor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runPollingCycle() {
        Object object = this.LOCK;
        synchronized (object) {
            Set<Map.Entry<FaxClientSpi, Map<FaxJob, FaxJobStatus>>> entrySet = this.data.entrySet();
            Iterator<Map.Entry<FaxClientSpi, Map<FaxJob, FaxJobStatus>>> faxClientSpiIterator = entrySet.iterator();
            Map.Entry<FaxClientSpi, Map<FaxJob, FaxJobStatus>> faxClientSpiEntry = null;
            FaxClientSpi faxClientSpi = null;
            Map<FaxJob, FaxJobStatus> faxJobMap = null;
            Iterator<Map.Entry<FaxJob, FaxJobStatus>> faxJobIterator = null;
            Map.Entry<FaxJob, FaxJobStatus> faxJobEntry = null;
            FaxJob[] faxJobs = null;
            FaxJobStatus[] previousFaxJobStatuses = null;
            FaxJobStatus[] currentFaxJobStatuses = null;
            FaxJob faxJob = null;
            FaxJobStatus previousFaxJobStatus = null;
            FaxJobStatus currentFaxJobStatus = null;
            int counter = 0;
            while (faxClientSpiIterator.hasNext()) {
                faxClientSpiEntry = faxClientSpiIterator.next();
                faxClientSpi = faxClientSpiEntry.getKey();
                faxJobMap = faxClientSpiEntry.getValue();
                faxJobIterator = faxJobMap.entrySet().iterator();
                int amount = faxJobMap.size();
                if (amount > 0) {
                    faxJobs = new FaxJob[amount];
                    previousFaxJobStatuses = new FaxJobStatus[amount];
                    counter = 0;
                    while (faxJobIterator.hasNext()) {
                        faxJobEntry = faxJobIterator.next();
                        faxJob = faxJobEntry.getKey();
                        previousFaxJobStatus = faxJobEntry.getValue();
                        faxJobs[counter] = faxJob;
                        previousFaxJobStatuses[counter] = previousFaxJobStatus;
                        ++counter;
                    }
                    currentFaxJobStatuses = faxClientSpi.pollForFaxJobStatues(faxJobs);
                    if (currentFaxJobStatuses != null && currentFaxJobStatuses.length == amount) {
                        block8: for (int index = 0; index < amount; ++index) {
                            currentFaxJobStatus = currentFaxJobStatuses[index];
                            if (currentFaxJobStatus == null) continue;
                            faxJob = faxJobs[index];
                            previousFaxJobStatus = previousFaxJobStatuses[index];
                            if (!previousFaxJobStatus.equals((Object)currentFaxJobStatus)) {
                                faxJobMap.put(faxJob, currentFaxJobStatus);
                                faxClientSpi.fireFaxMonitorEvent(FaxMonitorEvent.FaxMonitorEventID.FAX_JOB_STATUS_CHANGE, faxJob, currentFaxJobStatus);
                            }
                            switch (currentFaxJobStatus) {
                                case UNKNOWN: 
                                case ERROR: {
                                    faxJobMap.remove(faxJob);
                                    continue block8;
                                }
                            }
                        }
                    }
                }
                if (!faxJobMap.isEmpty()) continue;
                faxClientSpiIterator.remove();
            }
        }
        this.checkAndStopMonitor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAndStopMonitor() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.data.isEmpty()) {
                this.pollerTask.setRunning(false);
            }
        }
    }

    public static class PollerTask
    implements Runnable {
        private boolean running;
        private final FaxJobMonitorImpl FAX_JOB_MONITOR;

        public PollerTask(FaxJobMonitorImpl faxJobMonitor) {
            this.FAX_JOB_MONITOR = faxJobMonitor;
            this.setRunning(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void setRunning(boolean running) {
            PollerTask pollerTask = this;
            synchronized (pollerTask) {
                this.running = running;
                this.notifyAll();
            }
        }

        public final boolean isRunning() {
            return this.running;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void startTask() {
            if (!this.isRunning()) {
                PollerTask pollerTask = this;
                synchronized (pollerTask) {
                    this.setRunning(true);
                    Thread thread = new Thread((Runnable)this, "Fax Monitor");
                    thread.setPriority(this.FAX_JOB_MONITOR.pollingThreadPriority);
                    thread.setDaemon(true);
                    thread.start();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void run() {
            long startTime = -1L;
            long waitTime = 0L;
            long cycleTime = this.FAX_JOB_MONITOR.pollingInterval;
            while (this.isRunning()) {
                startTime = System.currentTimeMillis();
                this.FAX_JOB_MONITOR.runPollingCycle();
                waitTime = cycleTime;
                if (!this.FAX_JOB_MONITOR.fixedPollingInterval) {
                    waitTime -= System.currentTimeMillis() - startTime;
                }
                if (waitTime <= 0L) continue;
                PollerTask pollerTask = this;
                synchronized (pollerTask) {
                    try {
                        this.wait(waitTime);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

