/*
 * Decompiled with CFR 0.152.
 */
package org.fax4j.spi;

import java.lang.reflect.Method;
import org.fax4j.common.Logger;
import org.fax4j.spi.AbstractFaxClientSpiInterceptor;
import org.fax4j.spi.FaxClientSpiProxy;

public class LogFaxClientSpiInterceptor
extends AbstractFaxClientSpiInterceptor {
    protected void initializeImpl() {
    }

    protected void logEvent(FaxClientSpiProxy.FaxClientSpiProxyEventType eventType, Method method, Object[] arguments, Object output, Throwable throwable) {
        int amount = 3;
        int argumentsAmount = 0;
        if (arguments != null) {
            argumentsAmount = arguments.length;
        }
        if (eventType == FaxClientSpiProxy.FaxClientSpiProxyEventType.POST_EVENT_TYPE) {
            amount += 2;
        }
        Object[] logData = new Object[amount + argumentsAmount];
        switch (eventType) {
            case PRE_EVENT_TYPE: {
                logData[0] = "Invoking ";
                break;
            }
            case POST_EVENT_TYPE: {
                logData[0] = "Invoked ";
                break;
            }
            case ERROR_EVENT_TYPE: {
                logData[0] = "Error while invoking ";
            }
        }
        logData[1] = method.getName();
        if (argumentsAmount > 0) {
            logData[2] = " with data: ";
            System.arraycopy(arguments, 0, logData, 3, argumentsAmount);
        } else {
            logData[2] = "";
        }
        if (eventType == FaxClientSpiProxy.FaxClientSpiProxyEventType.POST_EVENT_TYPE) {
            logData[3 + argumentsAmount] = "\nOutput: ";
            logData[4 + argumentsAmount] = output;
        }
        Logger logger = this.getLogger();
        switch (eventType) {
            case PRE_EVENT_TYPE: 
            case POST_EVENT_TYPE: {
                logger.logDebug(logData, throwable);
                break;
            }
            case ERROR_EVENT_TYPE: {
                logger.logError(logData, throwable);
            }
        }
    }

    public final void preMethodInvocation(Method method, Object[] arguments) {
        this.logEvent(FaxClientSpiProxy.FaxClientSpiProxyEventType.PRE_EVENT_TYPE, method, arguments, null, null);
    }

    public final void postMethodInvocation(Method method, Object[] arguments, Object output) {
        this.logEvent(FaxClientSpiProxy.FaxClientSpiProxyEventType.POST_EVENT_TYPE, method, arguments, output, null);
    }

    public final void onMethodInvocationError(Method method, Object[] arguments, Throwable throwable) {
        this.logEvent(FaxClientSpiProxy.FaxClientSpiProxyEventType.ERROR_EVENT_TYPE, method, arguments, null, throwable);
    }
}

