/*
 * Decompiled with CFR 0.152.
 */
package org.fax4j.spi.adapter;

import org.fax4j.FaxException;
import org.fax4j.FaxJob;
import org.fax4j.FaxJobStatus;
import org.fax4j.common.Logger;
import org.fax4j.spi.AbstractFax4JClientSpi;
import org.fax4j.spi.FaxClientSpi;

public abstract class AbstractAdapterFaxClientSpi
extends AbstractFax4JClientSpi {
    protected FaxClientSpi faxClientSpi;

    protected void initializeImpl() {
        this.initializeChildFaxClientSpi();
        if (this.faxClientSpi == null) {
            throw new FaxException("Child fax client SPI not available.");
        }
        Logger logger = this.getLogger();
        logger.logDebug(new Object[]{"Created child fax client SPI: ", this.faxClientSpi.getClass().getName()}, null);
    }

    protected FaxClientSpi getInternalFaxClientSpi() {
        return this.faxClientSpi;
    }

    public boolean isFaxMonitorEventsSupported() {
        return this.faxClientSpi.isFaxMonitorEventsSupported();
    }

    protected FaxJob createFaxJobImpl() {
        return this.faxClientSpi.createFaxJob();
    }

    protected void submitFaxJobImpl(FaxJob faxJob) {
        this.faxClientSpi.submitFaxJob(faxJob);
    }

    protected void suspendFaxJobImpl(FaxJob faxJob) {
        this.faxClientSpi.suspendFaxJob(faxJob);
    }

    protected void resumeFaxJobImpl(FaxJob faxJob) {
        this.faxClientSpi.resumeFaxJob(faxJob);
    }

    protected void cancelFaxJobImpl(FaxJob faxJob) {
        this.faxClientSpi.cancelFaxJob(faxJob);
    }

    protected FaxJobStatus getFaxJobStatusImpl(FaxJob faxJob) {
        return this.faxClientSpi.getFaxJobStatus(faxJob);
    }

    protected FaxJobStatus[] pollForFaxJobStatuesImpl(FaxJob[] faxJobs) {
        return this.faxClientSpi.pollForFaxJobStatues(faxJobs);
    }

    protected abstract void initializeChildFaxClientSpi();
}

