/*
 * Decompiled with CFR 0.152.
 */
package org.fax4j.spi.adapter;

import java.io.File;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.fax4j.FaxException;
import org.fax4j.common.Logger;
import org.fax4j.spi.FaxClientSpiFactory;
import org.fax4j.spi.adapter.AbstractAdapterFaxClientSpi;
import org.fax4j.util.ReflectionHelper;

public class AdapterFaxClientSpi
extends AbstractAdapterFaxClientSpi {
    protected void initializeChildFaxClientSpi() {
        Logger logger = this.getLogger();
        String types = this.getConfigurationValue(FaxClientSpiConfigurationConstants.SPI_TYPES_PROPERTY_KEY);
        logger.logDebug(new Object[]{FaxClientSpiConfigurationConstants.SPI_TYPES_PROPERTY_KEY, " value is ", types}, null);
        if (types != null) {
            String[] typeValues = types.split(FaxClientSpiConfigurationConstants.PROPERTY_VALUE_LIST_SEPARATOR.toString());
            int amount = typeValues.length;
            String typeValue = null;
            String conditionString = null;
            String[] conditionBlocks = null;
            String conditionBlock = null;
            String[] conditionBlockValues = null;
            String conditionKey = null;
            String conditionValue = null;
            int subAmount = -1;
            boolean conditionValid = true;
            StringBuilder conditionStringBuffer = new StringBuilder();
            for (int index = 0; index < amount; ++index) {
                typeValue = typeValues[index];
                logger.logDebug(new Object[]{"Checking conditions for type: ", typeValue}, null);
                conditionString = this.getConfigurationValue((Object)((Object)FaxClientSpiConfigurationConstants.SPI_CONDITION_PROPERTY_KEY_PREFIX) + typeValue);
                logger.logDebug(new Object[]{"Configured condition for type: ", typeValue, " is set to: ", conditionString}, null);
                conditionStringBuffer.delete(0, conditionStringBuffer.length());
                conditionStringBuffer.append((Object)FaxClientSpiConfigurationConstants.PROPERTY_CONDITION);
                conditionStringBuffer.append((Object)FaxClientSpiConfigurationConstants.PROPERTY_BLOCK_VALUE_SEPARATOR);
                conditionStringBuffer.append("org.fax4j.spi.type.map.");
                conditionStringBuffer.append(typeValue);
                conditionStringBuffer.append((Object)FaxClientSpiConfigurationConstants.PROPERTY_VALUE_LIST_SEPARATOR);
                conditionStringBuffer.append((Object)FaxClientSpiConfigurationConstants.JAVA_CLASS_CONDITION);
                conditionStringBuffer.append((Object)FaxClientSpiConfigurationConstants.PROPERTY_BLOCK_VALUE_SEPARATOR);
                conditionStringBuffer.append(this.getConfigurationValue("org.fax4j.spi.type.map." + typeValue));
                conditionStringBuffer.append((Object)FaxClientSpiConfigurationConstants.PROPERTY_VALUE_LIST_SEPARATOR);
                conditionStringBuffer.append((Object)FaxClientSpiConfigurationConstants.STABLE_CONDITION);
                conditionStringBuffer.append((Object)FaxClientSpiConfigurationConstants.PROPERTY_BLOCK_VALUE_SEPARATOR);
                conditionStringBuffer.append(typeValue);
                if (conditionString != null) {
                    conditionStringBuffer.append((Object)FaxClientSpiConfigurationConstants.PROPERTY_VALUE_LIST_SEPARATOR);
                    conditionStringBuffer.append(conditionString);
                }
                conditionString = conditionStringBuffer.toString();
                logger.logDebug(new Object[]{"Updated condition for type: ", typeValue, " is set to: ", conditionString}, null);
                conditionBlocks = conditionString.split(FaxClientSpiConfigurationConstants.PROPERTY_VALUE_LIST_SEPARATOR.toString());
                subAmount = conditionBlocks.length;
                conditionValid = true;
                for (int blockIndex = 0; blockIndex < subAmount; ++blockIndex) {
                    conditionBlock = conditionBlocks[blockIndex];
                    conditionBlockValues = conditionBlock.split(FaxClientSpiConfigurationConstants.PROPERTY_BLOCK_VALUE_SEPARATOR.toString());
                    if (conditionBlockValues.length != 2) {
                        throw new FaxException("Condition block must contain 2 parts separated by " + (Object)((Object)FaxClientSpiConfigurationConstants.PROPERTY_BLOCK_VALUE_SEPARATOR));
                    }
                    conditionKey = conditionBlockValues[0];
                    conditionValue = conditionBlockValues[1];
                    logger.logDebug(new Object[]{"Validating condition for type: ", typeValue, " key: ", conditionKey, " value: ", conditionValue}, null);
                    if (this.validateCondition(conditionKey, conditionValue)) continue;
                    conditionValid = false;
                    break;
                }
                if (!conditionValid) continue;
                logger.logDebug(new Object[]{"Conditions validated for type: ", typeValue}, null);
                this.createFaxClientSpi(typeValue);
                break;
            }
        }
        if (this.faxClientSpi == null) {
            throw new FaxException("No internal SPI available.");
        }
    }

    protected boolean validateCondition(String key, String value) {
        boolean valid = false;
        FaxClientSpiConfigurationConstants condition = FaxClientSpiConfigurationConstants.getEnum(key);
        String propertyValue = null;
        switch (condition) {
            case PROPERTY_CONDITION: {
                propertyValue = this.getConfigurationValue(value);
                if (propertyValue == null) break;
                valid = true;
                break;
            }
            case OS_CONDITION: {
                String osName = System.getProperty("os.name");
                osName = osName.toLowerCase();
                String updatedValue = value.toLowerCase();
                if (!osName.contains(updatedValue)) break;
                valid = true;
                break;
            }
            case JAVA_CLASS_CONDITION: {
                try {
                    ReflectionHelper.getType(value);
                    valid = true;
                }
                catch (Throwable throwable) {}
                break;
            }
            case NATIVE_LIB_CONDITION: {
                try {
                    System.loadLibrary(value);
                    valid = true;
                }
                catch (Throwable throwable) {}
                break;
            }
            case EXECUTABLE_CONDITION: {
                String systemPath = System.getProperty("java.library.path");
                String[] systemPathElements = systemPath.split(System.getProperty("path.separator"));
                int amount = systemPathElements.length;
                String directoryPath = null;
                File file = null;
                for (int index = 0; index < amount; ++index) {
                    directoryPath = systemPathElements[index];
                    file = new File(directoryPath, value);
                    if (!file.exists() || !file.isFile()) continue;
                    valid = true;
                }
                break;
            }
            case STABLE_CONDITION: {
                String propertyKey = (Object)((Object)FaxClientSpiConfigurationConstants.SPI_STABLE_PROPERTY_KEY_PREFIX) + value + (Object)((Object)FaxClientSpiConfigurationConstants.SPI_STABLE_PROPERTY_KEY_SUFFIX);
                propertyValue = this.getConfigurationValue(propertyKey);
                valid = Boolean.parseBoolean(propertyValue);
                break;
            }
            default: {
                throw new FaxException("Invalid condition key provided: " + key);
            }
        }
        return valid;
    }

    protected void createFaxClientSpi(String type) {
        Properties configuration = this.createFaxClientSpiConfiguration();
        this.faxClientSpi = FaxClientSpiFactory.createChildFaxClientSpi(type, configuration);
    }

    protected Properties createFaxClientSpiConfiguration() {
        Map<String, String> configuration = this.getConfiguration();
        Properties internalSPIConfiguration = new Properties();
        Properties overrideConfiguration = new Properties();
        Iterator<Map.Entry<String, String>> iterator = configuration.entrySet().iterator();
        Map.Entry<String, String> entry = null;
        String key = null;
        String value = null;
        String overrideKey = null;
        String overridePrefix = FaxClientSpiConfigurationConstants.SPI_CONFIGURATION_OVERRIDE_PROPERTY_KEY_PREFIX.toString();
        int prefixLength = overridePrefix.length();
        while (iterator.hasNext()) {
            entry = iterator.next();
            key = entry.getKey();
            value = entry.getValue();
            if (key.startsWith(overridePrefix) && key.length() != prefixLength) {
                overrideKey = key.substring(prefixLength);
                overrideConfiguration.setProperty(overrideKey, value);
            }
            internalSPIConfiguration.setProperty(key, value);
        }
        internalSPIConfiguration.putAll((Map<?, ?>)overrideConfiguration);
        return internalSPIConfiguration;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FaxClientSpiConfigurationConstants {
        SPI_TYPES_PROPERTY_KEY("org.fax4j.spi.adapter.internal.spi.types"),
        SPI_CONDITION_PROPERTY_KEY_PREFIX("org.fax4j.spi.adapter.internal.spi.condition."),
        SPI_STABLE_PROPERTY_KEY_PREFIX("org.fax4j.spi."),
        SPI_STABLE_PROPERTY_KEY_SUFFIX(".stable"),
        SPI_CONFIGURATION_OVERRIDE_PROPERTY_KEY_PREFIX("org.fax4j.spi.adapter.configuration.override."),
        PROPERTY_VALUE_LIST_SEPARATOR(";"),
        PROPERTY_BLOCK_VALUE_SEPARATOR(":"),
        PROPERTY_CONDITION("property"),
        OS_CONDITION("OS"),
        JAVA_CLASS_CONDITION("java-class"),
        NATIVE_LIB_CONDITION("native-lib"),
        EXECUTABLE_CONDITION("executable"),
        STABLE_CONDITION("stable");

        private String value;

        private FaxClientSpiConfigurationConstants(String value) {
            this.value = value;
        }

        public final String toString() {
            return this.value;
        }

        public static FaxClientSpiConfigurationConstants getEnum(String value) {
            if (value == null) {
                throw new FaxException("Null value provided.");
            }
            FaxClientSpiConfigurationConstants[] values = FaxClientSpiConfigurationConstants.values();
            int amount = values.length;
            FaxClientSpiConfigurationConstants constant = null;
            for (int index = 0; index < amount; ++index) {
                constant = values[index];
                if (!value.equalsIgnoreCase(constant.toString())) continue;
                return constant;
            }
            throw new FaxException("Illegal value provided: " + value);
        }
    }
}

