/*
 * Decompiled with CFR 0.152.
 */
package org.fax4j.spi.comm;

import java.io.IOException;
import org.fax4j.FaxException;
import org.fax4j.spi.comm.CommFaxClientSpi;
import org.fax4j.spi.comm.CommPortAdapter;
import org.fax4j.spi.comm.CommPortConnectionFactory;
import org.fax4j.util.AbstractFax4JConnectionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCommPortConnectionFactory
extends AbstractFax4JConnectionFactory<CommPortAdapter>
implements CommPortConnectionFactory {
    private String portName;
    private int timeout;

    @Override
    protected void initializeImpl() {
        this.portName = this.factoryConfigurationHolder.getConfigurationValue(CommFaxClientSpi.FaxClientSpiConfigurationConstants.PORT_NAME_PROPERTY_KEY);
        if (this.portName == null) {
            throw new FaxException("Port name not defined in fax4j.properties. Property: " + (Object)((Object)CommFaxClientSpi.FaxClientSpiConfigurationConstants.PORT_NAME_PROPERTY_KEY));
        }
        String valueStr = this.factoryConfigurationHolder.getConfigurationValue(CommFaxClientSpi.FaxClientSpiConfigurationConstants.TIMEOUT_PROPERTY_KEY);
        this.timeout = 1500;
        if (valueStr != null && valueStr.length() > 0) {
            try {
                this.timeout = Integer.parseInt(valueStr);
            }
            catch (Exception exception) {
                this.timeout = 1500;
            }
        }
        if (this.timeout <= 0) {
            this.timeout = 1500;
        }
    }

    @Override
    protected void releaseResourceImpl(CommPortAdapter resource) {
        try {
            resource.close();
        }
        catch (IOException exception) {
            throw new FaxException("Unable to close COMM port adapter.", exception);
        }
    }

    public final String getPortName() {
        return this.portName;
    }

    public final int getTimeOut() {
        return this.timeout;
    }
}

