/*
 * Decompiled with CFR 0.152.
 */
package org.fax4j.spi.comm;

import org.fax4j.FaxException;
import org.fax4j.FaxJob;
import org.fax4j.common.Logger;
import org.fax4j.spi.FaxClientSpi;
import org.fax4j.spi.comm.CommPortAdapter;
import org.fax4j.spi.comm.FaxModemAdapter;

public abstract class AbstractFaxModemAdapter
implements FaxModemAdapter {
    private boolean initialized = false;

    public void initialize(FaxClientSpi faxClientSpi) {
        if (this.initialized) {
            throw new FaxException("Fax Modem Adapter already initialized.");
        }
        this.initialized = true;
        Logger logger = faxClientSpi.getLogger();
        logger.logDebug(new Object[]{"Initializing fax modem adapter of type: ", this.getClass().getName(), "\nProvider Information:\n", this.getProvider()}, null);
        this.initializeImpl(faxClientSpi);
    }

    public void submitFaxJob(FaxJob faxJob, CommPortAdapter adapter) {
        if (faxJob == null) {
            throw new FaxException("Fax job not provided.");
        }
        if (adapter == null) {
            throw new FaxException("COMM port adapter not provided.");
        }
        this.submitFaxJobImpl(faxJob, adapter);
    }

    protected abstract void initializeImpl(FaxClientSpi var1);

    protected abstract void submitFaxJobImpl(FaxJob var1, CommPortAdapter var2);
}

