/*
 * Decompiled with CFR 0.152.
 */
package org.fax4j.spi.comm;

import org.fax4j.FaxException;
import org.fax4j.FaxJob;
import org.fax4j.common.Logger;
import org.fax4j.spi.AbstractFax4JClientSpi;
import org.fax4j.spi.comm.CommPortAdapter;
import org.fax4j.spi.comm.CommPortConnectionFactory;
import org.fax4j.spi.comm.FaxModemAdapter;
import org.fax4j.spi.comm.RXTXCommPortConnectionFactory;
import org.fax4j.util.Connection;
import org.fax4j.util.ReflectionHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommFaxClientSpi
extends AbstractFax4JClientSpi {
    private String commConnectionFactoryClassName;
    private String faxModemClassName;
    private CommPortConnectionFactory commConnectionFactory;
    private Connection<CommPortAdapter> commConnection;
    private FaxModemAdapter faxModemAdapter;
    public static final int TIMEOUT_DEFAULT_VALUE = 1500;

    @Override
    protected void initializeImpl() {
        this.commConnectionFactoryClassName = this.getConfigurationValue(FaxClientSpiConfigurationConstants.CONNECTION_FACTORY_CLASS_NAME_PROPERTY_KEY);
        if (this.commConnectionFactoryClassName == null) {
            this.commConnectionFactoryClassName = RXTXCommPortConnectionFactory.class.getName();
        }
        this.commConnectionFactory = this.createCommPortConnectionFactory();
        if (this.commConnectionFactory == null) {
            throw new FaxException("COMM connection factory is not available.");
        }
        this.faxModemClassName = this.getConfigurationValue(FaxClientSpiConfigurationConstants.FAX_MODEM_CLASS_NAME_PROPERTY_KEY);
        if (this.faxModemClassName == null) {
            throw new FaxException("Fax modem class name not defined in fax4j.properties. Property: " + (Object)((Object)FaxClientSpiConfigurationConstants.FAX_MODEM_CLASS_NAME_PROPERTY_KEY));
        }
        this.faxModemAdapter = this.createFaxModemAdapter();
        if (this.faxModemAdapter == null) {
            throw new FaxException("Fax modem adapter is not available.");
        }
    }

    protected final CommPortConnectionFactory createCommPortConnectionFactory() {
        CommPortConnectionFactory factory = (CommPortConnectionFactory)ReflectionHelper.createInstance(this.commConnectionFactoryClassName);
        factory.initialize(this);
        return factory;
    }

    protected final FaxModemAdapter createFaxModemAdapter() {
        FaxModemAdapter adapter = (FaxModemAdapter)ReflectionHelper.createInstance(this.faxModemClassName);
        adapter.initialize(this);
        return adapter;
    }

    protected void finalize() throws Throwable {
        this.releaseCommPortConnection();
        super.finalize();
    }

    protected Connection<CommPortAdapter> createCommPortConnection() {
        Connection<CommPortAdapter> connection = this.commConnectionFactory.createConnection();
        return connection;
    }

    protected void releaseCommPortConnection() {
        Connection<CommPortAdapter> connection = this.commConnection;
        this.commConnection = null;
        if (connection != null) {
            Logger logger = this.getLogger();
            try {
                logger.logInfo(new Object[]{"Closing COMM port connection."}, null);
                connection.close();
            }
            catch (Exception exception) {
                logger.logError(new Object[]{"Error while closing COMM port connection."}, exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Connection<CommPortAdapter> getCommPortConnection() {
        Connection<CommPortAdapter> connection = null;
        CommFaxClientSpi commFaxClientSpi = this;
        synchronized (commFaxClientSpi) {
            boolean connectionValid = true;
            if (this.commConnection == null) {
                connectionValid = false;
            } else {
                CommPortAdapter adapter = this.commConnection.getResource();
                if (!adapter.isOpen()) {
                    connectionValid = false;
                }
            }
            if (!connectionValid) {
                this.releaseCommPortConnection();
                this.commConnection = this.createCommPortConnection();
            }
        }
        connection = this.commConnection;
        return connection;
    }

    @Override
    protected synchronized void submitFaxJobImpl(FaxJob faxJob) {
        Connection<CommPortAdapter> connection = this.getCommPortConnection();
        CommPortAdapter adapter = connection.getResource();
        this.submitFaxJobImpl(faxJob, adapter);
    }

    protected void submitFaxJobImpl(FaxJob faxJob, CommPortAdapter adapter) {
        this.faxModemAdapter.submitFaxJob(faxJob, adapter);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FaxClientSpiConfigurationConstants {
        PORT_NAME_PROPERTY_KEY("org.fax4j.spi.comm.port.name"),
        CONNECTION_FACTORY_CLASS_NAME_PROPERTY_KEY("org.fax4j.spi.comm.connection.factory.class.name"),
        FAX_MODEM_CLASS_NAME_PROPERTY_KEY("org.fax4j.spi.comm.fax.modem.class.name"),
        TIMEOUT_PROPERTY_KEY("org.fax4j.spi.comm.connection.timeout");

        private String value;

        private FaxClientSpiConfigurationConstants(String value) {
            this.value = value;
        }

        public final String toString() {
            return this.value;
        }
    }
}

