/*
 * Decompiled with CFR 0.152.
 */
package org.fax4j.spi.email;

import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.fax4j.spi.email.AbstractMailFaxClientSpi;
import org.fax4j.spi.email.MailConnectionFactory;
import org.fax4j.spi.email.MailResourcesHolder;
import org.fax4j.util.AbstractFax4JConnectionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMailConnectionFactory
extends AbstractFax4JConnectionFactory<MailResourcesHolder>
implements MailConnectionFactory {
    protected Properties mailConnectionProperties;
    protected String userName;
    protected String password;
    protected String transportProtocol;
    protected String transportHost;
    protected int transportPort;

    @Override
    protected void initializeImpl() {
        this.mailConnectionProperties = new Properties();
        Map<String, String> configuration = this.factoryConfigurationHolder.getConfiguration();
        Iterator<Map.Entry<String, String>> iterator = configuration.entrySet().iterator();
        Map.Entry<String, String> entry = null;
        String key = null;
        String value = null;
        while (iterator.hasNext()) {
            entry = iterator.next();
            key = entry.getKey();
            if (key == null || key.indexOf("org.fax4j.") != -1) continue;
            value = entry.getValue();
            this.mailConnectionProperties.setProperty(key, value);
        }
        this.userName = this.factoryConfigurationHolder.getConfigurationValue(AbstractMailFaxClientSpi.FaxClientSpiConfigurationConstants.USER_NAME_PROPERTY_KEY);
        this.password = this.factoryConfigurationHolder.getConfigurationValue(AbstractMailFaxClientSpi.FaxClientSpiConfigurationConstants.PASSWORD_PROPERTY_KEY);
        this.transportProtocol = this.factoryConfigurationHolder.getConfigurationValue("mail.transport.protocol");
        if (this.transportProtocol == null) {
            this.transportProtocol = "smtp";
        }
        this.transportHost = this.factoryConfigurationHolder.getConfigurationValue("mail.smtp.host");
        String transportPortStr = this.factoryConfigurationHolder.getConfigurationValue("mail.smtp.port");
        this.transportPort = -1;
        if (transportPortStr != null) {
            this.transportPort = Integer.parseInt(transportPortStr);
        }
    }
}

