/*
 * Decompiled with CFR 0.152.
 */
package org.fax4j.spi.email;

import java.io.IOException;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.Transport;
import org.fax4j.FaxException;
import org.fax4j.FaxJob;
import org.fax4j.common.Logger;
import org.fax4j.spi.AbstractFax4JClientSpi;
import org.fax4j.spi.email.MailConnectionFactory;
import org.fax4j.spi.email.MailConnectionFactoryImpl;
import org.fax4j.spi.email.MailResourcesHolder;
import org.fax4j.util.Connection;
import org.fax4j.util.ReflectionHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMailFaxClientSpi
extends AbstractFax4JClientSpi {
    private boolean usePersistentConnection;
    private MailConnectionFactory connectionFactory;
    private Connection<MailResourcesHolder> connection;

    @Override
    protected void initializeImpl() {
        Logger logger = this.getLogger();
        this.usePersistentConnection = Boolean.parseBoolean(this.getConfigurationValue(FaxClientSpiConfigurationConstants.USE_PERSISTENT_CONNECTION_PROPERTY_KEY));
        logger.logDebug(new Object[]{"Using persistent connection: ", String.valueOf(this.usePersistentConnection)}, null);
        String className = this.getConfigurationValue(FaxClientSpiConfigurationConstants.CONNECTION_FACTORY_CLASS_NAME_PROPERTY_KEY);
        this.connectionFactory = this.createMailConnectionFactoryImpl(className);
        if (this.connectionFactory == null) {
            throw new FaxException("Mail connection factory is not available.");
        }
    }

    protected final MailConnectionFactory createMailConnectionFactoryImpl(String className) {
        String factoryClassName = className;
        if (factoryClassName == null) {
            factoryClassName = MailConnectionFactoryImpl.class.getName();
        }
        MailConnectionFactory factory = (MailConnectionFactory)ReflectionHelper.createInstance(factoryClassName);
        factory.initialize(this);
        return factory;
    }

    protected void finalize() throws Throwable {
        Connection<MailResourcesHolder> mailConnection = this.connection;
        this.closeMailConnection(mailConnection);
        super.finalize();
    }

    protected Connection<MailResourcesHolder> createMailConnection() {
        Connection<MailResourcesHolder> mailConnection = this.connectionFactory.createConnection();
        Logger logger = this.getLogger();
        logger.logInfo(new Object[]{"Created mail connection."}, null);
        return mailConnection;
    }

    protected void closeMailConnection(Connection<MailResourcesHolder> mailConnection) throws IOException {
        if (mailConnection != null) {
            Logger logger = this.getLogger();
            logger.logInfo(new Object[]{"Closing mail connection."}, null);
            mailConnection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Connection<MailResourcesHolder> getMailConnection() {
        Connection<MailResourcesHolder> mailConnection = null;
        if (this.usePersistentConnection) {
            AbstractMailFaxClientSpi abstractMailFaxClientSpi = this;
            synchronized (abstractMailFaxClientSpi) {
                if (this.connection == null) {
                    this.connection = this.createMailConnection();
                }
            }
            mailConnection = this.connection;
        } else {
            mailConnection = this.createMailConnection();
        }
        return mailConnection;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void sendMail(FaxJob faxJob, Connection<MailResourcesHolder> mailConnection, Message message) {
        if (message == null) {
            this.throwUnsupportedException();
            return;
        }
        MailResourcesHolder mailResourcesHolder = mailConnection.getResource();
        Transport transport = mailResourcesHolder.getTransport();
        try {
            message.saveChanges();
            if (transport == null) {
                Transport.send((Message)message, (Address[])message.getAllRecipients());
            } else {
                transport.sendMessage(message, message.getAllRecipients());
            }
            if (this.usePersistentConnection) return;
        }
        catch (Throwable throwable) {
            try {
                throw new FaxException("Unable to send message.", throwable);
            }
            catch (Throwable throwable2) {
                if (this.usePersistentConnection) throw throwable2;
                try {
                    this.closeMailConnection(mailConnection);
                    throw throwable2;
                }
                catch (Exception exception) {
                    Logger logger = this.getLogger();
                    logger.logInfo(new Object[]{"Error while releasing mail connection."}, exception);
                }
                throw throwable2;
            }
        }
        try {
            this.closeMailConnection(mailConnection);
            return;
        }
        catch (Exception exception) {
            Logger logger = this.getLogger();
            logger.logInfo(new Object[]{"Error while releasing mail connection."}, exception);
            return;
        }
    }

    @Override
    protected void submitFaxJobImpl(FaxJob faxJob) {
        Connection<MailResourcesHolder> mailConnection = this.getMailConnection();
        MailResourcesHolder mailResourcesHolder = mailConnection.getResource();
        Message message = this.createSubmitFaxJobMessage(faxJob, mailResourcesHolder);
        this.sendMail(faxJob, mailConnection, message);
    }

    @Override
    protected void suspendFaxJobImpl(FaxJob faxJob) {
        Connection<MailResourcesHolder> mailConnection = this.getMailConnection();
        MailResourcesHolder mailResourcesHolder = mailConnection.getResource();
        Message message = this.createSuspendFaxJobMessage(faxJob, mailResourcesHolder);
        this.sendMail(faxJob, mailConnection, message);
    }

    @Override
    protected void resumeFaxJobImpl(FaxJob faxJob) {
        Connection<MailResourcesHolder> mailConnection = this.getMailConnection();
        MailResourcesHolder mailResourcesHolder = mailConnection.getResource();
        Message message = this.createResumeFaxJobMessage(faxJob, mailResourcesHolder);
        this.sendMail(faxJob, mailConnection, message);
    }

    @Override
    protected void cancelFaxJobImpl(FaxJob faxJob) {
        Connection<MailResourcesHolder> mailConnection = this.getMailConnection();
        MailResourcesHolder mailResourcesHolder = mailConnection.getResource();
        Message message = this.createCancelFaxJobMessage(faxJob, mailResourcesHolder);
        this.sendMail(faxJob, mailConnection, message);
    }

    protected abstract Message createSubmitFaxJobMessage(FaxJob var1, MailResourcesHolder var2);

    protected abstract Message createSuspendFaxJobMessage(FaxJob var1, MailResourcesHolder var2);

    protected abstract Message createResumeFaxJobMessage(FaxJob var1, MailResourcesHolder var2);

    protected abstract Message createCancelFaxJobMessage(FaxJob var1, MailResourcesHolder var2);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FaxClientSpiConfigurationConstants {
        USE_PERSISTENT_CONNECTION_PROPERTY_KEY("org.fax4j.spi.mail.persistent.connection"),
        CONNECTION_FACTORY_CLASS_NAME_PROPERTY_KEY("org.fax4j.spi.mail.connection.factory.class.name"),
        USER_NAME_PROPERTY_KEY("org.fax4j.spi.mail.user.name"),
        PASSWORD_PROPERTY_KEY("org.fax4j.spi.mail.password");

        private String value;

        private FaxClientSpiConfigurationConstants(String value) {
            this.value = value;
        }

        public final String toString() {
            return this.value;
        }
    }
}

