/*
 * Decompiled with CFR 0.152.
 */
package org.fax4j.spi.email;

import java.util.Properties;
import javax.mail.Session;
import javax.mail.Transport;
import org.fax4j.FaxException;
import org.fax4j.spi.email.AbstractMailConnectionFactory;
import org.fax4j.spi.email.MailAuthenticator;
import org.fax4j.spi.email.MailResourcesHolder;

public class MailConnectionFactoryImpl
extends AbstractMailConnectionFactory {
    protected MailResourcesHolder createResourceImpl() {
        MailAuthenticator authenticator = null;
        if (this.password != null) {
            authenticator = new MailAuthenticator(this.userName, this.password);
        }
        Session session = Session.getInstance((Properties)this.mailConnectionProperties, authenticator);
        Transport transport = this.createTransport(session);
        MailResourcesHolder resource = new MailResourcesHolder(session, transport);
        return resource;
    }

    protected Transport createTransport(Session session) {
        Transport transport = null;
        try {
            transport = session.getTransport(this.transportProtocol);
            if (this.transportPort > 0) {
                transport.connect(this.transportHost, this.transportPort, this.userName, this.password);
            } else {
                transport.connect(this.transportHost, this.userName, this.password);
            }
        }
        catch (Exception exception) {
            throw new FaxException("Error while connecting to mail host: " + this.transportHost, exception);
        }
        return transport;
    }

    protected void releaseResourceImpl(MailResourcesHolder resource) {
        Transport transport = resource.getTransport();
        if (transport != null && transport.isConnected()) {
            try {
                transport.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

