/*
 * Decompiled with CFR 0.152.
 */
package org.fax4j.spi.email;

import java.io.File;
import java.text.MessageFormat;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.fax4j.FaxException;
import org.fax4j.FaxJob;
import org.fax4j.common.Logger;
import org.fax4j.spi.email.AbstractMailFaxClientSpi;
import org.fax4j.spi.email.MailResourcesHolder;

public class MailFaxClientSpi
extends AbstractMailFaxClientSpi {
    protected String mailAddressTemplate;
    protected String mailSubjectTemplate;

    protected void initializeImpl() {
        super.initializeImpl();
        this.initializeMailTemplates();
        Logger logger = this.getLogger();
        if (this.mailAddressTemplate == null) {
            throw new FaxException("Mail address template not defined in fax4j.properties. Property: " + (Object)((Object)FaxClientSpiConfigurationConstants.MAIL_ADDRESS_TEMPLATE_PROPERTY_KEY));
        }
        logger.logDebug(new Object[]{"Using mail address template: ", this.mailAddressTemplate}, null);
        if (this.mailSubjectTemplate == null) {
            throw new FaxException("Mail subject template not defined in fax4j.properties. Property: " + (Object)((Object)FaxClientSpiConfigurationConstants.MAIL_SUBJECT_TEMPLATE_PROPERTY_KEY));
        }
        logger.logDebug(new Object[]{"Using mail subject template: ", this.mailSubjectTemplate}, null);
    }

    protected void initializeMailTemplates() {
        this.mailAddressTemplate = this.getConfigurationValue(FaxClientSpiConfigurationConstants.MAIL_ADDRESS_TEMPLATE_PROPERTY_KEY);
        this.mailSubjectTemplate = this.getConfigurationValue(FaxClientSpiConfigurationConstants.MAIL_SUBJECT_TEMPLATE_PROPERTY_KEY);
    }

    public final String getMailAddressTemplate() {
        return this.mailAddressTemplate;
    }

    public final String getMailSubjectTemplate() {
        return this.mailSubjectTemplate;
    }

    protected Message createSubmitFaxJobMessage(FaxJob faxJob, MailResourcesHolder mailResourcesHolder) {
        Logger logger = this.getLogger();
        String targetAddress = faxJob.getTargetAddress();
        String toAddress = MessageFormat.format(this.mailAddressTemplate, targetAddress);
        logger.logDebug(new Object[]{"Formatted TO address: ", toAddress}, null);
        String subject = MessageFormat.format(this.mailSubjectTemplate, targetAddress);
        logger.logDebug(new Object[]{"Formatted subject: ", subject}, null);
        Session session = mailResourcesHolder.getSession();
        MimeMessage message = new MimeMessage(session);
        String from = faxJob.getSenderEmail();
        if (from != null && from.length() > 0) {
            try {
                message.setFrom((Address)new InternetAddress(from));
            }
            catch (Exception exception) {
                throw new FaxException("Error while setting from address: " + from, exception);
            }
        }
        try {
            message.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(toAddress));
        }
        catch (Exception exception) {
            throw new FaxException("Error while setting TO address: " + toAddress, exception);
        }
        try {
            message.setSubject(subject);
        }
        catch (Exception exception) {
            throw new FaxException("Error while setting subject: " + subject, exception);
        }
        MimeMultipart multipart = new MimeMultipart();
        MimeBodyPart messageFileAttachmentBodyPart = new MimeBodyPart();
        File file = faxJob.getFile();
        FileDataSource source = new FileDataSource(file);
        try {
            messageFileAttachmentBodyPart.setDataHandler(new DataHandler((DataSource)source));
            messageFileAttachmentBodyPart.setFileName(file.getName());
            multipart.addBodyPart((BodyPart)messageFileAttachmentBodyPart);
            message.setContent((Multipart)multipart);
        }
        catch (Exception exception) {
            throw new FaxException("Error while setting attachment.", exception);
        }
        return message;
    }

    protected Message createSuspendFaxJobMessage(FaxJob faxJob, MailResourcesHolder mailResourcesHolder) {
        return null;
    }

    protected Message createResumeFaxJobMessage(FaxJob faxJob, MailResourcesHolder mailResourcesHolder) {
        return null;
    }

    protected Message createCancelFaxJobMessage(FaxJob faxJob, MailResourcesHolder mailResourcesHolder) {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FaxClientSpiConfigurationConstants {
        MAIL_ADDRESS_TEMPLATE_PROPERTY_KEY("org.fax4j.spi.mail.address.template"),
        MAIL_SUBJECT_TEMPLATE_PROPERTY_KEY("org.fax4j.spi.mail.subject.template");

        private String value;

        private FaxClientSpiConfigurationConstants(String value) {
            this.value = value;
        }

        public final String toString() {
            return this.value;
        }
    }
}

