/*
 * Decompiled with CFR 0.152.
 */
package org.fax4j.spi.hoiio;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.fax4j.FaxException;
import org.fax4j.FaxJob;
import org.fax4j.common.FaxActionType;
import org.fax4j.spi.http.AbstractMultiPart2JSONHTTPFaxClientSpi;
import org.fax4j.spi.http.CommonHTTPClientConfiguration;
import org.fax4j.spi.http.HTTPClient;
import org.fax4j.spi.http.HTTPClientConfiguration;
import org.fax4j.spi.http.JSONHTTPResponseHandler;
import org.fax4j.spi.http.MultiPartFaxJob2HTTPRequestConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HoiioFaxClientSpi
extends AbstractMultiPart2JSONHTTPFaxClientSpi {
    public static final String HOIIO_PROPERTY_PART = "hoiio";

    @Override
    public String getPropertyPart() {
        return HOIIO_PROPERTY_PART;
    }

    @Override
    protected HTTPClientConfiguration createHTTPClientConfiguration() {
        CommonHTTPClientConfiguration configuration = new CommonHTTPClientConfiguration();
        configuration.setHostName("secure.hoiio.com");
        configuration.setSSL(true);
        configuration.setMethod(FaxActionType.SUBMIT_FAX_JOB, HTTPClient.HTTPMethod.POST);
        configuration.setMethod(FaxActionType.GET_FAX_JOB_STATUS, HTTPClient.HTTPMethod.POST);
        return configuration;
    }

    @Override
    protected void updateFaxJob2HTTPRequestConverterConfiguration(Map<String, String> configuration) {
        String applicationID = this.getConfigurationValue(FaxClientSpiConfigurationConstants.APPLICATION_ID_PROPERTY_KEY);
        String accessToken = this.getConfigurationValue(FaxClientSpiConfigurationConstants.ACCESS_TOKEN_PROPERTY_KEY);
        if (applicationID == null || accessToken == null) {
            throw new FaxException("Missing hoiio Application ID/Access Token values.");
        }
        String propertyPart = this.getPropertyPart();
        configuration.put(MessageFormat.format(MultiPartFaxJob2HTTPRequestConverter.FaxJob2HTTPRequestConverterConfigurationConstants.SUBMIT_ACTION_FILE_CONTENT_PARAMETER_NAME_PROPERTY_KEY.toString(), propertyPart), "file");
        configuration.put(MessageFormat.format(MultiPartFaxJob2HTTPRequestConverter.FaxJob2HTTPRequestConverterConfigurationConstants.SUBMIT_ACTION_TARGET_ADDRESS_PARAMETER_NAME_PROPERTY_KEY.toString(), propertyPart), "dest");
        configuration.put(MessageFormat.format(MultiPartFaxJob2HTTPRequestConverter.FaxJob2HTTPRequestConverterConfigurationConstants.SUBMIT_ACTION_SENDER_FAX_NUMBER_PARAMETER_NAME_PROPERTY_KEY.toString(), propertyPart), "caller_id");
        configuration.put(MessageFormat.format(MultiPartFaxJob2HTTPRequestConverter.FaxJob2HTTPRequestConverterConfigurationConstants.GET_FAX_JOB_STATUS_ACTION_FAX_JOB_ID_PARAMETER_NAME_PROPERTY_KEY.toString(), propertyPart), "txn_ref");
        configuration.put(MessageFormat.format(MultiPartFaxJob2HTTPRequestConverter.FaxJob2HTTPRequestConverterConfigurationConstants.ADDITIONAL_PARAMETER_PROPERTY_KEY_PREFIX.toString() + "app_id", propertyPart), applicationID);
        configuration.put(MessageFormat.format(MultiPartFaxJob2HTTPRequestConverter.FaxJob2HTTPRequestConverterConfigurationConstants.ADDITIONAL_PARAMETER_PROPERTY_KEY_PREFIX.toString() + "access_token", propertyPart), accessToken);
    }

    @Override
    protected void updateHTTPResponseHandlerConfiguration(Map<String, String> configuration) {
        String propertyPart = this.getPropertyPart();
        configuration.put(MessageFormat.format(JSONHTTPResponseHandler.JSONHTTPResponseHandlerConfigurationConstants.SUBMIT_JSON_OUTPUT_PROPERTY_KEY.toString(), propertyPart), "txn_ref");
        configuration.put(MessageFormat.format(JSONHTTPResponseHandler.JSONHTTPResponseHandlerConfigurationConstants.ERROR_DETECTION_PATH_PROPERTY_KEY.toString(), propertyPart), "status");
        configuration.put(MessageFormat.format(JSONHTTPResponseHandler.JSONHTTPResponseHandlerConfigurationConstants.ERROR_DETECTION_VALUE_PROPERTY_KEY.toString(), propertyPart), "error_");
        configuration.put(MessageFormat.format(JSONHTTPResponseHandler.JSONHTTPResponseHandlerConfigurationConstants.GET_STATUS_JSON_OUTPUT_PROPERTY_KEY.toString(), propertyPart), "fax_status");
        configuration.put(MessageFormat.format(JSONHTTPResponseHandler.JSONHTTPResponseHandlerConfigurationConstants.IN_PROGRESS_STATUS_MAPPING_PROPERTY_KEY.toString(), propertyPart), "ongoing");
        configuration.put(MessageFormat.format(JSONHTTPResponseHandler.JSONHTTPResponseHandlerConfigurationConstants.ERROR_STATUS_MAPPING_PROPERTY_KEY.toString(), propertyPart), "unanswered;failed;busy");
    }

    @Override
    protected Map<FaxActionType, String> initializeFaxActionType2ResourceMap() {
        HashMap<FaxActionType, String> map = new HashMap<FaxActionType, String>();
        map.put(FaxActionType.SUBMIT_FAX_JOB, "/open/fax/send");
        map.put(FaxActionType.GET_FAX_JOB_STATUS, "/open/fax/query_status");
        return map;
    }

    @Override
    protected String initializeURLParameters() {
        return null;
    }

    @Override
    protected void suspendFaxJobImpl(FaxJob faxJob) {
        this.throwUnsupportedException();
    }

    @Override
    protected void resumeFaxJobImpl(FaxJob faxJob) {
        this.throwUnsupportedException();
    }

    @Override
    protected void cancelFaxJobImpl(FaxJob faxJob) {
        this.throwUnsupportedException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FaxClientSpiConfigurationConstants {
        APPLICATION_ID_PROPERTY_KEY("org.fax4j.spi.hoiio.app.id"),
        ACCESS_TOKEN_PROPERTY_KEY("org.fax4j.spi.hoiio.access.token");

        private String value;

        private FaxClientSpiConfigurationConstants(String value) {
            this.value = value;
        }

        public final String toString() {
            return this.value;
        }
    }
}

