/*
 * Decompiled with CFR 0.152.
 */
package org.fax4j.spi.http;

import org.fax4j.FaxException;
import org.fax4j.Provider;
import org.fax4j.common.ConfigurationHolder;
import org.fax4j.common.Fax4JProvider;
import org.fax4j.common.FaxActionType;
import org.fax4j.spi.http.CommonHTTPClientConfiguration;
import org.fax4j.spi.http.HTTPClient;
import org.fax4j.spi.http.HTTPClientConfiguration;

public abstract class AbstractHTTPClient
implements HTTPClient {
    public final Provider getProvider() {
        return Fax4JProvider.FAX4J_PROVIDER;
    }

    public HTTPClientConfiguration createHTTPClientConfiguration(ConfigurationHolder configurationHolder) {
        String hostName = configurationHolder.getConfigurationValue(CommonHTTPClientConfiguration.HTTPClientConfigurationConstants.HOST_NAME_PROPERTY_KEY);
        if (hostName == null) {
            throw new FaxException("Host name not defined in property: " + (Object)((Object)CommonHTTPClientConfiguration.HTTPClientConfigurationConstants.HOST_NAME_PROPERTY_KEY));
        }
        String value = configurationHolder.getConfigurationValue(CommonHTTPClientConfiguration.HTTPClientConfigurationConstants.PORT_PROPERTY_KEY);
        if (value == null) {
            value = String.valueOf(-1);
        }
        int port = Integer.parseInt(value);
        boolean ssl = Boolean.parseBoolean(configurationHolder.getConfigurationValue(CommonHTTPClientConfiguration.HTTPClientConfigurationConstants.SSL_PROPERTY_KEY));
        CommonHTTPClientConfiguration configuration = new CommonHTTPClientConfiguration();
        configuration.setHostName(hostName);
        configuration.setPort(port);
        configuration.setSSL(ssl);
        Enum[] methodProperties = new Enum[]{CommonHTTPClientConfiguration.HTTPClientConfigurationConstants.SUBMIT_HTTP_METHOD_PROPERTY_KEY, CommonHTTPClientConfiguration.HTTPClientConfigurationConstants.SUSPEND_HTTP_METHOD_PROPERTY_KEY, CommonHTTPClientConfiguration.HTTPClientConfigurationConstants.RESUME_HTTP_METHOD_PROPERTY_KEY, CommonHTTPClientConfiguration.HTTPClientConfigurationConstants.CANCEL_HTTP_METHOD_PROPERTY_KEY, CommonHTTPClientConfiguration.HTTPClientConfigurationConstants.GET_STATUS_HTTP_METHOD_PROPERTY_KEY};
        FaxActionType[] faxActionTypes = new FaxActionType[]{FaxActionType.SUBMIT_FAX_JOB, FaxActionType.SUSPEND_FAX_JOB, FaxActionType.RESUME_FAX_JOB, FaxActionType.CANCEL_FAX_JOB, FaxActionType.GET_FAX_JOB_STATUS};
        HTTPClient.HTTPMethod httpMethod = null;
        for (int index = 0; index < methodProperties.length; ++index) {
            value = configurationHolder.getConfigurationValue(methodProperties[index]);
            httpMethod = HTTPClient.HTTPMethod.POST;
            if (value != null) {
                httpMethod = HTTPClient.HTTPMethod.valueOf(value);
            }
            configuration.setMethod(faxActionTypes[index], httpMethod);
        }
        return configuration;
    }
}

