/*
 * Decompiled with CFR 0.152.
 */
package org.fax4j.spi.http;

import java.util.HashMap;
import java.util.Map;
import org.fax4j.FaxException;
import org.fax4j.FaxJob;
import org.fax4j.FaxJobStatus;
import org.fax4j.common.Fax4JProvider;
import org.fax4j.common.FaxActionType;
import org.fax4j.spi.http.AbstractHTTPResponseHandler;
import org.fax4j.spi.http.HTTPResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMappingHTTPResponseHandler<T>
extends AbstractHTTPResponseHandler {
    private Map<FaxActionType, String> faxActionType2ReponseDataPathMap;
    private Map<String, FaxJobStatus> statusString2FaxStatusMap;
    private String errorDetectionPath;
    private String errorDetectionValue;
    private String errorMessagePath;
    public static final String VALUES_SEPERATOR = ";";

    public AbstractMappingHTTPResponseHandler() {
        super(Fax4JProvider.FAX4J_PROVIDER);
    }

    @Override
    protected void initializeImpl() {
        super.initializeImpl();
        this.faxActionType2ReponseDataPathMap = new HashMap<FaxActionType, String>();
        this.statusString2FaxStatusMap = new HashMap<String, FaxJobStatus>();
        this.populateFaxActionType2ReponseDataPathMappings();
        this.populateStatusString2FaxStatusMappings();
        Enum<?> configurationKey = this.getErrorDetectionPathPropertyKey();
        this.errorDetectionPath = this.getConfigurationValue(configurationKey);
        configurationKey = this.getErrorDetectionValuePropertyKey();
        this.errorDetectionValue = this.getConfigurationValue(configurationKey);
        configurationKey = this.getErrorMessagePathPropertyKey();
        this.errorMessagePath = this.getConfigurationValue(configurationKey);
    }

    protected void populateFaxActionType2ReponseDataPathMappings(FaxActionType[] faxActionTypes, Enum<?>[] configurationKeys) {
        String path = null;
        for (int index = 0; index < faxActionTypes.length; ++index) {
            path = this.getConfigurationValue(configurationKeys[index]);
            if (path == null) continue;
            this.faxActionType2ReponseDataPathMap.put(faxActionTypes[index], path);
        }
    }

    protected void populateStatusString2FaxStatusMappings(FaxJobStatus[] faxJobStatuses, Enum<?>[] configurationKeys) {
        FaxJobStatus faxJobStatus = null;
        String valuesStr = null;
        String[] values = null;
        String value = null;
        for (int index = 0; index < configurationKeys.length; ++index) {
            valuesStr = this.getConfigurationValue(configurationKeys[index]);
            if (valuesStr == null) continue;
            faxJobStatus = faxJobStatuses[index];
            values = valuesStr.split(VALUES_SEPERATOR);
            for (int valueIndex = 0; valueIndex < values.length; ++valueIndex) {
                value = values[valueIndex];
                if ((value = value.trim()).length() <= 0) continue;
                this.statusString2FaxStatusMap.put(value, faxJobStatus);
            }
        }
    }

    protected String getPathToResponseData(FaxActionType faxActionType) {
        return this.faxActionType2ReponseDataPathMap.get((Object)faxActionType);
    }

    protected FaxJobStatus getFaxJobStatusFromStatusString(String faxJobStatusStr) {
        return this.statusString2FaxStatusMap.get(faxJobStatusStr);
    }

    @Override
    public void updateFaxJob(FaxJob faxJob, HTTPResponse httpResponse, FaxActionType faxActionType) {
        String path = this.getPathToResponseData(faxActionType);
        String id = this.findValue(httpResponse, path);
        if (id != null) {
            faxJob.setID(id);
        }
    }

    @Override
    public FaxJobStatus getFaxJobStatus(HTTPResponse httpResponse) {
        String path = this.getPathToResponseData(FaxActionType.GET_FAX_JOB_STATUS);
        String faxJobStatusStr = this.findValue(httpResponse, path);
        FaxJobStatus faxJobStatus = FaxJobStatus.UNKNOWN;
        if (faxJobStatusStr != null && (faxJobStatus = this.getFaxJobStatusFromStatusString(faxJobStatusStr)) == null) {
            faxJobStatus = FaxJobStatus.UNKNOWN;
        }
        return faxJobStatus;
    }

    protected String findValue(HTTPResponse httpResponse, String path) {
        T object;
        String value = null;
        if (path != null && httpResponse != null && (object = this.convertToObject(httpResponse)) != null) {
            String errorMessage = this.findError(object);
            if (errorMessage != null) {
                throw new FaxException("Error found in response: " + errorMessage);
            }
            value = this.findValue(object, path);
        }
        return value;
    }

    protected String findValue(T object, String path) {
        String value = null;
        if (path != null && object != null && (value = this.findValueImpl(object, path)) != null && (value = value.trim()).length() == 0) {
            value = null;
        }
        return value;
    }

    protected String findError(T object) {
        String value;
        String errorMessage = null;
        if (this.errorDetectionPath != null && (value = this.findValue(object, this.errorDetectionPath)) != null) {
            boolean errorFound = false;
            if (this.errorDetectionValue == null) {
                errorFound = true;
            } else if (this.errorDetectionValue.indexOf(value) != -1) {
                errorFound = true;
            }
            if (errorFound) {
                errorMessage = value;
                if (this.errorMessagePath != null && (value = this.findValue(object, this.errorMessagePath)) != null) {
                    errorMessage = value;
                }
            }
        }
        return errorMessage;
    }

    protected abstract void populateFaxActionType2ReponseDataPathMappings();

    protected abstract void populateStatusString2FaxStatusMappings();

    protected abstract Enum<?> getErrorDetectionPathPropertyKey();

    protected abstract Enum<?> getErrorDetectionValuePropertyKey();

    protected abstract Enum<?> getErrorMessagePathPropertyKey();

    protected abstract String findValueImpl(T var1, String var2);

    protected abstract T convertToObject(HTTPResponse var1);
}

