/*
 * Decompiled with CFR 0.152.
 */
package org.fax4j.spi.http;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.fax4j.FaxException;
import org.fax4j.common.Logger;
import org.fax4j.common.LoggerManager;
import org.fax4j.spi.http.AbstractHTTPClient;
import org.fax4j.spi.http.HTTPClient;
import org.fax4j.spi.http.HTTPClientConfiguration;
import org.fax4j.spi.http.HTTPRequest;
import org.fax4j.spi.http.HTTPResponse;

public class ApacheHTTPClient
extends AbstractHTTPClient {
    protected HttpClient createHttpClient() {
        HttpClient httpClient = new HttpClient();
        return httpClient;
    }

    protected HttpMethodBase createMethod(String url, HTTPClient.HTTPMethod httpMethod) {
        if (httpMethod == null) {
            throw new FaxException("HTTP method not provided.");
        }
        if (url == null || url.length() == 0) {
            throw new FaxException("HTTP URL not provided.");
        }
        PostMethod httpMethodClient = null;
        switch (httpMethod) {
            case POST: {
                httpMethodClient = new PostMethod(url);
                break;
            }
            case GET: {
                httpMethodClient = new GetMethod(url);
                break;
            }
            case PUT: {
                httpMethodClient = new PutMethod(url);
            }
        }
        return httpMethodClient;
    }

    protected HTTPResponse createHTTPResponse(int statusCode, String responseContent) {
        HTTPResponse httpResponse = new HTTPResponse();
        httpResponse.setStatusCode(statusCode);
        httpResponse.setContent(responseContent);
        return httpResponse;
    }

    protected void appendBaseURL(StringBuilder buffer, String resource, HTTPClientConfiguration configuration) {
        buffer.append("http");
        if (configuration.isSSL()) {
            buffer.append("s");
        }
        buffer.append("://");
        buffer.append(configuration.getHostName());
        int port = configuration.getPort();
        if (port > 0) {
            buffer.append(":");
            buffer.append(port);
        }
        if (resource != null && resource.length() > 0) {
            if (!resource.startsWith("/")) {
                buffer.append("/");
            }
            buffer.append(resource);
        }
    }

    protected void appendParameters(StringBuilder buffer, String parameters) {
        if (parameters != null && parameters.length() > 0) {
            String updatedParameters = parameters;
            if (parameters.startsWith("?")) {
                updatedParameters = parameters.substring(1);
            }
            if (updatedParameters.length() > 0) {
                int currentLength = buffer.length();
                if (currentLength > 0 && buffer.charAt(currentLength - 1) == '/') {
                    int length = currentLength;
                    buffer.delete(length - 1, length);
                }
                buffer.append("?");
                try {
                    String[] parameterPairs = updatedParameters.split("&");
                    int amount = parameterPairs.length;
                    String parameterPair = null;
                    String[] values = null;
                    boolean addedParameters = false;
                    for (int index = 0; index < amount; ++index) {
                        parameterPair = parameterPairs[index];
                        values = parameterPair.split("=");
                        if (values.length != 2) continue;
                        if (addedParameters) {
                            buffer.append("&");
                        }
                        buffer.append(URLEncoder.encode(values[0], "UTF-8"));
                        buffer.append("=");
                        buffer.append(URLEncoder.encode(values[1], "UTF-8"));
                        addedParameters = true;
                    }
                }
                catch (Exception exception) {
                    throw new FaxException("Unable to encode parameters.", exception);
                }
            }
        }
    }

    protected String createURL(HTTPRequest httpRequest, HTTPClientConfiguration configuration) {
        StringBuilder buffer = new StringBuilder(100);
        String resource = httpRequest.getResource();
        this.appendBaseURL(buffer, resource, configuration);
        String parameters = httpRequest.getParametersText();
        this.appendParameters(buffer, parameters);
        String url = buffer.toString();
        return url;
    }

    protected void setupHTTPRequestHeaderProperties(HTTPRequest httpRequest, HttpMethodBase httpMethodClient) {
        Properties headerProperties = httpRequest.getHeaderProperties();
        if (headerProperties != null) {
            Iterator<Map.Entry<Object, Object>> iterator = headerProperties.entrySet().iterator();
            Map.Entry<Object, Object> entry = null;
            while (iterator.hasNext()) {
                entry = iterator.next();
                httpMethodClient.addRequestHeader((String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    protected RequestEntity createStringRequestContent(HTTPRequest httpRequest) {
        StringRequestEntity requestEntity = null;
        String contentString = httpRequest.getContentAsString();
        if (contentString != null) {
            try {
                requestEntity = new StringRequestEntity(contentString, "text/plain", null);
            }
            catch (UnsupportedEncodingException exception) {
                throw new FaxException("Unable to set string request entity.", exception);
            }
        }
        return requestEntity;
    }

    protected RequestEntity createBinaryRequestContent(HTTPRequest httpRequest) {
        ByteArrayRequestEntity requestEntity = null;
        byte[] contentBinary = httpRequest.getContentAsBinary();
        if (contentBinary != null) {
            requestEntity = new ByteArrayRequestEntity(contentBinary, "binary/octet-stream");
        }
        return requestEntity;
    }

    protected RequestEntity createMultiPartRequestContent(HTTPRequest httpRequest, HttpMethodBase httpMethodClient) {
        int partsAmount;
        MultipartRequestEntity requestEntity = null;
        HTTPRequest.ContentPart<?>[] contentParts = httpRequest.getContentAsParts();
        if (contentParts != null && (partsAmount = contentParts.length) > 0) {
            Part[] parts = new Part[partsAmount];
            HTTPRequest.ContentPart<?> contentPart = null;
            String name = null;
            Object content = null;
            HTTPRequest.ContentPartType contentPartType = null;
            block6: for (int index = 0; index < partsAmount; ++index) {
                contentPart = contentParts[index];
                if (contentPart == null) continue;
                name = contentPart.getName();
                content = contentPart.getContent();
                contentPartType = contentPart.getType();
                switch (contentPartType) {
                    case FILE: {
                        File file = content;
                        try {
                            parts[index] = new FilePart(name, file);
                            continue block6;
                        }
                        catch (FileNotFoundException exception) {
                            throw new FaxException("Fax file: " + file.getAbsolutePath() + " not found.", exception);
                        }
                    }
                    case STRING: {
                        parts[index] = new StringPart(name, (String)content);
                        continue block6;
                    }
                    default: {
                        throw new FaxException("Unsupported content type provided: " + (Object)((Object)contentPartType));
                    }
                }
            }
            requestEntity = new MultipartRequestEntity(parts, httpMethodClient.getParams());
        }
        return requestEntity;
    }

    protected void setRequestContent(HTTPRequest httpRequest, HttpMethodBase httpMethodClient) {
        if (httpMethodClient instanceof EntityEnclosingMethod) {
            EntityEnclosingMethod pushMethod = (EntityEnclosingMethod)httpMethodClient;
            RequestEntity requestEntity = null;
            HTTPRequest.ContentType contentType = httpRequest.getContentType();
            switch (contentType) {
                case STRING: {
                    requestEntity = this.createStringRequestContent(httpRequest);
                    break;
                }
                case BINARY: {
                    requestEntity = this.createBinaryRequestContent(httpRequest);
                    break;
                }
                case MULTI_PART: {
                    requestEntity = this.createMultiPartRequestContent(httpRequest, httpMethodClient);
                    break;
                }
                default: {
                    throw new FaxException("Unsupported content type: " + (Object)((Object)contentType));
                }
            }
            if (requestEntity != null) {
                pushMethod.setRequestEntity(requestEntity);
                pushMethod.setContentChunked(false);
            }
        }
    }

    public HTTPResponse submitHTTPRequest(HTTPRequest httpRequest, HTTPClientConfiguration httpClientConfiguration, HTTPClient.HTTPMethod httpMethod) {
        HttpClient httpClient = this.createHttpClient();
        String url = this.createURL(httpRequest, httpClientConfiguration);
        HttpMethodBase httpMethodClient = this.createMethod(url, httpMethod);
        this.setupHTTPRequestHeaderProperties(httpRequest, httpMethodClient);
        this.setRequestContent(httpRequest, httpMethodClient);
        LoggerManager loggerManager = LoggerManager.getInstance();
        Logger logger = loggerManager.getLogger();
        try {
            logger.logDebug(new Object[]{"Submitting HTTP request: ", httpMethodClient.getURI()}, null);
        }
        catch (URIException exception) {
            logger.logDebug(new Object[]{"Submitting HTTP request"}, null);
        }
        String responseContent = null;
        int statusCode = -1;
        try {
            statusCode = httpClient.executeMethod((HttpMethod)httpMethodClient);
            if (statusCode >= 400) {
                throw new FaxException("Error while invoking HTTP request, return status code: " + statusCode);
            }
            responseContent = httpMethodClient.getResponseBodyAsString();
        }
        catch (FaxException exception) {
            throw exception;
        }
        catch (Exception exception) {
            throw new FaxException("Error while executing HTTP request.", exception);
        }
        finally {
            httpMethodClient.releaseConnection();
        }
        HTTPResponse httpResponse = this.createHTTPResponse(statusCode, responseContent);
        return httpResponse;
    }
}

