/*
 * Decompiled with CFR 0.152.
 */
package org.fax4j.spi.http;

import java.util.HashMap;
import java.util.Map;
import org.fax4j.common.FaxActionType;
import org.fax4j.spi.http.HTTPClient;
import org.fax4j.spi.http.HTTPClientConfiguration;

public class CommonHTTPClientConfiguration
implements HTTPClientConfiguration {
    private String hostName;
    private int port;
    private boolean ssl;
    private Map<FaxActionType, HTTPClient.HTTPMethod> methodMap = new HashMap<FaxActionType, HTTPClient.HTTPMethod>();

    public CommonHTTPClientConfiguration() {
        this.setPort(80);
        this.setSSL(false);
        FaxActionType[] faxActionTypes = FaxActionType.values();
        FaxActionType faxActionType2 = null;
        for (FaxActionType faxActionType2 : faxActionTypes) {
            this.setMethod(faxActionType2, HTTPClient.HTTPMethod.POST);
        }
    }

    public final String getHostName() {
        return this.hostName;
    }

    public final void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public final int getPort() {
        return this.port;
    }

    public final void setPort(int port) {
        this.port = port;
    }

    public final boolean isSSL() {
        return this.ssl;
    }

    public final void setSSL(boolean ssl) {
        this.ssl = ssl;
    }

    public final HTTPClient.HTTPMethod getMethod(FaxActionType faxActionType) {
        return this.methodMap.get((Object)faxActionType);
    }

    public final void setMethod(FaxActionType faxActionType, HTTPClient.HTTPMethod httpMethod) {
        this.methodMap.put(faxActionType, httpMethod);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum HTTPClientConfigurationConstants {
        HOST_NAME_PROPERTY_KEY("org.fax4j.spi.{0}.host.name"),
        PORT_PROPERTY_KEY("org.fax4j.spi.{0}.port"),
        SSL_PROPERTY_KEY("org.fax4j.spi.{0}.ssl"),
        SUBMIT_HTTP_METHOD_PROPERTY_KEY("org.fax4j.spi.{0}.submit.method"),
        SUSPEND_HTTP_METHOD_PROPERTY_KEY("org.fax4j.spi.{0}.suspend.method"),
        RESUME_HTTP_METHOD_PROPERTY_KEY("org.fax4j.spi.{0}.resume.method"),
        CANCEL_HTTP_METHOD_PROPERTY_KEY("org.fax4j.spi.{0}.cancel.method"),
        GET_STATUS_HTTP_METHOD_PROPERTY_KEY("org.fax4j.spi.{0}.get.status.method");

        private String value;

        private HTTPClientConfigurationConstants(String value) {
            this.value = value;
        }

        public final String toString() {
            return this.value;
        }
    }
}

