/*
 * Decompiled with CFR 0.152.
 */
package org.fax4j.spi.http;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.fax4j.FaxException;
import org.fax4j.FaxJob;
import org.fax4j.FaxJobStatus;
import org.fax4j.common.ConfigurationHolder;
import org.fax4j.common.FaxActionType;
import org.fax4j.common.ServiceFactory;
import org.fax4j.spi.AbstractFax4JClientSpi;
import org.fax4j.spi.http.ApacheHTTPClient;
import org.fax4j.spi.http.FaxJob2HTTPRequestConverter;
import org.fax4j.spi.http.HTTPClient;
import org.fax4j.spi.http.HTTPClientConfiguration;
import org.fax4j.spi.http.HTTPRequest;
import org.fax4j.spi.http.HTTPResponse;
import org.fax4j.spi.http.HTTPResponseHandler;
import org.fax4j.spi.http.JSONHTTPResponseHandler;
import org.fax4j.spi.http.MultiPartFaxJob2HTTPRequestConverter;
import org.fax4j.util.ReflectionHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTTPFaxClientSpi
extends AbstractFax4JClientSpi {
    private HTTPClient httpClient;
    private HTTPClientConfiguration httpClientConfiguration;
    private FaxJob2HTTPRequestConverter faxJob2HTTPRequestConverter;
    private HTTPResponseHandler httpResponseHandler;
    private Map<FaxActionType, String> faxActionType2ResourceMap;
    private String urlParameters;
    public static final String HTTP_PROPERTY_PART = "http";

    @Override
    protected void initializeImpl() {
        String value = this.getConfigurationValue(FaxClientSpiConfigurationConstants.HTTP_CLIENT_CLASS_NAME_PROPERTY_KEY);
        if (value == null) {
            value = ApacheHTTPClient.class.getName();
        }
        this.httpClient = (HTTPClient)ReflectionHelper.createInstance(value);
        this.httpClientConfiguration = this.createHTTPClientConfiguration();
        this.faxJob2HTTPRequestConverter = this.createFaxJob2HTTPRequestConverter();
        this.httpResponseHandler = this.createHTTPResponseHandler();
        Map<FaxActionType, String> map = this.initializeFaxActionType2ResourceMap();
        this.faxActionType2ResourceMap = new HashMap<FaxActionType, String>(map);
        this.urlParameters = this.initializeURLParameters();
    }

    @Override
    public String getPropertyPart() {
        return HTTP_PROPERTY_PART;
    }

    protected HTTPClientConfiguration createHTTPClientConfiguration() {
        HTTPClientConfiguration configuration = this.httpClient.createHTTPClientConfiguration(this);
        return configuration;
    }

    protected FaxJob2HTTPRequestConverter createFaxJob2HTTPRequestConverter() {
        String propertyPart = this.getPropertyPart();
        FaxJob2HTTPRequestConverter converter = (FaxJob2HTTPRequestConverter)ServiceFactory.createService(FaxClientSpiConfigurationConstants.FAX_JOB2HTTP_REQUEST_CONVERTER_CLASS_NAME_PROPERTY_KEY, MultiPartFaxJob2HTTPRequestConverter.class.getName(), (ConfigurationHolder)this, propertyPart);
        return converter;
    }

    protected HTTPResponseHandler createHTTPResponseHandler() {
        String propertyPart = this.getPropertyPart();
        HTTPResponseHandler handler = (HTTPResponseHandler)ServiceFactory.createService(FaxClientSpiConfigurationConstants.HTTP_RESPONSE_HANDLER_CLASS_NAME_PROPERTY_KEY, JSONHTTPResponseHandler.class.getName(), (ConfigurationHolder)this, propertyPart);
        return handler;
    }

    protected Map<FaxActionType, String> initializeFaxActionType2ResourceMap() {
        HashMap<FaxActionType, String> map = new HashMap<FaxActionType, String>();
        FaxActionType[] faxActionTypes = new FaxActionType[]{FaxActionType.SUBMIT_FAX_JOB, FaxActionType.SUSPEND_FAX_JOB, FaxActionType.RESUME_FAX_JOB, FaxActionType.CANCEL_FAX_JOB, FaxActionType.GET_FAX_JOB_STATUS};
        Enum[] keys = new Enum[]{FaxClientSpiConfigurationConstants.SUBMIT_HTTP_RESOURCE_PROPERTY_KEY, FaxClientSpiConfigurationConstants.SUSPEND_HTTP_RESOURCE_PROPERTY_KEY, FaxClientSpiConfigurationConstants.RESUME_HTTP_RESOURCE_PROPERTY_KEY, FaxClientSpiConfigurationConstants.CANCEL_HTTP_RESOURCE_PROPERTY_KEY, FaxClientSpiConfigurationConstants.GET_STATUS_HTTP_RESOURCE_PROPERTY_KEY};
        String resource = null;
        for (int index = 0; index < faxActionTypes.length; ++index) {
            resource = this.getConfigurationValue(keys[index]);
            if (resource == null) continue;
            map.put(faxActionTypes[index], resource);
        }
        return map;
    }

    protected String initializeURLParameters() {
        return this.getConfigurationValue(FaxClientSpiConfigurationConstants.HTTP_URL_PARAMETERS_PROPERTY_KEY);
    }

    protected final HTTPClient getHTTPClient() {
        return this.httpClient;
    }

    protected final HTTPClientConfiguration getHTTPClientConfiguration() {
        return this.httpClientConfiguration;
    }

    protected final FaxJob2HTTPRequestConverter getFaxJob2HTTPRequestConverter() {
        return this.faxJob2HTTPRequestConverter;
    }

    protected final HTTPResponseHandler getHTTPResponseHandler() {
        return this.httpResponseHandler;
    }

    protected final String getHTTPResource(FaxActionType faxActionType) {
        return this.faxActionType2ResourceMap.get((Object)faxActionType);
    }

    protected final String getHTTPURLParameters() {
        return this.urlParameters;
    }

    @Override
    protected void submitFaxJobImpl(FaxJob faxJob) {
        HTTPRequest httpRequest = this.createSubmitFaxJobHTTPRequest(faxJob);
        this.submitHTTPRequest(faxJob, httpRequest, FaxActionType.SUBMIT_FAX_JOB);
    }

    @Override
    protected void suspendFaxJobImpl(FaxJob faxJob) {
        HTTPRequest httpRequest = this.createSuspendFaxJobHTTPRequest(faxJob);
        this.submitHTTPRequest(faxJob, httpRequest, FaxActionType.SUSPEND_FAX_JOB);
    }

    @Override
    protected void resumeFaxJobImpl(FaxJob faxJob) {
        HTTPRequest httpRequest = this.createResumeFaxJobHTTPRequest(faxJob);
        this.submitHTTPRequest(faxJob, httpRequest, FaxActionType.RESUME_FAX_JOB);
    }

    @Override
    protected void cancelFaxJobImpl(FaxJob faxJob) {
        HTTPRequest httpRequest = this.createCancelFaxJobHTTPRequest(faxJob);
        this.submitHTTPRequest(faxJob, httpRequest, FaxActionType.CANCEL_FAX_JOB);
    }

    @Override
    protected FaxJobStatus getFaxJobStatusImpl(FaxJob faxJob) {
        HTTPResponse httpResponse;
        FaxJobStatus faxJobStatus = FaxJobStatus.UNKNOWN;
        HTTPRequest httpRequest = this.createGetFaxJobStatusHTTPRequest(faxJob);
        if (httpRequest != null && (httpResponse = this.submitHTTPRequest(faxJob, httpRequest, FaxActionType.GET_FAX_JOB_STATUS)) != null && (faxJobStatus = this.httpResponseHandler.getFaxJobStatus(httpResponse)) == null) {
            faxJobStatus = FaxJobStatus.UNKNOWN;
        }
        return faxJobStatus;
    }

    protected HTTPResponse submitHTTPRequest(FaxJob faxJob, HTTPRequest httpRequest, FaxActionType faxActionType) {
        HTTPResponse httpResponse = null;
        if (httpRequest == null) {
            this.throwUnsupportedException();
        } else {
            HTTPClient.HTTPMethod httpMethod;
            int statusCode;
            Properties headerProperties = httpRequest.getHeaderProperties();
            if (headerProperties == null) {
                headerProperties = new Properties();
                httpRequest.setHeaderProperties(headerProperties);
            }
            if (httpRequest.getResource() == null) {
                String resource = this.getHTTPResource(faxActionType);
                httpRequest.setResource(resource);
            }
            if (httpRequest.getParametersText() == null) {
                httpRequest.setParametersText(this.urlParameters);
            }
            if ((statusCode = (httpResponse = this.submitHTTPRequestImpl(httpRequest, httpMethod = this.httpClientConfiguration.getMethod(faxActionType))).getStatusCode()) >= 400) {
                throw new FaxException("Error while invoking HTTP request, return status code: " + statusCode);
            }
            this.updateFaxJob(faxJob, httpResponse, faxActionType);
        }
        return httpResponse;
    }

    protected HTTPResponse submitHTTPRequestImpl(HTTPRequest httpRequest, HTTPClient.HTTPMethod httpMethod) {
        return this.httpClient.submitHTTPRequest(httpRequest, this.httpClientConfiguration, httpMethod);
    }

    protected void updateFaxJob(FaxJob faxJob, HTTPResponse httpResponse, FaxActionType faxActionType) {
        this.httpResponseHandler.updateFaxJob(faxJob, httpResponse, faxActionType);
    }

    protected HTTPRequest createSubmitFaxJobHTTPRequest(FaxJob faxJob) {
        return this.faxJob2HTTPRequestConverter.createHTTPRequest(this, FaxActionType.SUBMIT_FAX_JOB, faxJob);
    }

    protected HTTPRequest createSuspendFaxJobHTTPRequest(FaxJob faxJob) {
        return this.faxJob2HTTPRequestConverter.createHTTPRequest(this, FaxActionType.SUSPEND_FAX_JOB, faxJob);
    }

    protected HTTPRequest createResumeFaxJobHTTPRequest(FaxJob faxJob) {
        return this.faxJob2HTTPRequestConverter.createHTTPRequest(this, FaxActionType.RESUME_FAX_JOB, faxJob);
    }

    protected HTTPRequest createCancelFaxJobHTTPRequest(FaxJob faxJob) {
        return this.faxJob2HTTPRequestConverter.createHTTPRequest(this, FaxActionType.CANCEL_FAX_JOB, faxJob);
    }

    protected HTTPRequest createGetFaxJobStatusHTTPRequest(FaxJob faxJob) {
        return this.faxJob2HTTPRequestConverter.createHTTPRequest(this, FaxActionType.GET_FAX_JOB_STATUS, faxJob);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FaxClientSpiConfigurationConstants {
        HTTP_CLIENT_CLASS_NAME_PROPERTY_KEY("org.fax4j.spi.{0}.client.class.name"),
        FAX_JOB2HTTP_REQUEST_CONVERTER_CLASS_NAME_PROPERTY_KEY("org.fax4j.spi.{0}.faxjob2request.converter.class.name"),
        HTTP_RESPONSE_HANDLER_CLASS_NAME_PROPERTY_KEY("org.fax4j.spi.{0}.response.handler.class.name"),
        SUBMIT_HTTP_RESOURCE_PROPERTY_KEY("org.fax4j.spi.{0}.submit.resource"),
        SUSPEND_HTTP_RESOURCE_PROPERTY_KEY("org.fax4j.spi.{0}.suspend.resource"),
        RESUME_HTTP_RESOURCE_PROPERTY_KEY("org.fax4j.spi.{0}.resume.resource"),
        CANCEL_HTTP_RESOURCE_PROPERTY_KEY("org.fax4j.spi.{0}.cancel.resource"),
        GET_STATUS_HTTP_RESOURCE_PROPERTY_KEY("org.fax4j.spi.{0}.get.status.resource"),
        HTTP_URL_PARAMETERS_PROPERTY_KEY("org.fax4j.spi.{0}.url.parameters");

        private String value;

        private FaxClientSpiConfigurationConstants(String value) {
            this.value = value;
        }

        public final String toString() {
            return this.value;
        }
    }
}

