/*
 * Decompiled with CFR 0.152.
 */
package org.fax4j.spi.http;

import java.io.File;
import java.util.Map;
import java.util.Properties;
import org.fax4j.FaxException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTTPRequest {
    private String resource;
    private String parametersText;
    private Properties headerProperties;
    private ContentType contentType;
    private String contentString;
    private byte[] contentBinary;
    private ContentPart<?>[] contentParts;

    public HTTPRequest() {
        this.setContent((String)null);
    }

    public final String getResource() {
        return this.resource;
    }

    public final String getParametersText() {
        return this.parametersText;
    }

    public final Properties getHeaderProperties() {
        return this.headerProperties;
    }

    public final void setResource(String resource) {
        this.resource = resource;
    }

    public final void setParametersText(String parametersText) {
        this.parametersText = parametersText;
    }

    public final void setHeaderProperties(Properties headerProperties) {
        this.headerProperties = null;
        if (headerProperties != null) {
            this.headerProperties = new Properties();
            this.headerProperties.putAll((Map<?, ?>)headerProperties);
        }
    }

    public final ContentType getContentType() {
        return this.contentType;
    }

    public final byte[] getContentAsBinary() {
        if (!this.contentType.equals((Object)ContentType.BINARY)) {
            throw new FaxException("Current content type is: " + (Object)((Object)this.contentType));
        }
        byte[] clone = null;
        if (this.contentBinary != null) {
            clone = (byte[])this.contentBinary.clone();
        }
        return clone;
    }

    public final void setContent(byte[] content) {
        this.contentString = null;
        this.contentParts = null;
        this.contentType = ContentType.BINARY;
        this.contentBinary = (byte[])(content == null ? null : (byte[])content.clone());
    }

    public final String getContentAsString() {
        if (!this.contentType.equals((Object)ContentType.STRING)) {
            throw new FaxException("Current content type is: " + (Object)((Object)this.contentType));
        }
        return this.contentString;
    }

    public final void setContent(String content) {
        this.contentBinary = null;
        this.contentParts = null;
        this.contentType = ContentType.STRING;
        this.contentString = content;
    }

    public final ContentPart<?>[] getContentAsParts() {
        if (!this.contentType.equals((Object)ContentType.MULTI_PART)) {
            throw new FaxException("Current content type is: " + (Object)((Object)this.contentType));
        }
        ContentPart[] clone = null;
        if (this.contentParts != null) {
            clone = (ContentPart[])this.contentParts.clone();
        }
        return clone;
    }

    public final void setContent(ContentPart<?>[] content) {
        this.contentString = null;
        this.contentBinary = null;
        this.contentType = ContentType.MULTI_PART;
        this.contentParts = content == null ? null : (ContentPart[])content.clone();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ContentPart<T> {
        private final String NAME;
        private final T CONTENT;
        private final ContentPartType TYPE;

        public ContentPart(String name, T content, ContentPartType type) {
            if (name == null) {
                throw new FaxException("Part name not provided.");
            }
            if (content == null) {
                throw new FaxException("Part content not provided.");
            }
            if (type == null) {
                throw new FaxException("Part type not provided.");
            }
            switch (type) {
                case FILE: {
                    if (content instanceof File) break;
                    throw new FaxException("File type content must be a File object.");
                }
                case STRING: {
                    if (content instanceof String) break;
                    throw new FaxException("String type content must be a String object.");
                }
                case BINARY: {
                    if (content instanceof byte[]) break;
                    throw new FaxException("Binary type content must be a byte[] array.");
                }
                default: {
                    throw new FaxException("Unsupported content type provided: " + (Object)((Object)type));
                }
            }
            this.NAME = name;
            this.CONTENT = content;
            this.TYPE = type;
        }

        public final String getName() {
            return this.NAME;
        }

        public final T getContent() {
            return this.CONTENT;
        }

        public final ContentPartType getType() {
            return this.TYPE;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ContentPartType {
        FILE,
        STRING,
        BINARY;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ContentType {
        STRING,
        BINARY,
        MULTI_PART;

    }
}

