/*
 * Decompiled with CFR 0.152.
 */
package org.fax4j.spi.http;

import org.fax4j.FaxException;
import org.fax4j.FaxJobStatus;
import org.fax4j.common.FaxActionType;
import org.fax4j.spi.http.AbstractMappingHTTPResponseHandler;
import org.fax4j.spi.http.HTTPResponse;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONHTTPResponseHandler
extends AbstractMappingHTTPResponseHandler<JSONObject> {
    @Override
    protected void populateFaxActionType2ReponseDataPathMappings() {
        FaxActionType[] faxActionTypes = new FaxActionType[]{FaxActionType.SUBMIT_FAX_JOB, FaxActionType.SUSPEND_FAX_JOB, FaxActionType.RESUME_FAX_JOB, FaxActionType.CANCEL_FAX_JOB, FaxActionType.GET_FAX_JOB_STATUS};
        Enum[] configurationKeys = new Enum[]{JSONHTTPResponseHandlerConfigurationConstants.SUBMIT_JSON_OUTPUT_PROPERTY_KEY, JSONHTTPResponseHandlerConfigurationConstants.SUSPEND_JSON_OUTPUT_PROPERTY_KEY, JSONHTTPResponseHandlerConfigurationConstants.RESUME_JSON_OUTPUT_PROPERTY_KEY, JSONHTTPResponseHandlerConfigurationConstants.CANCEL_JSON_OUTPUT_PROPERTY_KEY, JSONHTTPResponseHandlerConfigurationConstants.GET_STATUS_JSON_OUTPUT_PROPERTY_KEY};
        this.populateFaxActionType2ReponseDataPathMappings(faxActionTypes, configurationKeys);
    }

    @Override
    protected void populateStatusString2FaxStatusMappings() {
        FaxJobStatus[] faxJobStatuses = new FaxJobStatus[]{FaxJobStatus.PENDING, FaxJobStatus.IN_PROGRESS, FaxJobStatus.ERROR};
        Enum[] configurationKeys = new Enum[]{JSONHTTPResponseHandlerConfigurationConstants.PENDING_STATUS_MAPPING_PROPERTY_KEY, JSONHTTPResponseHandlerConfigurationConstants.IN_PROGRESS_STATUS_MAPPING_PROPERTY_KEY, JSONHTTPResponseHandlerConfigurationConstants.ERROR_STATUS_MAPPING_PROPERTY_KEY};
        this.populateStatusString2FaxStatusMappings(faxJobStatuses, configurationKeys);
    }

    @Override
    protected Enum<?> getErrorDetectionPathPropertyKey() {
        return JSONHTTPResponseHandlerConfigurationConstants.ERROR_DETECTION_PATH_PROPERTY_KEY;
    }

    @Override
    protected Enum<?> getErrorDetectionValuePropertyKey() {
        return JSONHTTPResponseHandlerConfigurationConstants.ERROR_DETECTION_VALUE_PROPERTY_KEY;
    }

    @Override
    protected Enum<?> getErrorMessagePathPropertyKey() {
        return JSONHTTPResponseHandlerConfigurationConstants.ERROR_MESSAGE_PATH_PROPERTY_KEY;
    }

    @Override
    protected String findValueImpl(JSONObject object, String path) {
        String[] pathParts = path.split(";");
        int pathPartsAmount = pathParts.length;
        String pathPart = null;
        JSONObject currentJSONObject = object;
        String value = null;
        for (int index = 0; index < pathPartsAmount; ++index) {
            pathPart = pathParts[index];
            if (pathPart.length() <= 0) continue;
            if (currentJSONObject.isNull(pathPart)) break;
            try {
                if (index + 1 == pathPartsAmount) {
                    value = currentJSONObject.getString(pathPart);
                    continue;
                }
                if ((currentJSONObject = currentJSONObject.getJSONObject(pathPart)) != null) continue;
                break;
            }
            catch (JSONException exception) {
                throw new FaxException("Unable to extract JSON data for path: " + path, exception);
            }
        }
        return value;
    }

    @Override
    protected JSONObject convertToObject(HTTPResponse httpResponse) {
        JSONObject jsonObject = null;
        String content = httpResponse.getContent();
        if (content != null) {
            try {
                jsonObject = new JSONObject(content);
            }
            catch (JSONException exception) {
                throw new FaxException("Unable to parse HTTP response text as JSON.", exception);
            }
        }
        return jsonObject;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum JSONHTTPResponseHandlerConfigurationConstants {
        SUBMIT_JSON_OUTPUT_PROPERTY_KEY("org.fax4j.spi.{0}.submit.json.output.path"),
        SUSPEND_JSON_OUTPUT_PROPERTY_KEY("org.fax4j.spi.{0}.suspend.json.output.path"),
        RESUME_JSON_OUTPUT_PROPERTY_KEY("org.fax4j.spi.{0}.resume.json.output.path"),
        CANCEL_JSON_OUTPUT_PROPERTY_KEY("org.fax4j.spi.{0}.cancel.json.output.path"),
        GET_STATUS_JSON_OUTPUT_PROPERTY_KEY("org.fax4j.spi.{0}.get.status.json.output.path"),
        PENDING_STATUS_MAPPING_PROPERTY_KEY("org.fax4j.spi.{0}.json.pending.status.mappings"),
        IN_PROGRESS_STATUS_MAPPING_PROPERTY_KEY("org.fax4j.spi.{0}.json.inprogress.status.mappings"),
        ERROR_STATUS_MAPPING_PROPERTY_KEY("org.fax4j.spi.{0}.json.error.status.mappings"),
        ERROR_DETECTION_PATH_PROPERTY_KEY("org.fax4j.spi.{0}.json.error.detection.path"),
        ERROR_DETECTION_VALUE_PROPERTY_KEY("org.fax4j.spi.{0}.json.error.detection.value"),
        ERROR_MESSAGE_PATH_PROPERTY_KEY("org.fax4j.spi.{0}.json.error.message.path");

        private String value;

        private JSONHTTPResponseHandlerConfigurationConstants(String value) {
            this.value = value;
        }

        public final String toString() {
            return this.value;
        }
    }
}

