/*
 * Decompiled with CFR 0.152.
 */
package org.fax4j.spi.http;

import java.io.File;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.fax4j.FaxException;
import org.fax4j.FaxJob;
import org.fax4j.common.Fax4JProvider;
import org.fax4j.common.FaxActionType;
import org.fax4j.spi.http.AbstractFaxJob2HTTPRequestConverter;
import org.fax4j.spi.http.HTTPFaxClientSpi;
import org.fax4j.spi.http.HTTPRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiPartFaxJob2HTTPRequestConverter
extends AbstractFaxJob2HTTPRequestConverter {
    protected String submitFileContentParameter;
    protected String submitFileNameParameter;
    protected String submitTargetAddressParameter;
    protected String submitTargetNameParameter;
    protected String submitSenderNameParameter;
    protected String submitSenderFaxNumberParameter;
    protected String submitSenderEMailParameter;
    protected String suspendFaxJobIDParameter;
    protected String resumeFaxJobIDParameter;
    protected String cancelFaxJobIDParameter;
    protected String getStatusFaxJobIDParameter;
    protected Map<String, String> additionalParameters;
    protected boolean addFileNamePart;

    public MultiPartFaxJob2HTTPRequestConverter() {
        super(Fax4JProvider.FAX4J_PROVIDER);
    }

    @Override
    protected void initializeImpl() {
        this.submitFileContentParameter = this.getConfigurationValue(FaxJob2HTTPRequestConverterConfigurationConstants.SUBMIT_ACTION_FILE_CONTENT_PARAMETER_NAME_PROPERTY_KEY);
        if (this.submitFileContentParameter == null) {
            this.submitFileContentParameter = "file";
        }
        this.submitFileNameParameter = this.getConfigurationValue(FaxJob2HTTPRequestConverterConfigurationConstants.SUBMIT_ACTION_FILE_NAME_PARAMETER_NAME_PROPERTY_KEY);
        if (this.submitFileNameParameter == null) {
            this.submitFileNameParameter = "filename";
        }
        this.submitTargetAddressParameter = this.getConfigurationValue(FaxJob2HTTPRequestConverterConfigurationConstants.SUBMIT_ACTION_TARGET_ADDRESS_PARAMETER_NAME_PROPERTY_KEY);
        if (this.submitTargetAddressParameter == null) {
            this.submitTargetAddressParameter = "targetaddress";
        }
        this.submitTargetNameParameter = this.getConfigurationValue(FaxJob2HTTPRequestConverterConfigurationConstants.SUBMIT_ACTION_TARGET_NAME_PARAMETER_NAME_PROPERTY_KEY);
        if (this.submitTargetNameParameter == null) {
            this.submitTargetNameParameter = "targetname";
        }
        this.submitSenderNameParameter = this.getConfigurationValue(FaxJob2HTTPRequestConverterConfigurationConstants.SUBMIT_ACTION_SENDER_NAME_PARAMETER_NAME_PROPERTY_KEY);
        if (this.submitSenderNameParameter == null) {
            this.submitSenderNameParameter = "sendername";
        }
        this.submitSenderFaxNumberParameter = this.getConfigurationValue(FaxJob2HTTPRequestConverterConfigurationConstants.SUBMIT_ACTION_SENDER_FAX_NUMBER_PARAMETER_NAME_PROPERTY_KEY);
        if (this.submitSenderFaxNumberParameter == null) {
            this.submitSenderFaxNumberParameter = "senderfaxnumber";
        }
        this.submitSenderEMailParameter = this.getConfigurationValue(FaxJob2HTTPRequestConverterConfigurationConstants.SUBMIT_ACTION_SENDER_EMAIL_PARAMETER_NAME_PROPERTY_KEY);
        if (this.submitSenderEMailParameter == null) {
            this.submitSenderEMailParameter = "senderemail";
        }
        this.suspendFaxJobIDParameter = this.getConfigurationValue(FaxJob2HTTPRequestConverterConfigurationConstants.SUSPEND_ACTION_FAX_JOB_ID_PARAMETER_NAME_PROPERTY_KEY);
        if (this.suspendFaxJobIDParameter == null) {
            this.suspendFaxJobIDParameter = "faxjobid";
        }
        this.resumeFaxJobIDParameter = this.getConfigurationValue(FaxJob2HTTPRequestConverterConfigurationConstants.RESUME_ACTION_FAX_JOB_ID_PARAMETER_NAME_PROPERTY_KEY);
        if (this.resumeFaxJobIDParameter == null) {
            this.resumeFaxJobIDParameter = "faxjobid";
        }
        this.cancelFaxJobIDParameter = this.getConfigurationValue(FaxJob2HTTPRequestConverterConfigurationConstants.CANCEL_ACTION_FAX_JOB_ID_PARAMETER_NAME_PROPERTY_KEY);
        if (this.cancelFaxJobIDParameter == null) {
            this.cancelFaxJobIDParameter = "faxjobid";
        }
        this.getStatusFaxJobIDParameter = this.getConfigurationValue(FaxJob2HTTPRequestConverterConfigurationConstants.GET_FAX_JOB_STATUS_ACTION_FAX_JOB_ID_PARAMETER_NAME_PROPERTY_KEY);
        if (this.getStatusFaxJobIDParameter == null) {
            this.getStatusFaxJobIDParameter = "faxjobid";
        }
        this.addFileNamePart = true;
        String value = this.getConfigurationValue(FaxJob2HTTPRequestConverterConfigurationConstants.ADD_FILE_NAME_AS_PART_PROPERTY_KEY);
        if (value != null) {
            this.addFileNamePart = Boolean.parseBoolean(value);
        }
        this.additionalParameters = this.initializeAdditionalParameters();
        if (this.additionalParameters != null) {
            this.additionalParameters = new HashMap<String, String>(this.additionalParameters);
            this.additionalParameters = Collections.unmodifiableMap(this.additionalParameters);
        }
    }

    protected Map<String, String> initializeAdditionalParameters() {
        Map<String, String> configuration = this.getConfiguration();
        String propertyPart = this.getPropertyPart();
        String prefix = FaxJob2HTTPRequestConverterConfigurationConstants.ADDITIONAL_PARAMETER_PROPERTY_KEY_PREFIX.toString();
        prefix = MessageFormat.format(prefix, propertyPart);
        HashMap<String, String> additionalParametersMap = new HashMap<String, String>();
        Iterator<Map.Entry<String, String>> iterator = configuration.entrySet().iterator();
        Map.Entry<String, String> entry = null;
        String key = null;
        String value = null;
        while (iterator.hasNext()) {
            entry = iterator.next();
            key = entry.getKey();
            if (key == null) continue;
            key = MessageFormat.format(key, propertyPart);
            if ((key = key.trim()).length() <= 0 || !key.startsWith(prefix) || (value = entry.getValue()) == null || (value = value.trim()).length() <= 0) continue;
            key = key.substring(prefix.length());
            additionalParametersMap.put(key, value);
        }
        return additionalParametersMap;
    }

    @Override
    public HTTPRequest createHTTPRequest(HTTPFaxClientSpi faxClientSpi, FaxActionType faxActionType, FaxJob faxJob) {
        HTTPRequest httpRequest = this.createCommonHTTPRequest(faxClientSpi, faxActionType);
        LinkedList contentList = new LinkedList();
        switch (faxActionType) {
            case SUBMIT_FAX_JOB: {
                String value = faxJob.getTargetAddress();
                this.addContentPart(contentList, this.submitTargetAddressParameter, value);
                value = faxJob.getTargetName();
                this.addContentPart(contentList, this.submitTargetNameParameter, value);
                value = faxJob.getSenderName();
                this.addContentPart(contentList, this.submitSenderNameParameter, value);
                value = faxJob.getSenderFaxNumber();
                this.addContentPart(contentList, this.submitSenderFaxNumberParameter, value);
                value = faxJob.getSenderEmail();
                this.addContentPart(contentList, this.submitSenderEMailParameter, value);
                File file = faxJob.getFile();
                contentList.add(new HTTPRequest.ContentPart<File>(this.submitFileContentParameter, file, HTTPRequest.ContentPartType.FILE));
                if (!this.shouldAddFileNamePart()) break;
                value = file.getName();
                this.addContentPart(contentList, this.submitFileNameParameter, value);
                break;
            }
            case SUSPEND_FAX_JOB: {
                this.addContentPart(contentList, this.suspendFaxJobIDParameter, faxJob.getID());
                break;
            }
            case RESUME_FAX_JOB: {
                this.addContentPart(contentList, this.resumeFaxJobIDParameter, faxJob.getID());
                break;
            }
            case CANCEL_FAX_JOB: {
                this.addContentPart(contentList, this.cancelFaxJobIDParameter, faxJob.getID());
                break;
            }
            case GET_FAX_JOB_STATUS: {
                this.addContentPart(contentList, this.getStatusFaxJobIDParameter, faxJob.getID());
                break;
            }
            default: {
                throw new FaxException("Fax action type: " + (Object)((Object)faxActionType) + " not supported.");
            }
        }
        this.addAdditionalParameters(contentList);
        this.addAdditionalContentParts(faxClientSpi, faxActionType, faxJob, contentList);
        HTTPRequest.ContentPart[] content = contentList.toArray(new HTTPRequest.ContentPart[contentList.size()]);
        httpRequest.setContent(content);
        return httpRequest;
    }

    protected boolean shouldAddFileNamePart() {
        return this.addFileNamePart;
    }

    protected HTTPRequest createCommonHTTPRequest(HTTPFaxClientSpi faxClientSpi, FaxActionType faxActionType) {
        HTTPRequest httpRequest = new HTTPRequest();
        String resource = faxClientSpi.getHTTPResource(faxActionType);
        httpRequest.setResource(resource);
        String urlParameters = faxClientSpi.getHTTPURLParameters();
        httpRequest.setParametersText(urlParameters);
        return httpRequest;
    }

    protected final void addContentPart(List<HTTPRequest.ContentPart<?>> contentList, String key, String value) {
        if (key != null && value != null && value.length() > 0 && this.shouldAddContentPart(key)) {
            contentList.add(new HTTPRequest.ContentPart<String>(key, value, HTTPRequest.ContentPartType.STRING));
        }
    }

    protected boolean shouldAddContentPart(String key) {
        boolean addPart = true;
        if (key.equals(FaxJob2HTTPRequestConverterConfigurationConstants.IGNORE_PARAMETER_KEY.toString())) {
            addPart = false;
        }
        return addPart;
    }

    protected final void addAdditionalParameters(List<HTTPRequest.ContentPart<?>> contentList) {
        if (this.additionalParameters != null) {
            Iterator<Map.Entry<String, String>> iterator = this.additionalParameters.entrySet().iterator();
            Map.Entry<String, String> entry = null;
            String key = null;
            String value = null;
            while (iterator.hasNext()) {
                entry = iterator.next();
                key = entry.getKey();
                value = entry.getValue();
                if (key == null || value == null) continue;
                this.addContentPart(contentList, key, value);
            }
        }
    }

    protected void addAdditionalContentParts(HTTPFaxClientSpi faxClientSpi, FaxActionType faxActionType, FaxJob faxJob, List<HTTPRequest.ContentPart<?>> contentList) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FaxJob2HTTPRequestConverterConfigurationConstants {
        SUBMIT_ACTION_FILE_CONTENT_PARAMETER_NAME_PROPERTY_KEY("org.fax4j.spi.{0}.multi.part.submit.file.content.parameter"),
        SUBMIT_ACTION_FILE_NAME_PARAMETER_NAME_PROPERTY_KEY("org.fax4j.spi.{0}.multi.part.submit.file.name.parameter"),
        SUBMIT_ACTION_TARGET_ADDRESS_PARAMETER_NAME_PROPERTY_KEY("org.fax4j.spi.{0}.multi.part.submit.target.address.parameter"),
        SUBMIT_ACTION_TARGET_NAME_PARAMETER_NAME_PROPERTY_KEY("org.fax4j.spi.{0}.multi.part.submit.target.name.parameter"),
        SUBMIT_ACTION_SENDER_NAME_PARAMETER_NAME_PROPERTY_KEY("org.fax4j.spi.{0}.multi.part.submit.sender.name.parameter"),
        SUBMIT_ACTION_SENDER_FAX_NUMBER_PARAMETER_NAME_PROPERTY_KEY("org.fax4j.spi.{0}.multi.part.submit.sender.fax.number.parameter"),
        SUBMIT_ACTION_SENDER_EMAIL_PARAMETER_NAME_PROPERTY_KEY("org.fax4j.spi.{0}.multi.part.submit.sender.email.parameter"),
        SUSPEND_ACTION_FAX_JOB_ID_PARAMETER_NAME_PROPERTY_KEY("org.fax4j.spi.{0}.multi.part.suspend.fax.job.id.parameter"),
        RESUME_ACTION_FAX_JOB_ID_PARAMETER_NAME_PROPERTY_KEY("org.fax4j.spi.{0}.multi.part.resume.fax.job.id.parameter"),
        CANCEL_ACTION_FAX_JOB_ID_PARAMETER_NAME_PROPERTY_KEY("org.fax4j.spi.{0}.multi.part.cancel.fax.job.id.parameter"),
        GET_FAX_JOB_STATUS_ACTION_FAX_JOB_ID_PARAMETER_NAME_PROPERTY_KEY("org.fax4j.spi.{0}.multi.part.get.status.fax.job.id.parameter"),
        ADDITIONAL_PARAMETER_PROPERTY_KEY_PREFIX("org.fax4j.spi.{0}.multi.part.parameter.key."),
        ADD_FILE_NAME_AS_PART_PROPERTY_KEY("org.fax4j.spi.{0}.multi.part.add.file.name.as.part"),
        IGNORE_PARAMETER_KEY("_IGNORE_");

        private String value;

        private FaxJob2HTTPRequestConverterConfigurationConstants(String value) {
            this.value = value;
        }

        public final String toString() {
            return this.value;
        }
    }
}

