/*
 * Decompiled with CFR 0.152.
 */
package org.fax4j.spi.http;

import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.fax4j.FaxException;
import org.fax4j.FaxJob;
import org.fax4j.common.Fax4JProvider;
import org.fax4j.common.FaxActionType;
import org.fax4j.spi.http.AbstractFaxJob2HTTPRequestConverter;
import org.fax4j.spi.http.HTTPFaxClientSpi;
import org.fax4j.spi.http.HTTPRequest;
import org.fax4j.util.IOHelper;
import org.fax4j.util.SpiUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateFaxJob2HTTPRequestConverter
extends AbstractFaxJob2HTTPRequestConverter {
    private Map<String, String> httpRequestTemplateMap;

    public TemplateFaxJob2HTTPRequestConverter() {
        super(Fax4JProvider.FAX4J_PROVIDER);
    }

    @Override
    protected void initializeImpl() {
        this.httpRequestTemplateMap = new HashMap<String, String>();
        String[] templateNames = new String[]{FaxJob2HTTPRequestConverterConfigurationConstants.SUBMIT_FAX_JOB_TEMPLATE_PROPERTY_KEY.toString(), FaxJob2HTTPRequestConverterConfigurationConstants.SUSPEND_FAX_JOB_TEMPLATE_PROPERTY_KEY.toString(), FaxJob2HTTPRequestConverterConfigurationConstants.RESUME_FAX_JOB_TEMPLATE_PROPERTY_KEY.toString(), FaxJob2HTTPRequestConverterConfigurationConstants.CANCEL_FAX_JOB_TEMPLATE_PROPERTY_KEY.toString(), FaxJob2HTTPRequestConverterConfigurationConstants.GET_FAX_JOB_STATUS_TEMPLATE_PROPERTY_KEY.toString()};
        int amount = templateNames.length;
        String encoding = this.getConfigurationValue(FaxJob2HTTPRequestConverterConfigurationConstants.TEMPLATE_ENCODING_PROPERTY_KEY);
        String templateName = null;
        String urlStr = null;
        URL url = null;
        String template = null;
        for (int index = 0; index < amount; ++index) {
            templateName = templateNames[index];
            urlStr = this.getConfigurationValue(templateName);
            if (urlStr == null) continue;
            try {
                url = new URL(urlStr);
                InputStream stream = url.openStream();
                Reader reader = IOHelper.createReader(stream, encoding);
                template = IOHelper.readTextStream(reader);
                this.httpRequestTemplateMap.put(templateName, template);
                continue;
            }
            catch (Throwable throwable) {
                throw new FaxException("Unable to load template for URL: " + urlStr, throwable);
            }
        }
    }

    @Override
    public HTTPRequest createHTTPRequest(HTTPFaxClientSpi faxClientSpi, FaxActionType faxActionType, FaxJob faxJob) {
        FaxJob2HTTPRequestConverterConfigurationConstants templateName = null;
        switch (faxActionType) {
            case SUBMIT_FAX_JOB: {
                templateName = FaxJob2HTTPRequestConverterConfigurationConstants.SUBMIT_FAX_JOB_TEMPLATE_PROPERTY_KEY;
                break;
            }
            case SUSPEND_FAX_JOB: {
                templateName = FaxJob2HTTPRequestConverterConfigurationConstants.SUSPEND_FAX_JOB_TEMPLATE_PROPERTY_KEY;
                break;
            }
            case RESUME_FAX_JOB: {
                templateName = FaxJob2HTTPRequestConverterConfigurationConstants.RESUME_FAX_JOB_TEMPLATE_PROPERTY_KEY;
                break;
            }
            case CANCEL_FAX_JOB: {
                templateName = FaxJob2HTTPRequestConverterConfigurationConstants.CANCEL_FAX_JOB_TEMPLATE_PROPERTY_KEY;
                break;
            }
            case GET_FAX_JOB_STATUS: {
                templateName = FaxJob2HTTPRequestConverterConfigurationConstants.GET_FAX_JOB_STATUS_TEMPLATE_PROPERTY_KEY;
                break;
            }
            default: {
                throw new FaxException("Fax action type: " + (Object)((Object)faxActionType) + " not supported.");
            }
        }
        HTTPRequest httpRequest = this.createHTTPRequest(faxClientSpi, faxActionType, templateName, faxJob);
        return httpRequest;
    }

    protected String formatTemplate(String template, FaxJob faxJob) {
        return SpiUtil.formatTemplate(template, faxJob, null, true, false);
    }

    protected String formatHTTPResource(HTTPFaxClientSpi faxClientSpi, FaxActionType faxActionType, FaxJob faxJob) {
        String resourceTemplate = faxClientSpi.getHTTPResource(faxActionType);
        String resource = SpiUtil.formatTemplate(resourceTemplate, faxJob, SpiUtil.URL_ENCODER, false, false);
        return resource;
    }

    protected String formatHTTPURLParameters(HTTPFaxClientSpi faxClientSpi, FaxJob faxJob) {
        String urlParametersTemplate = faxClientSpi.getHTTPURLParameters();
        String urlParameters = SpiUtil.formatTemplate(urlParametersTemplate, faxJob, SpiUtil.URL_ENCODER, false, false);
        return urlParameters;
    }

    protected HTTPRequest createHTTPRequest(HTTPFaxClientSpi faxClientSpi, FaxActionType faxActionType, Enum<?> templateNameEnum, FaxJob faxJob) {
        String templateName = templateNameEnum.toString();
        String template = this.httpRequestTemplateMap.get(templateName);
        HTTPRequest httpRequest = null;
        if (template != null) {
            String content = this.formatTemplate(template, faxJob);
            String resource = this.formatHTTPResource(faxClientSpi, faxActionType, faxJob);
            String parametersText = this.formatHTTPURLParameters(faxClientSpi, faxJob);
            httpRequest = new HTTPRequest();
            httpRequest.setResource(resource);
            httpRequest.setContent(content);
            httpRequest.setParametersText(parametersText);
        }
        return httpRequest;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FaxJob2HTTPRequestConverterConfigurationConstants {
        TEMPLATE_ENCODING_PROPERTY_KEY("org.fax4j.spi.{0}.template.encoding"),
        SUBMIT_FAX_JOB_TEMPLATE_PROPERTY_KEY("org.fax4j.spi.{0}.submit.template.url"),
        SUSPEND_FAX_JOB_TEMPLATE_PROPERTY_KEY("org.fax4j.spi.{0}.suspend.template.url"),
        RESUME_FAX_JOB_TEMPLATE_PROPERTY_KEY("org.fax4j.spi.{0}.resume.template.url"),
        CANCEL_FAX_JOB_TEMPLATE_PROPERTY_KEY("org.fax4j.spi.{0}.cancel.template.url"),
        GET_FAX_JOB_STATUS_TEMPLATE_PROPERTY_KEY("org.fax4j.spi.{0}.get.status.template.url");

        private String value;

        private FaxJob2HTTPRequestConverterConfigurationConstants(String value) {
            this.value = value;
        }

        public final String toString() {
            return this.value;
        }
    }
}

