/*
 * Decompiled with CFR 0.152.
 */
package org.fax4j.spi.http;

import java.io.ByteArrayInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.fax4j.FaxException;
import org.fax4j.FaxJobStatus;
import org.fax4j.common.FaxActionType;
import org.fax4j.spi.http.AbstractMappingHTTPResponseHandler;
import org.fax4j.spi.http.HTTPResponse;
import org.fax4j.util.IOHelper;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLHTTPResponseHandler
extends AbstractMappingHTTPResponseHandler<Document> {
    @Override
    protected void populateFaxActionType2ReponseDataPathMappings() {
        FaxActionType[] faxActionTypes = new FaxActionType[]{FaxActionType.SUBMIT_FAX_JOB, FaxActionType.SUSPEND_FAX_JOB, FaxActionType.RESUME_FAX_JOB, FaxActionType.CANCEL_FAX_JOB, FaxActionType.GET_FAX_JOB_STATUS};
        Enum[] configurationKeys = new Enum[]{XMLHTTPResponseHandlerConfigurationConstants.SUBMIT_XML_OUTPUT_PROPERTY_KEY, XMLHTTPResponseHandlerConfigurationConstants.SUSPEND_XML_OUTPUT_PROPERTY_KEY, XMLHTTPResponseHandlerConfigurationConstants.RESUME_XML_OUTPUT_PROPERTY_KEY, XMLHTTPResponseHandlerConfigurationConstants.CANCEL_XML_OUTPUT_PROPERTY_KEY, XMLHTTPResponseHandlerConfigurationConstants.GET_STATUS_XML_OUTPUT_PROPERTY_KEY};
        this.populateFaxActionType2ReponseDataPathMappings(faxActionTypes, configurationKeys);
    }

    @Override
    protected void populateStatusString2FaxStatusMappings() {
        FaxJobStatus[] faxJobStatuses = new FaxJobStatus[]{FaxJobStatus.PENDING, FaxJobStatus.IN_PROGRESS, FaxJobStatus.ERROR};
        Enum[] configurationKeys = new Enum[]{XMLHTTPResponseHandlerConfigurationConstants.PENDING_STATUS_MAPPING_PROPERTY_KEY, XMLHTTPResponseHandlerConfigurationConstants.IN_PROGRESS_STATUS_MAPPING_PROPERTY_KEY, XMLHTTPResponseHandlerConfigurationConstants.ERROR_STATUS_MAPPING_PROPERTY_KEY};
        this.populateStatusString2FaxStatusMappings(faxJobStatuses, configurationKeys);
    }

    @Override
    protected Enum<?> getErrorDetectionPathPropertyKey() {
        return XMLHTTPResponseHandlerConfigurationConstants.ERROR_DETECTION_PATH_PROPERTY_KEY;
    }

    @Override
    protected Enum<?> getErrorDetectionValuePropertyKey() {
        return XMLHTTPResponseHandlerConfigurationConstants.ERROR_DETECTION_VALUE_PROPERTY_KEY;
    }

    @Override
    protected Enum<?> getErrorMessagePathPropertyKey() {
        return XMLHTTPResponseHandlerConfigurationConstants.ERROR_MESSAGE_PATH_PROPERTY_KEY;
    }

    @Override
    protected String findValueImpl(Document object, String path) {
        String[] pathParts = path.split(";");
        int pathPartsAmount = pathParts.length;
        String pathPart = null;
        StringBuilder buffer = new StringBuilder(500);
        for (int index = 0; index < pathPartsAmount; ++index) {
            pathPart = pathParts[index];
            if (pathPart.length() <= 0) continue;
            buffer.append("/");
            buffer.append(pathPart);
        }
        String xpathExpressionStr = buffer.toString();
        XPathFactory xpathFactory = XPathFactory.newInstance();
        XPath xpath = xpathFactory.newXPath();
        String value = null;
        try {
            XPathExpression xpathExpression = xpath.compile(xpathExpressionStr);
            value = xpathExpression.evaluate(object);
        }
        catch (XPathExpressionException exception) {
            throw new FaxException("Unable to parse/evaluate xpath expression: " + path, exception);
        }
        return value;
    }

    @Override
    protected Document convertToObject(HTTPResponse httpResponse) {
        Document document = null;
        String content = httpResponse.getContent();
        if (content != null) {
            String encoding = this.getResponseDataEncoding();
            byte[] data = IOHelper.convertStringToBinary(content, encoding);
            ByteArrayInputStream inputStream = new ByteArrayInputStream(data);
            try {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                document = documentBuilder.parse(inputStream);
            }
            catch (Exception exception) {
                throw new FaxException("Unable to parse HTTP response text as XML.", exception);
            }
            finally {
                IOHelper.closeResource(inputStream);
            }
        }
        return document;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum XMLHTTPResponseHandlerConfigurationConstants {
        SUBMIT_XML_OUTPUT_PROPERTY_KEY("org.fax4j.spi.{0}.submit.xml.output.path"),
        SUSPEND_XML_OUTPUT_PROPERTY_KEY("org.fax4j.spi.{0}.suspend.xml.output.path"),
        RESUME_XML_OUTPUT_PROPERTY_KEY("org.fax4j.spi.{0}.resume.xml.output.path"),
        CANCEL_XML_OUTPUT_PROPERTY_KEY("org.fax4j.spi.{0}.cancel.xml.output.path"),
        GET_STATUS_XML_OUTPUT_PROPERTY_KEY("org.fax4j.spi.{0}.get.status.xml.output.path"),
        PENDING_STATUS_MAPPING_PROPERTY_KEY("org.fax4j.spi.{0}.xml.pending.status.mappings"),
        IN_PROGRESS_STATUS_MAPPING_PROPERTY_KEY("org.fax4j.spi.{0}.xml.inprogress.status.mappings"),
        ERROR_STATUS_MAPPING_PROPERTY_KEY("org.fax4j.spi.{0}.xml.error.status.mappings"),
        ERROR_DETECTION_PATH_PROPERTY_KEY("org.fax4j.spi.{0}.xml.error.detection.path"),
        ERROR_DETECTION_VALUE_PROPERTY_KEY("org.fax4j.spi.{0}.xml.error.detection.value"),
        ERROR_MESSAGE_PATH_PROPERTY_KEY("org.fax4j.spi.{0}.xml.error.message.path");

        private String value;

        private XMLHTTPResponseHandlerConfigurationConstants(String value) {
            this.value = value;
        }

        public final String toString() {
            return this.value;
        }
    }
}

