/*
 * Decompiled with CFR 0.152.
 */
package org.fax4j.spi.hylafax;

import gnu.hylafax.HylaFAXClient;
import gnu.hylafax.HylaFAXClientProtocol;
import gnu.hylafax.Job;
import org.fax4j.FaxException;
import org.fax4j.FaxJob;
import org.fax4j.spi.AbstractFax4JClientSpi;
import org.fax4j.spi.hylafax.HylaFAXClientConnectionFactory;
import org.fax4j.spi.hylafax.HylaFAXClientConnectionFactoryImpl;
import org.fax4j.spi.hylafax.HylaFaxJob;
import org.fax4j.util.Connection;
import org.fax4j.util.ConnectionFactory;
import org.fax4j.util.ReflectionHelper;

public class HylaFaxClientSpi
extends AbstractFax4JClientSpi {
    private ConnectionFactory<HylaFAXClient> connectionFactory;
    private Connection<HylaFAXClient> connection;
    public static final int DEFAULT_PORT_PROPERTY_VALUE = HylaFAXClientProtocol.DEFAULT_PORT;

    protected void initializeImpl() {
        String className = this.getConfigurationValue(FaxClientSpiConfigurationConstants.CONNECTION_FACTORY_CLASS_NAME_PROPERTY_KEY);
        if (className == null) {
            className = HylaFAXClientConnectionFactoryImpl.class.getName();
        }
        this.connectionFactory = this.createHylaFAXClientConnectionFactory(className);
        if (this.connectionFactory == null) {
            throw new FaxException("HylaFAX connection factory is not available.");
        }
    }

    protected final HylaFAXClientConnectionFactory createHylaFAXClientConnectionFactory(String className) {
        HylaFAXClientConnectionFactory factory = (HylaFAXClientConnectionFactory)ReflectionHelper.createInstance(className);
        factory.initialize(this);
        return factory;
    }

    protected synchronized HylaFAXClient getHylaFAXClient() {
        HylaFAXClient client = null;
        if (this.connection == null) {
            this.connection = this.connectionFactory.createConnection();
        }
        client = this.connection.getResource();
        return client;
    }

    protected void finalize() throws Throwable {
        Connection<HylaFAXClient> closeable = this.connection;
        if (closeable != null) {
            closeable.close();
        }
        super.finalize();
    }

    protected FaxJob createFaxJobImpl() {
        HylaFAXClient client = this.getHylaFAXClient();
        HylaFaxJob faxJob = null;
        try {
            Job job = client.createJob();
            faxJob = new HylaFaxJob(job);
        }
        catch (RuntimeException exception) {
            throw exception;
        }
        catch (Exception exception) {
            throw new FaxException("General error.", exception);
        }
        return faxJob;
    }

    protected void submitFaxJobImpl(FaxJob faxJob) {
        HylaFaxJob hylaFaxJob = (HylaFaxJob)faxJob;
        HylaFAXClient client = this.getHylaFAXClient();
        try {
            this.submitFaxJob(hylaFaxJob, client);
        }
        catch (FaxException exception) {
            throw exception;
        }
        catch (Exception exception) {
            throw new FaxException("General error.", exception);
        }
    }

    protected void suspendFaxJobImpl(FaxJob faxJob) {
        HylaFaxJob hylaFaxJob = (HylaFaxJob)faxJob;
        HylaFAXClient client = this.getHylaFAXClient();
        try {
            this.suspendFaxJob(hylaFaxJob, client);
        }
        catch (FaxException exception) {
            throw exception;
        }
        catch (Exception exception) {
            throw new FaxException("General error.", exception);
        }
    }

    protected void resumeFaxJobImpl(FaxJob faxJob) {
        HylaFaxJob hylaFaxJob = (HylaFaxJob)faxJob;
        HylaFAXClient client = this.getHylaFAXClient();
        try {
            this.resumeFaxJob(hylaFaxJob, client);
        }
        catch (FaxException exception) {
            throw exception;
        }
        catch (Exception exception) {
            throw new FaxException("General error.", exception);
        }
    }

    protected void cancelFaxJobImpl(FaxJob faxJob) {
        HylaFaxJob hylaFaxJob = (HylaFaxJob)faxJob;
        HylaFAXClient client = this.getHylaFAXClient();
        try {
            this.cancelFaxJob(hylaFaxJob, client);
        }
        catch (FaxException exception) {
            throw exception;
        }
        catch (Exception exception) {
            throw new FaxException("General error.", exception);
        }
    }

    protected void submitFaxJob(HylaFaxJob faxJob, HylaFAXClient client) throws Exception {
        Job job = faxJob.getHylaFaxJob();
        String filePath = faxJob.getFilePath();
        job.addDocument(filePath);
        client.submit(job);
    }

    protected void suspendFaxJob(HylaFaxJob faxJob, HylaFAXClient client) throws Exception {
        Job job = faxJob.getHylaFaxJob();
        client.suspend(job);
    }

    protected void resumeFaxJob(HylaFaxJob faxJob, HylaFAXClient client) throws Exception {
        Job job = faxJob.getHylaFaxJob();
        long faxJobID = job.getId();
        client.retry(faxJobID);
    }

    protected void cancelFaxJob(HylaFaxJob faxJob, HylaFAXClient client) throws Exception {
        Job job = faxJob.getHylaFaxJob();
        client.kill(job);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FaxClientSpiConfigurationConstants {
        CONNECTION_FACTORY_CLASS_NAME_PROPERTY_KEY("org.fax4j.spi.hylafax.connection.factory.class.name"),
        HOST_PROPERTY_KEY("org.fax4j.spi.hylafax.host"),
        PORT_PROPERTY_KEY("org.fax4j.spi.hylafax.port"),
        USER_NAME_PROPERTY_KEY("org.fax4j.spi.hylafax.user"),
        PASSWORD_PROPERTY_KEY("org.fax4j.spi.hylafax.password"),
        ENABLE_ADMIN_OPERATIONS_PROPERTY_KEY("org.fax4j.spi.hylafax.admin"),
        MODE_PROPERTY_KEY("org.fax4j.spi.hylafax.mode"),
        TYPE_PROPERTY_KEY("org.fax4j.spi.hylafax.type");

        private String value;

        private FaxClientSpiConfigurationConstants(String value) {
            this.value = value;
        }

        public final String toString() {
            return this.value;
        }
    }
}

