/*
 * Decompiled with CFR 0.152.
 */
package org.fax4j.spi.hylafax;

import gnu.hylafax.Job;
import java.io.File;
import org.fax4j.FaxException;
import org.fax4j.FaxJob;
import org.fax4j.spi.AbstractFaxJob;

public class HylaFaxJob
extends AbstractFaxJob {
    private final Job JOB;
    private File file;

    public HylaFaxJob(Job job) {
        this.JOB = job;
    }

    public String toString() {
        StringBuilder buffer = this.addToStringAttributes("Hylafax Fax Job");
        String text = buffer.toString();
        return text;
    }

    protected Job getHylaFaxJob() {
        return this.JOB;
    }

    public String getID() {
        return String.valueOf(this.JOB.getId());
    }

    public void setID(String id) {
        throw new FaxException("Fax job ID should not be set via this method.");
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public FaxJob.FaxJobPriority getPriority() {
        int priority = 127;
        try {
            priority = this.JOB.getPriority();
        }
        catch (Exception exception) {
            throw new FaxException("Error while extracting job priority.", exception);
        }
        FaxJob.FaxJobPriority faxJobPriority = null;
        switch (priority) {
            case 63: {
                faxJobPriority = FaxJob.FaxJobPriority.HIGH_PRIORITY;
                break;
            }
            default: {
                faxJobPriority = FaxJob.FaxJobPriority.MEDIUM_PRIORITY;
            }
        }
        return faxJobPriority;
    }

    public void setPriority(FaxJob.FaxJobPriority priority) {
        try {
            if (priority == FaxJob.FaxJobPriority.HIGH_PRIORITY) {
                this.JOB.setPriority(63);
            } else {
                this.JOB.setPriority(127);
            }
        }
        catch (Exception exception) {
            throw new FaxException("Error while setting job priority.", exception);
        }
    }

    public String getTargetAddress() {
        String value = null;
        try {
            value = this.JOB.getDialstring();
        }
        catch (Exception exception) {
            throw new FaxException("Error while extracting job target address.", exception);
        }
        return value;
    }

    public void setTargetAddress(String targetAddress) {
        try {
            this.JOB.setDialstring(targetAddress);
        }
        catch (Exception exception) {
            throw new FaxException("Error while setting job target address.", exception);
        }
    }

    public String getTargetName() {
        return null;
    }

    public void setTargetName(String targetName) {
    }

    public String getSenderName() {
        String value = null;
        try {
            value = this.JOB.getFromUser();
        }
        catch (Exception exception) {
            throw new FaxException("Error while extracting job sender name.", exception);
        }
        return value;
    }

    public void setSenderName(String senderName) {
        try {
            this.JOB.setFromUser(senderName);
        }
        catch (Exception exception) {
            throw new FaxException("Error while setting job sender name.", exception);
        }
    }

    public String getSenderFaxNumber() {
        return null;
    }

    public void setSenderFaxNumber(String senderFaxNumber) {
    }

    public String getSenderEmail() {
        return null;
    }

    public void setSenderEmail(String senderEmail) {
    }

    public void setProperty(String key, String value) {
        try {
            this.JOB.setProperty(key, value);
        }
        catch (Exception exception) {
            throw new FaxException("Error while setting job property.", exception);
        }
    }

    public String getProperty(String key, String defaultValue) {
        String value = null;
        try {
            value = this.JOB.getProperty(key);
        }
        catch (Exception exception) {
            throw new FaxException("Error while extracting job property.", exception);
        }
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }
}

