/*
 * Decompiled with CFR 0.152.
 */
package org.fax4j.spi.java4less;

import java.awt.image.BufferedImage;
import java.lang.reflect.Field;
import org.fax4j.FaxException;
import org.fax4j.FaxJob;
import org.fax4j.spi.AbstractFax4JClientSpi;
import org.fax4j.util.IOHelper;
import org.fax4j.util.ReflectionHelper;

public class RFaxFaxClientSpi
extends AbstractFax4JClientSpi {
    private String portName;
    private int faxClass;

    protected void initializeImpl() {
        this.portName = this.getConfigurationValue(FaxClientSpiConfigurationConstants.PORT_NAME_PROPERTY_KEY);
        if (this.portName == null) {
            throw new FaxException("Port name not defined in fax4j.properties. Property: " + (Object)((Object)FaxClientSpiConfigurationConstants.PORT_NAME_PROPERTY_KEY));
        }
        this.faxClass = Integer.parseInt(this.getConfigurationValue(FaxClientSpiConfigurationConstants.FAX_CLASS_PROPERTY_KEY));
    }

    protected void submitFaxJobImpl(FaxJob faxJob) {
        try {
            this.submitFaxJobViaFaxModem(faxJob);
        }
        catch (RuntimeException exception) {
            throw exception;
        }
        catch (Exception exception) {
            throw new FaxException("Unable to send fax via fax modem.", exception);
        }
    }

    protected void submitFaxJobViaFaxModem(FaxJob faxJob) throws Exception {
        Field field;
        Class<?> classDefinition;
        String type = faxJob.getProperty(FaxJobExtendedPropertyConstants.DATA_TYPE_FAX_JOB_PROPERTY_KEY.toString(), "TEXT");
        int width = Integer.parseInt(faxJob.getProperty(FaxJobExtendedPropertyConstants.WIDTH_FAX_JOB_PROPERTY_KEY.toString(), null));
        int height = Integer.parseInt(faxJob.getProperty(FaxJobExtendedPropertyConstants.HEIGHT_FAX_JOB_PROPERTY_KEY.toString(), null));
        int imageType = Integer.parseInt(faxJob.getProperty(FaxJobExtendedPropertyConstants.IMAGE_TYPE_FAX_JOB_PROPERTY_KEY.toString(), String.valueOf(1)));
        BufferedImage image = new BufferedImage(width, height, imageType);
        Object faxProducer = null;
        if (type.equalsIgnoreCase("PDF")) {
            classDefinition = ReflectionHelper.getType("com.java4less.rfax.PDFFaxProducer");
            faxProducer = ReflectionHelper.createInstance(classDefinition);
            ReflectionHelper.invokeMethod(classDefinition, faxProducer, "setPDFFile", new Class[]{String.class}, new Object[]{faxJob.getFilePath()});
            Field field2 = ReflectionHelper.getField(classDefinition, "pageImage");
            field2.set(faxProducer, image);
        } else if (type.equalsIgnoreCase("TEXT")) {
            classDefinition = ReflectionHelper.getType("com.java4less.rfax.TextFaxProducer");
            faxProducer = ReflectionHelper.createInstance(classDefinition);
            String text = IOHelper.readTextFile(faxJob.getFile());
            field = ReflectionHelper.getField(classDefinition, "text");
            field.set(faxProducer, text);
            field = ReflectionHelper.getField(classDefinition, "pageImage");
            field.set(faxProducer, image);
            ReflectionHelper.invokeMethod(classDefinition, faxProducer, "prepare", null, null);
        } else {
            throw new FaxException("Unsupported type provided: " + type);
        }
        Class<?> faxModemClassDefinition = ReflectionHelper.getType("com.java4less.rfax.FaxModem");
        Object faxModem = ReflectionHelper.createInstance(faxModemClassDefinition);
        ReflectionHelper.invokeMethod(faxModemClassDefinition, faxModem, "setPortName", new Class[]{String.class}, new Object[]{this.portName});
        field = ReflectionHelper.getField(faxModemClassDefinition, "faxClass");
        field.set(faxModem, this.faxClass);
        Class<?> faxProducerClassDefinition = ReflectionHelper.getType("com.java4less.rfax.FaxProducer");
        ReflectionHelper.invokeMethod(faxModemClassDefinition, faxModem, "open", new Class[]{faxProducerClassDefinition}, new Object[]{faxProducer});
        boolean faxSent = (Boolean)ReflectionHelper.invokeMethod(faxModemClassDefinition, faxModem, "sendFax", new Class[]{String.class}, new Object[]{faxJob.getTargetAddress()});
        ReflectionHelper.invokeMethod(faxModemClassDefinition, faxModem, "close", null, null);
        if (!faxSent) {
            field = ReflectionHelper.getField(faxModemClassDefinition, "lastError");
            String lastError = (String)field.get(faxModem);
            throw new FaxException("Error while sending fax. Error: " + lastError);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FaxJobExtendedPropertyConstants {
        DATA_TYPE_FAX_JOB_PROPERTY_KEY("data.type"),
        WIDTH_FAX_JOB_PROPERTY_KEY("width"),
        HEIGHT_FAX_JOB_PROPERTY_KEY("height"),
        IMAGE_TYPE_FAX_JOB_PROPERTY_KEY("image.type");

        private String value;

        private FaxJobExtendedPropertyConstants(String value) {
            this.value = value;
        }

        public final String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FaxClientSpiConfigurationConstants {
        PORT_NAME_PROPERTY_KEY("org.fax4j.spi.rfax.port.name"),
        FAX_CLASS_PROPERTY_KEY("org.fax4j.spi.rfax.fax.class");

        private String value;

        private FaxClientSpiConfigurationConstants(String value) {
            this.value = value;
        }

        public final String toString() {
            return this.value;
        }
    }
}

