/*
 * Decompiled with CFR 0.152.
 */
package org.fax4j.spi.mac;

import org.fax4j.FaxException;
import org.fax4j.FaxJob;
import org.fax4j.common.FaxActionType;
import org.fax4j.spi.AbstractFax4JClientSpi;
import org.fax4j.spi.process.ExitCodeProcessOutputValidator;
import org.fax4j.spi.process.ProcessOutputValidator;
import org.fax4j.util.ProcessExecutorHelper;
import org.fax4j.util.SpiUtil;

public class MacFaxClientSpi
extends AbstractFax4JClientSpi {
    private String submitCommand;
    private String printQueueParameter;
    private String printQueueName;
    private String generalParameters;
    private String phoneParameter;
    private String faxToParameter;
    private ProcessOutputValidator processOutputValidator;

    protected void initializeImpl() {
        this.submitCommand = this.getConfigurationValue(FaxClientSpiConfigurationConstants.SUBMIT_FAX_JOB_COMMAND_PROPERTY_KEY);
        if (this.submitCommand == null) {
            this.submitCommand = FaxClientSpiConfigurationConstants.SUBMIT_FAX_JOB_COMMAND_DEFAULT_VALUE.toString();
        }
        this.printQueueParameter = this.getConfigurationValue(FaxClientSpiConfigurationConstants.PRINT_QUEUE_PARAMETER_PROPERTY_KEY);
        if (this.printQueueParameter == null) {
            this.printQueueParameter = FaxClientSpiConfigurationConstants.PRINT_QUEUE_PARAMETER_DEFAULT_VALUE.toString();
        }
        this.printQueueName = this.getConfigurationValue(FaxClientSpiConfigurationConstants.PRINT_QUEUE_NAME_PROPERTY_KEY);
        if (this.printQueueName == null) {
            throw new FaxException("Print queue name not defined in fax4j.properties. Property: " + (Object)((Object)FaxClientSpiConfigurationConstants.PRINT_QUEUE_NAME_PROPERTY_KEY));
        }
        this.generalParameters = this.getConfigurationValue(FaxClientSpiConfigurationConstants.GENERAL_PARAMETERS_PROPERTY_KEY);
        if (this.generalParameters == null) {
            this.generalParameters = FaxClientSpiConfigurationConstants.GENERAL_PARAMETERS_DEFAULT_VALUE.toString();
        }
        this.phoneParameter = this.getConfigurationValue(FaxClientSpiConfigurationConstants.PHONE_PARAMETER_PROPERTY_KEY);
        if (this.phoneParameter == null) {
            this.phoneParameter = FaxClientSpiConfigurationConstants.PHONE_PARAMETER_DEFAULT_VALUE.toString();
        }
        this.faxToParameter = this.getConfigurationValue(FaxClientSpiConfigurationConstants.FAX_TO_PARAMETER_PROPERTY_KEY);
        if (this.faxToParameter == null) {
            this.faxToParameter = FaxClientSpiConfigurationConstants.FAX_TO_PARAMETER_DEFAULT_VALUE.toString();
        }
        this.processOutputValidator = this.createMacProcessOutputValidator();
    }

    protected ProcessOutputValidator createMacProcessOutputValidator() {
        ExitCodeProcessOutputValidator validator = new ExitCodeProcessOutputValidator();
        return validator;
    }

    protected void submitFaxJobImpl(FaxJob faxJob) {
        String command = this.createSubmitFaxCommand(faxJob);
        this.executeProcess(command, FaxActionType.SUBMIT_FAX_JOB);
    }

    protected String createSubmitFaxCommand(FaxJob faxJob) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.submitCommand);
        buffer.append(" ");
        buffer.append(this.printQueueParameter);
        buffer.append(" ");
        buffer.append(this.printQueueName);
        buffer.append(" ");
        buffer.append(this.generalParameters);
        buffer.append(" ");
        buffer.append(this.phoneParameter);
        buffer.append("=");
        buffer.append(faxJob.getTargetAddress());
        String targetName = faxJob.getTargetName();
        if (targetName != null && targetName.length() > 0) {
            buffer.append(" ");
            buffer.append(this.faxToParameter);
            buffer.append("=\"");
            targetName = SpiUtil.urlEncode(targetName);
            buffer.append(targetName);
            buffer.append("\"");
        }
        buffer.append(" \"");
        buffer.append(faxJob.getFilePath());
        buffer.append("\"");
        String command = buffer.toString();
        return command;
    }

    protected ProcessExecutorHelper.ProcessOutput executeProcess(String command, FaxActionType faxActionType) {
        ProcessExecutorHelper.ProcessOutput processOutput = ProcessExecutorHelper.executeProcess(this, command);
        this.processOutputValidator.validateProcessOutput(this, processOutput, faxActionType);
        return processOutput;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FaxClientSpiConfigurationConstants {
        SUBMIT_FAX_JOB_COMMAND_PROPERTY_KEY("org.fax4j.spi.mac.submit.command"),
        PRINT_QUEUE_PARAMETER_PROPERTY_KEY("org.fax4j.spi.mac.print.queue.parameter"),
        PRINT_QUEUE_NAME_PROPERTY_KEY("org.fax4j.spi.mac.print.queue.name"),
        GENERAL_PARAMETERS_PROPERTY_KEY("org.fax4j.spi.mac.general.parameters"),
        PHONE_PARAMETER_PROPERTY_KEY("org.fax4j.spi.mac.phone.parameter"),
        FAX_TO_PARAMETER_PROPERTY_KEY("org.fax4j.spi.mac.fax.to.parameter"),
        SUBMIT_FAX_JOB_COMMAND_DEFAULT_VALUE("lp"),
        PRINT_QUEUE_PARAMETER_DEFAULT_VALUE("-d"),
        GENERAL_PARAMETERS_DEFAULT_VALUE("-o"),
        PHONE_PARAMETER_DEFAULT_VALUE("phone"),
        FAX_TO_PARAMETER_DEFAULT_VALUE("faxTo");

        private String value;

        private FaxClientSpiConfigurationConstants(String value) {
            this.value = value;
        }

        public final String toString() {
            return this.value;
        }
    }
}

