/*
 * Decompiled with CFR 0.152.
 */
package org.fax4j.spi.phaxio;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.fax4j.FaxException;
import org.fax4j.FaxJob;
import org.fax4j.common.FaxActionType;
import org.fax4j.spi.http.AbstractMultiPart2JSONHTTPFaxClientSpi;
import org.fax4j.spi.http.CommonHTTPClientConfiguration;
import org.fax4j.spi.http.HTTPClient;
import org.fax4j.spi.http.HTTPClientConfiguration;
import org.fax4j.spi.http.JSONHTTPResponseHandler;
import org.fax4j.spi.http.MultiPartFaxJob2HTTPRequestConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhaxioFaxClientSpi
extends AbstractMultiPart2JSONHTTPFaxClientSpi {
    public static final String PHAXIO_PROPERTY_PART = "phaxio";

    @Override
    public String getPropertyPart() {
        return PHAXIO_PROPERTY_PART;
    }

    @Override
    protected HTTPClientConfiguration createHTTPClientConfiguration() {
        CommonHTTPClientConfiguration configuration = new CommonHTTPClientConfiguration();
        configuration.setHostName("api.phaxio.com");
        configuration.setSSL(true);
        configuration.setMethod(FaxActionType.SUBMIT_FAX_JOB, HTTPClient.HTTPMethod.POST);
        configuration.setMethod(FaxActionType.CANCEL_FAX_JOB, HTTPClient.HTTPMethod.POST);
        configuration.setMethod(FaxActionType.GET_FAX_JOB_STATUS, HTTPClient.HTTPMethod.POST);
        return configuration;
    }

    @Override
    protected void updateFaxJob2HTTPRequestConverterConfiguration(Map<String, String> configuration) {
        String apiKey = this.getConfigurationValue(FaxClientSpiConfigurationConstants.API_KEY_PROPERTY_KEY);
        String apiSecret = this.getConfigurationValue(FaxClientSpiConfigurationConstants.API_SECRET_PROPERTY_KEY);
        if (apiKey == null || apiSecret == null) {
            throw new FaxException("Missing phaxio API key/secret values.");
        }
        String propertyPart = this.getPropertyPart();
        configuration.put(MessageFormat.format(MultiPartFaxJob2HTTPRequestConverter.FaxJob2HTTPRequestConverterConfigurationConstants.SUBMIT_ACTION_FILE_CONTENT_PARAMETER_NAME_PROPERTY_KEY.toString(), propertyPart), "filename");
        configuration.put(MessageFormat.format(MultiPartFaxJob2HTTPRequestConverter.FaxJob2HTTPRequestConverterConfigurationConstants.SUBMIT_ACTION_TARGET_ADDRESS_PARAMETER_NAME_PROPERTY_KEY.toString(), propertyPart), "to");
        configuration.put(MessageFormat.format(MultiPartFaxJob2HTTPRequestConverter.FaxJob2HTTPRequestConverterConfigurationConstants.SUBMIT_ACTION_SENDER_FAX_NUMBER_PARAMETER_NAME_PROPERTY_KEY.toString(), propertyPart), "caller_id");
        configuration.put(MessageFormat.format(MultiPartFaxJob2HTTPRequestConverter.FaxJob2HTTPRequestConverterConfigurationConstants.CANCEL_ACTION_FAX_JOB_ID_PARAMETER_NAME_PROPERTY_KEY.toString(), propertyPart), "id");
        configuration.put(MessageFormat.format(MultiPartFaxJob2HTTPRequestConverter.FaxJob2HTTPRequestConverterConfigurationConstants.GET_FAX_JOB_STATUS_ACTION_FAX_JOB_ID_PARAMETER_NAME_PROPERTY_KEY.toString(), propertyPart), "id");
        configuration.put(MessageFormat.format(MultiPartFaxJob2HTTPRequestConverter.FaxJob2HTTPRequestConverterConfigurationConstants.ADDITIONAL_PARAMETER_PROPERTY_KEY_PREFIX.toString() + "api_key", propertyPart), apiKey);
        configuration.put(MessageFormat.format(MultiPartFaxJob2HTTPRequestConverter.FaxJob2HTTPRequestConverterConfigurationConstants.ADDITIONAL_PARAMETER_PROPERTY_KEY_PREFIX.toString() + "api_secret", propertyPart), apiSecret);
    }

    @Override
    protected void updateHTTPResponseHandlerConfiguration(Map<String, String> configuration) {
        String propertyPart = this.getPropertyPart();
        configuration.put(MessageFormat.format(JSONHTTPResponseHandler.JSONHTTPResponseHandlerConfigurationConstants.SUBMIT_JSON_OUTPUT_PROPERTY_KEY.toString(), propertyPart), "faxId");
        configuration.put(MessageFormat.format(JSONHTTPResponseHandler.JSONHTTPResponseHandlerConfigurationConstants.ERROR_DETECTION_PATH_PROPERTY_KEY.toString(), propertyPart), "success");
        configuration.put(MessageFormat.format(JSONHTTPResponseHandler.JSONHTTPResponseHandlerConfigurationConstants.ERROR_DETECTION_VALUE_PROPERTY_KEY.toString(), propertyPart), "false");
        configuration.put(MessageFormat.format(JSONHTTPResponseHandler.JSONHTTPResponseHandlerConfigurationConstants.ERROR_MESSAGE_PATH_PROPERTY_KEY.toString(), propertyPart), "message");
        configuration.put(MessageFormat.format(JSONHTTPResponseHandler.JSONHTTPResponseHandlerConfigurationConstants.GET_STATUS_JSON_OUTPUT_PROPERTY_KEY.toString(), propertyPart), "data;status");
        configuration.put(MessageFormat.format(JSONHTTPResponseHandler.JSONHTTPResponseHandlerConfigurationConstants.PENDING_STATUS_MAPPING_PROPERTY_KEY.toString(), propertyPart), "queued;pendingbatch");
        configuration.put(MessageFormat.format(JSONHTTPResponseHandler.JSONHTTPResponseHandlerConfigurationConstants.IN_PROGRESS_STATUS_MAPPING_PROPERTY_KEY.toString(), propertyPart), "inprogress");
        configuration.put(MessageFormat.format(JSONHTTPResponseHandler.JSONHTTPResponseHandlerConfigurationConstants.ERROR_STATUS_MAPPING_PROPERTY_KEY.toString(), propertyPart), "failure;partialsuccess");
    }

    @Override
    protected Map<FaxActionType, String> initializeFaxActionType2ResourceMap() {
        HashMap<FaxActionType, String> map = new HashMap<FaxActionType, String>();
        map.put(FaxActionType.SUBMIT_FAX_JOB, "/v1/send");
        map.put(FaxActionType.CANCEL_FAX_JOB, "/v1/faxCancel");
        map.put(FaxActionType.GET_FAX_JOB_STATUS, "/v1/faxStatus");
        return map;
    }

    @Override
    protected String initializeURLParameters() {
        return null;
    }

    @Override
    protected void suspendFaxJobImpl(FaxJob faxJob) {
        this.throwUnsupportedException();
    }

    @Override
    protected void resumeFaxJobImpl(FaxJob faxJob) {
        this.throwUnsupportedException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FaxClientSpiConfigurationConstants {
        API_KEY_PROPERTY_KEY("org.fax4j.spi.phaxio.api.key"),
        API_SECRET_PROPERTY_KEY("org.fax4j.spi.phaxio.api.secret");

        private String value;

        private FaxClientSpiConfigurationConstants(String value) {
            this.value = value;
        }

        public final String toString() {
            return this.value;
        }
    }
}

