/*
 * Decompiled with CFR 0.152.
 */
package org.fax4j.spi.process;

import org.fax4j.FaxException;
import org.fax4j.FaxJob;
import org.fax4j.FaxJobStatus;
import org.fax4j.common.FaxActionType;
import org.fax4j.spi.AbstractFax4JClientSpi;
import org.fax4j.spi.process.ExitCodeProcessOutputValidator;
import org.fax4j.spi.process.ProcessOutputHandler;
import org.fax4j.spi.process.ProcessOutputValidator;
import org.fax4j.util.ProcessExecutorHelper;
import org.fax4j.util.ReflectionHelper;
import org.fax4j.util.SpiUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessFaxClientSpi
extends AbstractFax4JClientSpi {
    private ProcessOutputValidator processOutputValidator;
    private ProcessOutputHandler processOutputHandler;
    protected boolean useWindowsCommandPrefix;
    private String windowsCommandPrefix;
    protected static final String WINDOWS_EXECUTE_PREFIX_DEFAULT_VALUE = "rundll32 SHELL32.DLL,ShellExec_RunDLL";

    @Override
    protected void initializeImpl() {
        String value = this.getConfigurationValue(FaxClientSpiConfigurationConstants.USE_WINDOWS_PREFIX_PROPERTY_KEY);
        this.useWindowsCommandPrefix = Boolean.parseBoolean(value);
        this.windowsCommandPrefix = this.getConfigurationValue(FaxClientSpiConfigurationConstants.WINDOWS_PREFIX_PROPERTY_KEY);
        if (this.windowsCommandPrefix == null) {
            this.windowsCommandPrefix = WINDOWS_EXECUTE_PREFIX_DEFAULT_VALUE;
        }
        this.processOutputValidator = this.createProcessOutputValidator();
        if (this.processOutputValidator == null) {
            throw new FaxException("Unable to create a new process output validator.");
        }
        this.processOutputHandler = this.createProcessOutputHandler();
    }

    @Override
    public String getPropertyPart() {
        return FaxClientSpiConfigurationConstants.PROPERTY_PART_DEFAULT_VALUE.toString();
    }

    protected ProcessOutputValidator createProcessOutputValidator() {
        String className = this.getConfigurationValue(FaxClientSpiConfigurationConstants.PROCESS_OUTPUT_VALIDATOR_PRE_FORMAT_PROPERTY_KEY);
        ProcessOutputValidator validator = null;
        if (className == null) {
            className = ExitCodeProcessOutputValidator.class.getName();
        }
        validator = (ProcessOutputValidator)ReflectionHelper.createInstance(className);
        return validator;
    }

    protected ProcessOutputHandler createProcessOutputHandler() {
        String className = this.getConfigurationValue(FaxClientSpiConfigurationConstants.PROCESS_OUTPUT_HANDLER_PRE_FORMAT_PROPERTY_KEY);
        ProcessOutputHandler handler = null;
        if (className != null) {
            handler = (ProcessOutputHandler)ReflectionHelper.createInstance(className);
        }
        return handler;
    }

    public final ProcessOutputValidator getProcessOutputValidator() {
        return this.processOutputValidator;
    }

    protected final ProcessOutputHandler getProcessOutputHandler() {
        return this.processOutputHandler;
    }

    @Override
    protected void submitFaxJobImpl(FaxJob faxJob) {
        String command = this.createSubmitFaxJobProcessCommand(faxJob);
        this.executeProcess(faxJob, command, FaxActionType.SUBMIT_FAX_JOB);
    }

    @Override
    protected void suspendFaxJobImpl(FaxJob faxJob) {
        String command = this.createSuspendFaxJobProcessCommand(faxJob);
        this.executeProcess(faxJob, command, FaxActionType.SUSPEND_FAX_JOB);
    }

    @Override
    protected void resumeFaxJobImpl(FaxJob faxJob) {
        String command = this.createResumeFaxJobProcessCommand(faxJob);
        this.executeProcess(faxJob, command, FaxActionType.RESUME_FAX_JOB);
    }

    @Override
    protected void cancelFaxJobImpl(FaxJob faxJob) {
        String command = this.createCancelFaxJobProcessCommand(faxJob);
        this.executeProcess(faxJob, command, FaxActionType.CANCEL_FAX_JOB);
    }

    @Override
    protected FaxJobStatus getFaxJobStatusImpl(FaxJob faxJob) {
        String command = this.createGetStatusFaxJobProcessCommand(faxJob);
        FaxJobStatus faxJobStatus = FaxJobStatus.UNKNOWN;
        if (command != null) {
            ProcessExecutorHelper.ProcessOutput processOutput = this.executeProcess(faxJob, command, FaxActionType.GET_FAX_JOB_STATUS);
            faxJobStatus = this.getFaxJobStatus(processOutput);
        }
        return faxJobStatus;
    }

    protected FaxJobStatus getFaxJobStatus(ProcessExecutorHelper.ProcessOutput processOutput) {
        FaxJobStatus faxJobStatus = null;
        if (this.processOutputHandler != null) {
            faxJobStatus = this.processOutputHandler.getFaxJobStatus(this, processOutput);
        }
        if (faxJobStatus == null) {
            faxJobStatus = FaxJobStatus.UNKNOWN;
        }
        return faxJobStatus;
    }

    protected ProcessExecutorHelper.ProcessOutput executeProcess(FaxJob faxJob, String command, FaxActionType faxActionType) {
        if (command == null) {
            this.throwUnsupportedException();
        }
        String updatedCommand = command;
        if (this.useWindowsCommandPrefix) {
            StringBuilder buffer = new StringBuilder(updatedCommand.length() + this.windowsCommandPrefix.length() + 1);
            buffer.append(this.windowsCommandPrefix);
            buffer.append(" ");
            buffer.append(updatedCommand);
            updatedCommand = buffer.toString();
        }
        ProcessExecutorHelper.ProcessOutput processOutput = ProcessExecutorHelper.executeProcess(this, updatedCommand);
        this.validateProcessOutput(processOutput, faxActionType);
        this.updateFaxJob(faxJob, processOutput, faxActionType);
        return processOutput;
    }

    protected String formatTemplate(String template, FaxJob faxJob) {
        return SpiUtil.formatTemplate(template, faxJob, null, false, true);
    }

    protected String getTemplate(String templateName) {
        String template = this.getConfigurationValue(templateName);
        return template;
    }

    protected String createProcessCommand(Enum<?> templateNameEnum, FaxJob faxJob) {
        String templateName = templateNameEnum.toString();
        String template = this.getTemplate(templateName);
        String command = null;
        if (template != null) {
            command = this.formatTemplate(template, faxJob);
        }
        return command;
    }

    protected void validateProcessOutput(ProcessExecutorHelper.ProcessOutput processOutput, FaxActionType faxActionType) {
        this.processOutputValidator.validateProcessOutput(this, processOutput, faxActionType);
    }

    protected void updateFaxJob(FaxJob faxJob, ProcessExecutorHelper.ProcessOutput processOutput, FaxActionType faxActionType) {
        if (this.processOutputHandler != null) {
            this.processOutputHandler.updateFaxJob(this, faxJob, processOutput, faxActionType);
        }
    }

    protected String createSubmitFaxJobProcessCommand(FaxJob faxJob) {
        return this.createProcessCommand(FaxClientSpiConfigurationConstants.SUBMIT_FAX_JOB_TEMPLATE_PRE_FORMAT_PROPERTY_KEY, faxJob);
    }

    protected String createSuspendFaxJobProcessCommand(FaxJob faxJob) {
        return this.createProcessCommand(FaxClientSpiConfigurationConstants.SUSPEND_FAX_JOB_TEMPLATE_PRE_FORMAT_PROPERTY_KEY, faxJob);
    }

    protected String createResumeFaxJobProcessCommand(FaxJob faxJob) {
        return this.createProcessCommand(FaxClientSpiConfigurationConstants.RESUME_FAX_JOB_TEMPLATE_PRE_FORMAT_PROPERTY_KEY, faxJob);
    }

    protected String createCancelFaxJobProcessCommand(FaxJob faxJob) {
        return this.createProcessCommand(FaxClientSpiConfigurationConstants.CANCEL_FAX_JOB_TEMPLATE_PRE_FORMAT_PROPERTY_KEY, faxJob);
    }

    protected String createGetStatusFaxJobProcessCommand(FaxJob faxJob) {
        return this.createProcessCommand(FaxClientSpiConfigurationConstants.GET_STATUS_FAX_JOB_TEMPLATE_PRE_FORMAT_PROPERTY_KEY, faxJob);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FaxClientSpiConfigurationConstants {
        SUBMIT_FAX_JOB_TEMPLATE_PRE_FORMAT_PROPERTY_KEY("org.fax4j.spi.{0}.submit.template.command"),
        SUSPEND_FAX_JOB_TEMPLATE_PRE_FORMAT_PROPERTY_KEY("org.fax4j.spi.{0}.suspend.template.command"),
        RESUME_FAX_JOB_TEMPLATE_PRE_FORMAT_PROPERTY_KEY("org.fax4j.spi.{0}.resume.template.command"),
        CANCEL_FAX_JOB_TEMPLATE_PRE_FORMAT_PROPERTY_KEY("org.fax4j.spi.{0}.cancel.template.command"),
        GET_STATUS_FAX_JOB_TEMPLATE_PRE_FORMAT_PROPERTY_KEY("org.fax4j.spi.{0}.get.status.template.command"),
        PROCESS_OUTPUT_VALIDATOR_PRE_FORMAT_PROPERTY_KEY("org.fax4j.spi.{0}.output.validator"),
        PROCESS_OUTPUT_HANDLER_PRE_FORMAT_PROPERTY_KEY("org.fax4j.spi.{0}.output.handler"),
        USE_WINDOWS_PREFIX_PROPERTY_KEY("org.fax4j.spi.process.use.windows.command.prefix"),
        WINDOWS_PREFIX_PROPERTY_KEY("org.fax4j.spi.process.windows.command.prefix"),
        PROPERTY_PART_DEFAULT_VALUE("process");

        private String value;

        private FaxClientSpiConfigurationConstants(String value) {
            this.value = value;
        }

        public final String toString() {
            return this.value;
        }
    }
}

