/*
 * Decompiled with CFR 0.152.
 */
package org.fax4j.spi.vbs;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.fax4j.FaxException;
import org.fax4j.FaxJob;
import org.fax4j.FaxJobStatus;
import org.fax4j.common.FaxActionType;
import org.fax4j.common.Logger;
import org.fax4j.spi.AbstractFax4JClientSpi;
import org.fax4j.spi.process.ProcessOutputHandler;
import org.fax4j.spi.process.ProcessOutputValidator;
import org.fax4j.spi.vbs.VBSProcessOutputHandler;
import org.fax4j.spi.vbs.VBSProcessOutputValidator;
import org.fax4j.util.IOHelper;
import org.fax4j.util.ProcessExecutorHelper;

public class VBSFaxClientSpi
extends AbstractFax4JClientSpi {
    protected String faxServerName;
    protected String vbsExePath;
    protected boolean useWin2kAPI;
    private ProcessOutputValidator processOutputValidator;
    private ProcessOutputHandler processOutputHandler;
    private static final Map<String, String> VBS_SCRIPTS = new HashMap<String, String>();
    private static final String VBS_SCRIPT = "fax.vbs";
    private static final String VBS_WIN_XP_SUBMIT_SCRIPT = "winxp_submit_fax.vbs";
    private static final String VBS_WIN_2K_SUBMIT_SCRIPT = "win2k_submit_fax.vbs";
    private static final String VBS_WIN_XP_SUSPEND_SCRIPT = "winxp_suspend_fax.vbs";
    private static final String VBS_WIN_2K_SUSPEND_SCRIPT = "win2k_suspend_fax.vbs";
    private static final String VBS_WIN_XP_RESUME_SCRIPT = "winxp_resume_fax.vbs";
    private static final String VBS_WIN_2K_RESUME_SCRIPT = "win2k_resume_fax.vbs";
    private static final String VBS_WIN_XP_CANCEL_SCRIPT = "winxp_cancel_fax.vbs";
    private static final String VBS_WIN_2K_CANCEL_SCRIPT = "win2k_cancel_fax.vbs";
    private static final String VBS_WIN_XP_GET_FAX_JOB_STATUS_SCRIPT = "winxp_get_fax_job_status.vbs";
    private static final String VBS_WIN_2K_GET_FAX_JOB_STATUS_SCRIPT = "win2k_get_fax_job_status.vbs";
    private static final String[] VSB_SCRIPT_NAMES = new String[]{"fax.vbs", "winxp_submit_fax.vbs", "win2k_submit_fax.vbs", "winxp_suspend_fax.vbs", "win2k_suspend_fax.vbs", "winxp_resume_fax.vbs", "win2k_resume_fax.vbs", "winxp_cancel_fax.vbs", "win2k_cancel_fax.vbs", "winxp_get_fax_job_status.vbs", "win2k_get_fax_job_status.vbs"};
    public static final String WIN_2K_OS_NAME = "Windows 2000";

    protected void initializeImpl() {
        String osName;
        boolean win2kAPI;
        Logger logger = this.getLogger();
        this.faxServerName = this.getConfigurationValue(FaxClientSpiConfigurationConstants.FAX_SERVER_NAME_PROPERTY_KEY);
        if (this.faxServerName == null) {
            this.faxServerName = "";
        }
        logger.logDebug(new Object[]{"Fax server name: ", this.faxServerName}, null);
        this.vbsExePath = this.getConfigurationValue(FaxClientSpiConfigurationConstants.VBS_EXE_PATH_PROPERTY_KEY);
        if (this.vbsExePath == null) {
            this.vbsExePath = FaxClientSpiConfigurationConstants.VBS_EXE_PATH_DEFAULT_VALUE.toString();
        }
        logger.logDebug(new Object[]{"VBS exe path: ", this.vbsExePath}, null);
        String valueStr = this.getConfigurationValue(FaxClientSpiConfigurationConstants.VBS_ALWAYS_USE_WIN2K_API_PROPERTY_KEY);
        if (valueStr == null) {
            valueStr = Boolean.toString(true);
        }
        if (!(win2kAPI = Boolean.parseBoolean(valueStr)) && (osName = System.getProperty("os.name")).equalsIgnoreCase(WIN_2K_OS_NAME)) {
            win2kAPI = true;
        }
        this.useWin2kAPI = win2kAPI;
        logger.logDebug(new Object[]{"Use windows 2000 API: ", Boolean.toString(this.useWin2kAPI)}, null);
        this.processOutputValidator = new VBSProcessOutputValidator();
        this.processOutputHandler = new VBSProcessOutputHandler();
    }

    public boolean isFaxMonitorEventsSupported() {
        return true;
    }

    protected String getVBSExePath() {
        return this.vbsExePath;
    }

    protected void submitFaxJobImpl(FaxJob faxJob) {
        String name = VBS_WIN_XP_SUBMIT_SCRIPT;
        if (this.useWin2kAPI) {
            name = VBS_WIN_2K_SUBMIT_SCRIPT;
        }
        Object[] input = this.setupSubmitFaxJobInput(faxJob);
        this.invokeScript(faxJob, name, input, FaxActionType.SUBMIT_FAX_JOB);
    }

    protected void suspendFaxJobImpl(FaxJob faxJob) {
        String name = VBS_WIN_XP_SUSPEND_SCRIPT;
        if (this.useWin2kAPI) {
            name = VBS_WIN_2K_SUSPEND_SCRIPT;
        }
        this.invokeExistingFaxJobAction(name, faxJob, FaxActionType.SUSPEND_FAX_JOB);
    }

    protected void resumeFaxJobImpl(FaxJob faxJob) {
        String name = VBS_WIN_XP_RESUME_SCRIPT;
        if (this.useWin2kAPI) {
            name = VBS_WIN_2K_RESUME_SCRIPT;
        }
        this.invokeExistingFaxJobAction(name, faxJob, FaxActionType.RESUME_FAX_JOB);
    }

    protected void cancelFaxJobImpl(FaxJob faxJob) {
        String name = VBS_WIN_XP_CANCEL_SCRIPT;
        if (this.useWin2kAPI) {
            name = VBS_WIN_2K_CANCEL_SCRIPT;
        }
        this.invokeExistingFaxJobAction(name, faxJob, FaxActionType.CANCEL_FAX_JOB);
    }

    protected FaxJobStatus getFaxJobStatusImpl(FaxJob faxJob) {
        String name = VBS_WIN_XP_GET_FAX_JOB_STATUS_SCRIPT;
        if (this.useWin2kAPI) {
            name = VBS_WIN_2K_GET_FAX_JOB_STATUS_SCRIPT;
        }
        FaxJobStatus faxJobStatus = this.invokeExistingFaxJobAction(name, faxJob, FaxActionType.GET_FAX_JOB_STATUS);
        return faxJobStatus;
    }

    protected Object[] setupSubmitFaxJobInput(FaxJob faxJob) {
        LinkedList<Object> inputList = new LinkedList<Object>();
        inputList.add(this.faxServerName);
        File file = faxJob.getFile();
        inputList.add(file);
        String documentName = faxJob.getProperty(FaxJobExtendedPropertyConstants.DOCUMENT_NAME_FAX_JOB_PROPERTY_KEY.toString(), null);
        if (documentName == null || documentName.length() == 0) {
            documentName = file.getName();
        }
        inputList.add(documentName);
        if (this.useWin2kAPI) {
            inputList.add(faxJob.getTargetAddress());
            inputList.add(faxJob.getTargetName());
            inputList.add(faxJob.getSenderName());
            inputList.add(faxJob.getSenderFaxNumber());
        } else {
            FaxJob.FaxJobPriority priority = faxJob.getPriority();
            String valueStr = "fptNORMAL";
            if (priority != null) {
                switch (priority) {
                    case LOW_PRIORITY: {
                        valueStr = "fptLOW";
                        break;
                    }
                    case MEDIUM_PRIORITY: {
                        valueStr = "fptNORMAL";
                        break;
                    }
                    case HIGH_PRIORITY: {
                        valueStr = "fptHIGH";
                    }
                }
            }
            inputList.add(valueStr);
            inputList.add(faxJob.getTargetAddress());
            inputList.add(faxJob.getTargetName());
            inputList.add(faxJob.getSenderName());
            inputList.add(faxJob.getSenderFaxNumber());
            inputList.add(faxJob.getSenderEmail());
        }
        int size = inputList.size();
        Object[] input = inputList.toArray(new Object[size]);
        return input;
    }

    protected Object formatObject(Object object) {
        Object formattedObject = object;
        if (object == null) {
            formattedObject = "";
        } else if (object instanceof String) {
            String string = (String)object;
            string = string.replaceAll("\n", "");
            string = string.replaceAll("\r", "");
            string = string.replaceAll("\t", "");
            string = string.replaceAll("\f", "");
            string = string.replaceAll("\b", "");
            string = string.replaceAll("'", "");
            string = string.replaceAll("\"", "");
            formattedObject = string;
        } else if (object instanceof File) {
            File file = (File)object;
            String filePath = null;
            try {
                filePath = file.getCanonicalPath();
            }
            catch (IOException exception) {
                throw new FaxException("Unable to get file path.", exception);
            }
            filePath = filePath.replaceAll("\\\\", "\\\\\\\\");
            formattedObject = filePath;
        }
        return formattedObject;
    }

    protected FaxJobStatus invokeExistingFaxJobAction(String scriptName, FaxJob faxJob, FaxActionType faxActionType) {
        Object[] input = new String[]{this.faxServerName, faxJob.getID()};
        return this.invokeScript(faxJob, scriptName, input, faxActionType);
    }

    protected FaxJobStatus invokeScript(FaxJob faxJob, String name, Object[] input, FaxActionType faxActionType) {
        String script = this.generateScript(name, input);
        ProcessExecutorHelper.ProcessOutput processOutput = this.invokeScript(script);
        this.processOutputValidator.validateProcessOutput(this, processOutput, faxActionType);
        FaxJobStatus output = null;
        switch (faxActionType) {
            case SUBMIT_FAX_JOB: {
                this.processOutputHandler.updateFaxJob(this, faxJob, processOutput, faxActionType);
                break;
            }
            case GET_FAX_JOB_STATUS: {
                output = this.processOutputHandler.getFaxJobStatus(this, processOutput);
                break;
            }
        }
        return output;
    }

    protected ProcessExecutorHelper.ProcessOutput invokeScript(String script) {
        File file = null;
        try {
            file = File.createTempFile("fax4j_", ".vbs");
        }
        catch (IOException exception) {
            throw new FaxException("Unable to create temporary vbscript file.", exception);
        }
        file.deleteOnExit();
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getVBSExePath());
        buffer.append(" \"");
        buffer.append(file.getAbsolutePath());
        buffer.append("\"");
        String command = buffer.toString();
        try {
            IOHelper.writeTextFile(script, file);
        }
        catch (IOException exception) {
            throw new FaxException("Unable to write vbscript to temporary file.", exception);
        }
        Logger logger = this.getLogger();
        logger.logDebug(new Object[]{"Invoking command: ", command, " script:", Logger.SYSTEM_EOL, script}, null);
        ProcessExecutorHelper.ProcessOutput vbsOutput = ProcessExecutorHelper.executeProcess(this, command);
        int exitCode = vbsOutput.getExitCode();
        boolean fileDeleted = file.delete();
        logger.logDebug(new Object[]{"Temp script file deleted: ", String.valueOf(fileDeleted)}, null);
        if (exitCode != 0) {
            throw new FaxException("Error while invoking script, exit code: " + exitCode + " script output:\n" + vbsOutput.getOutputText() + "\nScript error:\n" + vbsOutput.getErrorText());
        }
        return vbsOutput;
    }

    protected String generateScript(String name, Object[] input) {
        String template = VBS_SCRIPTS.get(name);
        if (template == null || template.length() == 0) {
            this.throwUnsupportedException();
        }
        String commonScript = VBS_SCRIPTS.get(VBS_SCRIPT);
        Object[] formattedInput = null;
        if (input != null) {
            int size = input.length;
            formattedInput = new Object[size];
            Object object = null;
            for (int index = 0; index < size; ++index) {
                object = input[index];
                formattedInput[index] = object = this.formatObject(object);
            }
        }
        String updatedScript = MessageFormat.format(template, formattedInput);
        StringBuilder buffer = new StringBuilder(commonScript.length() + updatedScript.length());
        buffer.append(commonScript);
        buffer.append(updatedScript);
        String script = buffer.toString();
        return script;
    }

    static {
        int amount = VSB_SCRIPT_NAMES.length;
        String name = null;
        InputStream inputStream = null;
        String content = null;
        for (int index = 0; index < amount; ++index) {
            name = VSB_SCRIPT_NAMES[index];
            inputStream = VBSFaxClientSpi.class.getResourceAsStream(name);
            try {
                Reader reader = IOHelper.createReader(inputStream, null);
                content = IOHelper.readTextStream(reader);
                IOHelper.closeResource(inputStream);
            }
            catch (Exception exception) {
                IOHelper.closeResource(inputStream);
                throw new FaxException("Unable to read internal script: " + name, exception);
            }
            VBS_SCRIPTS.put(name, content);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FaxJobExtendedPropertyConstants {
        DOCUMENT_NAME_FAX_JOB_PROPERTY_KEY("document.name");

        private String value;

        private FaxJobExtendedPropertyConstants(String value) {
            this.value = value;
        }

        public final String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FaxClientSpiConfigurationConstants {
        FAX_SERVER_NAME_PROPERTY_KEY("org.fax4j.spi.vbs.server.name"),
        VBS_EXE_PATH_PROPERTY_KEY("org.fax4j.spi.vbs.exe.path"),
        VBS_ALWAYS_USE_WIN2K_API_PROPERTY_KEY("org.fax4j.spi.vbs.always.use.win2000.api"),
        VBS_EXE_PATH_DEFAULT_VALUE("cscript");

        private String value;

        private FaxClientSpiConfigurationConstants(String value) {
            this.value = value;
        }

        public final String toString() {
            return this.value;
        }
    }
}

