/*
 * Decompiled with CFR 0.152.
 */
package org.fax4j.spi.vbs;

import org.fax4j.FaxJob;
import org.fax4j.FaxJobStatus;
import org.fax4j.common.FaxActionType;
import org.fax4j.spi.FaxClientSpi;
import org.fax4j.spi.process.ProcessOutputHandler;
import org.fax4j.spi.windows.WindowsFaxClientSpiHelper;
import org.fax4j.util.ProcessExecutorHelper;

public class VBSProcessOutputHandler
implements ProcessOutputHandler {
    private static final String FAX_JOB_ID_OUTPUT_PREFIX = "fax.job.id=";
    private static final String FAX_JOB_STATUS_OUTPUT_PREFIX = "fax.job.status=";

    protected FaxJobStatus getFaxJobStatusFromWindowsFaxJobStatusString(String faxJobStatusStr) {
        FaxJobStatus faxJobStatus = FaxJobStatus.UNKNOWN;
        if (faxJobStatusStr != null && faxJobStatusStr.length() > 0) {
            if (faxJobStatusStr.equalsIgnoreCase("Pending") || faxJobStatusStr.equalsIgnoreCase("Paused") || faxJobStatusStr.equalsIgnoreCase("Retrying")) {
                faxJobStatus = FaxJobStatus.PENDING;
            } else if (faxJobStatusStr.equalsIgnoreCase("In Progress")) {
                faxJobStatus = FaxJobStatus.IN_PROGRESS;
            } else if (faxJobStatusStr.equalsIgnoreCase("Failed") || faxJobStatusStr.equalsIgnoreCase("No Line") || faxJobStatusStr.equalsIgnoreCase("Retries Exceeded")) {
                faxJobStatus = FaxJobStatus.ERROR;
            }
        }
        return faxJobStatus;
    }

    public void updateFaxJob(FaxClientSpi faxClientSpi, FaxJob faxJob, ProcessExecutorHelper.ProcessOutput processOutput, FaxActionType faxActionType) {
        String output = WindowsFaxClientSpiHelper.getOutputPart(processOutput, FAX_JOB_ID_OUTPUT_PREFIX);
        if (output != null) {
            WindowsFaxClientSpiHelper.validateFaxJobID(output);
            faxJob.setID(output);
        }
    }

    public FaxJobStatus getFaxJobStatus(FaxClientSpi faxClientSpi, ProcessExecutorHelper.ProcessOutput processOutput) {
        String output = WindowsFaxClientSpiHelper.getOutputPart(processOutput, FAX_JOB_STATUS_OUTPUT_PREFIX);
        FaxJobStatus faxJobStatus = null;
        if (output != null) {
            faxJobStatus = this.getFaxJobStatusFromWindowsFaxJobStatusString(output);
        }
        return faxJobStatus;
    }
}

