/*
 * Decompiled with CFR 0.152.
 */
package org.fax4j.spi.vbs;

import org.fax4j.FaxException;
import org.fax4j.common.FaxActionType;
import org.fax4j.spi.FaxClientSpi;
import org.fax4j.spi.process.ExitCodeProcessOutputValidator;
import org.fax4j.util.ProcessExecutorHelper;

public class VBSProcessOutputValidator
extends ExitCodeProcessOutputValidator {
    private static final String OPERATION_OUTPUT_DONE = "fax.operation.done=true";
    private static final String ACTIVE_X_NOT_INSTALLED = "ActiveX component can't create object";

    protected String getVBSFailedLineErrorMessage(String errorPut) {
        String lineNumberStr;
        int end;
        String prefix;
        int start;
        String message = "";
        if (errorPut != null && (start = errorPut.indexOf(prefix = ".vbs(")) != -1 && (end = errorPut.indexOf(", ", (start += prefix.length()) - 1)) != -1 && (lineNumberStr = errorPut.substring(start, end)).length() > 0) {
            int lineNumber = -1;
            try {
                lineNumber = Integer.parseInt(lineNumberStr);
            }
            catch (NumberFormatException exception) {
                // empty catch block
            }
            if (lineNumber >= 1) {
                message = " error found at line " + lineNumber + ", ";
            }
        }
        return message;
    }

    public void validateProcessOutput(FaxClientSpi faxClientSpi, ProcessExecutorHelper.ProcessOutput processOutput, FaxActionType faxActionType) {
        super.validateProcessOutput(faxClientSpi, processOutput, faxActionType);
        String output = processOutput.getOutputText();
        String errorPut = processOutput.getErrorText();
        boolean throwError = false;
        if (output != null && output.length() > 0) {
            if (output.indexOf(OPERATION_OUTPUT_DONE) == -1) {
                throwError = true;
            }
        } else {
            throwError = true;
        }
        if (throwError) {
            String message = this.getVBSFailedLineErrorMessage(errorPut);
            if (errorPut != null && errorPut.indexOf(ACTIVE_X_NOT_INSTALLED) != -1) {
                throw new FaxException("Error while invoking VBS script (fax server ActiveX not installed on system)," + message + " script output:\n" + output + "\nScript error:\n" + errorPut);
            }
            throw new FaxException("Error while invoking VBS script," + message + " script output:\n" + output + "\nScript error:\n" + errorPut);
        }
    }
}

