/*
 * Decompiled with CFR 0.152.
 */
package org.fax4j.spi.windows;

import java.util.Properties;
import org.fax4j.FaxJob;
import org.fax4j.FaxJobStatus;
import org.fax4j.common.Logger;
import org.fax4j.spi.FaxClientSpiFactory;
import org.fax4j.spi.adapter.AbstractAdapterFaxClientSpi;
import org.fax4j.spi.windows.WindowsFaxClientSpiHelper;
import org.fax4j.spi.windows.WindowsJNIFaxClientSpi;
import org.fax4j.spi.windows.WindowsProcessFaxClientSpi;

public class WindowsFaxClientSpi
extends AbstractAdapterFaxClientSpi {
    protected void initializeChildFaxClientSpi() {
        Logger logger = this.getLogger();
        boolean useJNI = false;
        String useJNIStr = this.getConfigurationValue(FaxClientSpiConfigurationConstants.USE_JNI_PROPERTY_KEY);
        if (useJNIStr != null) {
            useJNI = Boolean.parseBoolean(useJNIStr);
        }
        WindowsFaxClientSpiHelper.extractNativeResources();
        if (useJNI) {
            WindowsFaxClientSpiHelper.loadNativeLibrary(logger);
            if (!WindowsFaxClientSpiHelper.isNativeLibraryLoaded()) {
                useJNI = false;
            }
        }
        String className = WindowsProcessFaxClientSpi.class.getName();
        if (useJNI) {
            className = WindowsJNIFaxClientSpi.class.getName();
        }
        Properties childConfiguration = new Properties();
        childConfiguration.putAll(this.getConfiguration());
        childConfiguration.put("org.fax4j.spi.type.map.windows.child", className);
        this.faxClientSpi = FaxClientSpiFactory.createChildFaxClientSpi("windows.child", childConfiguration);
    }

    protected void suspendFaxJobImpl(FaxJob faxJob) {
        WindowsFaxClientSpiHelper.validateFaxJobID(faxJob);
        super.suspendFaxJobImpl(faxJob);
    }

    protected void resumeFaxJobImpl(FaxJob faxJob) {
        WindowsFaxClientSpiHelper.validateFaxJobID(faxJob);
        super.resumeFaxJobImpl(faxJob);
    }

    protected void cancelFaxJobImpl(FaxJob faxJob) {
        WindowsFaxClientSpiHelper.validateFaxJobID(faxJob);
        super.cancelFaxJobImpl(faxJob);
    }

    protected FaxJobStatus getFaxJobStatusImpl(FaxJob faxJob) {
        WindowsFaxClientSpiHelper.validateFaxJobID(faxJob);
        return super.getFaxJobStatusImpl(faxJob);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FaxClientSpiConfigurationConstants {
        FAX_SERVER_NAME_PROPERTY_KEY("org.fax4j.spi.windows.server.name"),
        USE_JNI_PROPERTY_KEY("org.fax4j.spi.windows.use.jni");

        private String value;

        private FaxClientSpiConfigurationConstants(String value) {
            this.value = value;
        }

        public final String toString() {
            return this.value;
        }
    }
}

