/*
 * Decompiled with CFR 0.152.
 */
package org.fax4j.spi.windows;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.fax4j.FaxException;
import org.fax4j.FaxJob;
import org.fax4j.FaxJobStatus;
import org.fax4j.common.Logger;
import org.fax4j.spi.FaxClientSpi;
import org.fax4j.spi.windows.WindowsFaxClientSpi;
import org.fax4j.util.IOHelper;
import org.fax4j.util.ProcessExecutorHelper;

public final class WindowsFaxClientSpiHelper {
    private static boolean nativeLibraryLoaded = false;
    public static final Object NATIVE_LOCK = new Object();

    private WindowsFaxClientSpiHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void extractNativeResources() {
        Object object = NATIVE_LOCK;
        synchronized (object) {
            File directory = IOHelper.getFax4jInternalTemporaryDirectory();
            String[] names = new String[]{"fax4j.dll", "fax4j.exe"};
            int amount = names.length;
            String name = null;
            File file = null;
            InputStream inputStream = null;
            FileOutputStream outputStream = null;
            for (int index = 0; index < amount; ++index) {
                name = names[index];
                file = new File(directory, name);
                if (file.exists() || (inputStream = WindowsFaxClientSpiHelper.class.getResourceAsStream(name)) == null) continue;
                try {
                    outputStream = new FileOutputStream(file);
                    IOHelper.readAndWriteStreams(inputStream, outputStream);
                    continue;
                }
                catch (IOException exception) {
                    throw new FaxException("Unable to extract resource: " + name, exception);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadNativeLibrary(Logger logger) {
        Object object = NATIVE_LOCK;
        synchronized (object) {
            if (!nativeLibraryLoaded) {
                try {
                    File directory = IOHelper.getFax4jInternalTemporaryDirectory();
                    File dllFile = new File(directory, "fax4j.dll");
                    String path = dllFile.getPath();
                    System.load(path);
                    logger.logDebug(new Object[]{"Loaded native library runtime path."}, null);
                    nativeLibraryLoaded = true;
                }
                catch (Throwable throwable) {
                    logger.logError(new Object[]{"Error while loading native library from runtime path."}, throwable);
                }
                if (!nativeLibraryLoaded) {
                    try {
                        System.loadLibrary("fax4j");
                        logger.logDebug(new Object[]{"Loaded native library from native path."}, null);
                        nativeLibraryLoaded = true;
                    }
                    catch (Throwable throwable) {
                        logger.logError(new Object[]{"Error while loading native library from native path."}, throwable);
                    }
                }
            }
        }
    }

    public static boolean isNativeLibraryLoaded() {
        return nativeLibraryLoaded;
    }

    public static String getServerNameFromConfiguration(FaxClientSpi faxClientSpi) {
        Logger logger = faxClientSpi.getLogger();
        String faxServerName = faxClientSpi.getConfigurationValue(WindowsFaxClientSpi.FaxClientSpiConfigurationConstants.FAX_SERVER_NAME_PROPERTY_KEY);
        logger.logDebug(new Object[]{"Fax server name: ", faxServerName}, null);
        return faxServerName;
    }

    public static int getFaxJobID(FaxJob faxJob) {
        if (faxJob == null) {
            throw new FaxException("Fax job not provided.");
        }
        String faxJobID = faxJob.getID();
        WindowsFaxClientSpiHelper.validateFaxJobID(faxJobID);
        int faxJobIDInt = Integer.parseInt(faxJobID);
        return faxJobIDInt;
    }

    public static void validateFaxJobID(FaxJob faxJob) {
        WindowsFaxClientSpiHelper.getFaxJobID(faxJob);
    }

    public static void validateFaxJobID(String faxJobID) {
        if (faxJobID == null || faxJobID.length() == 0) {
            throw new FaxException("Fax job ID not provided.");
        }
        int faxJobIDInt = Integer.parseInt(faxJobID);
        WindowsFaxClientSpiHelper.validateFaxJobID(faxJobIDInt);
    }

    public static void validateFaxJobID(int faxJobID) {
        if (faxJobID == 0) {
            throw new FaxException("Invalid fax job ID provided: " + faxJobID);
        }
    }

    public static FaxJobStatus getFaxJobStatusFromWindowsFaxJobStatusString(String faxJobStatusStr) {
        FaxJobStatus faxJobStatus = FaxJobStatus.UNKNOWN;
        if (faxJobStatusStr != null && faxJobStatusStr.length() > 0) {
            if (faxJobStatusStr.equalsIgnoreCase("JS_PENDING") || faxJobStatusStr.equalsIgnoreCase("JS_PAUSED") || faxJobStatusStr.equalsIgnoreCase("JS_RETRYING")) {
                faxJobStatus = FaxJobStatus.PENDING;
            } else if (faxJobStatusStr.equalsIgnoreCase("JS_INPROGRESS")) {
                faxJobStatus = FaxJobStatus.IN_PROGRESS;
            } else if (faxJobStatusStr.equalsIgnoreCase("JS_FAILED") || faxJobStatusStr.equalsIgnoreCase("JS_NOLINE") || faxJobStatusStr.equalsIgnoreCase("JS_RETRIES_EXCEEDED")) {
                faxJobStatus = FaxJobStatus.ERROR;
            }
        }
        return faxJobStatus;
    }

    public static String getOutputPart(ProcessExecutorHelper.ProcessOutput processOutput, String prefix) {
        String output = processOutput.getOutputText();
        if (output != null) {
            boolean validOutput = false;
            int index = output.indexOf(prefix);
            if (index != -1 && output.length() > (index += prefix.length())) {
                output = output.substring(index);
                index = (output = output.trim()).indexOf("\n");
                if (index != -1) {
                    output = output.substring(0, index);
                    output = output.trim();
                }
                if (output.length() > 0) {
                    validOutput = true;
                }
            }
            if (!validOutput) {
                output = null;
            }
        }
        return output;
    }
}

