/*
 * Decompiled with CFR 0.152.
 */
package org.fax4j.spi.windows;

import java.io.File;
import org.fax4j.FaxException;
import org.fax4j.FaxJob;
import org.fax4j.FaxJobStatus;
import org.fax4j.common.LogLevel;
import org.fax4j.common.Logger;
import org.fax4j.spi.AbstractFax4JClientSpi;
import org.fax4j.spi.windows.WindowsFaxClientSpiHelper;

public class WindowsJNIFaxClientSpi
extends AbstractFax4JClientSpi {
    private String faxServerName;

    protected void initializeImpl() {
        this.faxServerName = WindowsFaxClientSpiHelper.getServerNameFromConfiguration(this);
    }

    public boolean isFaxMonitorEventsSupported() {
        return true;
    }

    protected void preNativeCall() {
        Logger logger = this.getLogger();
        LogLevel logLevel = logger.getLogLevel();
        boolean debugMode = false;
        if (logLevel.equals(LogLevel.DEBUG)) {
            debugMode = true;
        }
        WindowsJNIFaxClientSpi.setDebugModeNative(debugMode);
    }

    protected void submitFaxJobImpl(FaxJob faxJob) {
        String senderName;
        String targetAddress = faxJob.getTargetAddress();
        String targetName = faxJob.getTargetName();
        if (targetName == null) {
            targetName = "";
        }
        if ((senderName = faxJob.getSenderName()) == null) {
            senderName = "";
        }
        File file = faxJob.getFile();
        String filePath = null;
        try {
            filePath = file.getCanonicalPath();
        }
        catch (Exception exception) {
            throw new FaxException("Unable to extract canonical path from file: " + file, exception);
        }
        int faxJobIDInt = this.winSubmitFaxJob(this.faxServerName, targetAddress, targetName, senderName, filePath);
        WindowsFaxClientSpiHelper.validateFaxJobID(faxJobIDInt);
        String faxJobID = String.valueOf(faxJobIDInt);
        faxJob.setID(faxJobID);
    }

    protected void suspendFaxJobImpl(FaxJob faxJob) {
        int faxJobIDInt = WindowsFaxClientSpiHelper.getFaxJobID(faxJob);
        this.winSuspendFaxJob(this.faxServerName, faxJobIDInt);
    }

    protected void resumeFaxJobImpl(FaxJob faxJob) {
        int faxJobIDInt = WindowsFaxClientSpiHelper.getFaxJobID(faxJob);
        this.winResumeFaxJob(this.faxServerName, faxJobIDInt);
    }

    protected void cancelFaxJobImpl(FaxJob faxJob) {
        int faxJobIDInt = WindowsFaxClientSpiHelper.getFaxJobID(faxJob);
        this.winCancelFaxJob(this.faxServerName, faxJobIDInt);
    }

    protected FaxJobStatus getFaxJobStatusImpl(FaxJob faxJob) {
        int faxJobIDInt = WindowsFaxClientSpiHelper.getFaxJobID(faxJob);
        String faxJobStatusStr = this.winGetFaxJobStatus(this.faxServerName, faxJobIDInt);
        FaxJobStatus faxJobStatus = WindowsFaxClientSpiHelper.getFaxJobStatusFromWindowsFaxJobStatusString(faxJobStatusStr);
        return faxJobStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int winSubmitFaxJob(String serverName, String targetAddress, String targetName, String senderName, String fileName) {
        int faxJobID = 0;
        Object object = WindowsFaxClientSpiHelper.NATIVE_LOCK;
        synchronized (object) {
            this.preNativeCall();
            faxJobID = WindowsJNIFaxClientSpi.submitFaxJobNative(serverName, targetAddress, targetName, senderName, fileName);
        }
        return faxJobID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void winSuspendFaxJob(String serverName, int faxJobID) {
        Object object = WindowsFaxClientSpiHelper.NATIVE_LOCK;
        synchronized (object) {
            this.preNativeCall();
            WindowsJNIFaxClientSpi.suspendFaxJobNative(serverName, faxJobID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void winResumeFaxJob(String serverName, int faxJobID) {
        Object object = WindowsFaxClientSpiHelper.NATIVE_LOCK;
        synchronized (object) {
            this.preNativeCall();
            WindowsJNIFaxClientSpi.resumeFaxJobNative(serverName, faxJobID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void winCancelFaxJob(String serverName, int faxJobID) {
        Object object = WindowsFaxClientSpiHelper.NATIVE_LOCK;
        synchronized (object) {
            this.preNativeCall();
            WindowsJNIFaxClientSpi.cancelFaxJobNative(serverName, faxJobID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String winGetFaxJobStatus(String serverName, int faxJobID) {
        String status = null;
        Object object = WindowsFaxClientSpiHelper.NATIVE_LOCK;
        synchronized (object) {
            this.preNativeCall();
            status = WindowsJNIFaxClientSpi.getFaxJobStatusNative(serverName, faxJobID);
        }
        return status;
    }

    private static native void setDebugModeNative(boolean var0);

    private static native int submitFaxJobNative(String var0, String var1, String var2, String var3, String var4);

    private static native void suspendFaxJobNative(String var0, int var1);

    private static native void resumeFaxJobNative(String var0, int var1);

    private static native void cancelFaxJobNative(String var0, int var1);

    private static native String getFaxJobStatusNative(String var0, int var1);
}

