/*
 * Decompiled with CFR 0.152.
 */
package org.fax4j.spi.windows;

import java.io.File;
import org.fax4j.FaxException;
import org.fax4j.FaxJob;
import org.fax4j.spi.process.ProcessFaxClientSpi;
import org.fax4j.spi.process.ProcessOutputHandler;
import org.fax4j.spi.process.ProcessOutputValidator;
import org.fax4j.spi.windows.WindowsFaxClientSpiHelper;
import org.fax4j.spi.windows.WindowsProcessOutputHandler;
import org.fax4j.spi.windows.WindowsProcessOutputValidator;
import org.fax4j.util.IOHelper;

public class WindowsProcessFaxClientSpi
extends ProcessFaxClientSpi {
    private String faxServerName;
    private String fax4jExecutableFileLocation;

    protected void initializeImpl() {
        super.initializeImpl();
        File directory = IOHelper.getFax4jInternalTemporaryDirectory();
        String fax4jExe = Fax4jExeConstants.FAX4J_EXE.toString();
        File exeFile = new File(directory, fax4jExe);
        if (exeFile.exists()) {
            this.fax4jExecutableFileLocation = exeFile.getPath();
        } else {
            exeFile = IOHelper.getFileFromNativePath(fax4jExe);
            if (exeFile != null) {
                this.fax4jExecutableFileLocation = exeFile.getPath();
            }
        }
        this.faxServerName = WindowsFaxClientSpiHelper.getServerNameFromConfiguration(this);
        this.useWindowsCommandPrefix = false;
    }

    public boolean isFaxMonitorEventsSupported() {
        return true;
    }

    public String getPropertyPart() {
        return FaxClientSpiConfigurationConstants.WINDOWS_PROPERTY_PART_DEFAULT_VALUE.toString();
    }

    protected ProcessOutputValidator createProcessOutputValidator() {
        WindowsProcessOutputValidator validator = new WindowsProcessOutputValidator();
        return validator;
    }

    protected ProcessOutputHandler createProcessOutputHandler() {
        WindowsProcessOutputHandler handler = new WindowsProcessOutputHandler();
        return handler;
    }

    protected void addCommandLineArgument(StringBuilder buffer, String argument, String value) {
        if (value != null && value.length() > 0) {
            buffer.append(argument);
            buffer.append((Object)Fax4jExeConstants.SPACE_STR);
            buffer.append((Object)Fax4jExeConstants.VALUE_WRAPPER);
            buffer.append(value);
            buffer.append((Object)Fax4jExeConstants.VALUE_WRAPPER);
            buffer.append((Object)Fax4jExeConstants.SPACE_STR);
        }
    }

    protected String createProcessCommand(String commandArguments) {
        StringBuilder buffer = new StringBuilder(500);
        buffer.append("\"");
        buffer.append(this.fax4jExecutableFileLocation);
        buffer.append("\"");
        buffer.append((Object)Fax4jExeConstants.SPACE_STR);
        buffer.append(commandArguments);
        String command = buffer.toString();
        return command;
    }

    protected String createProcessCommandArgumentsForSubmitFaxJob(FaxJob faxJob) {
        String targetAddress = faxJob.getTargetAddress();
        String targetName = faxJob.getTargetName();
        String senderName = faxJob.getSenderName();
        File file = faxJob.getFile();
        String fileName = null;
        try {
            fileName = file.getCanonicalPath();
        }
        catch (Exception exception) {
            throw new FaxException("Unable to extract canonical path from file: " + file, exception);
        }
        StringBuilder buffer = new StringBuilder();
        this.addCommandLineArgument(buffer, Fax4jExeConstants.ACTION_FAX4J_EXE_COMMAND_LINE_ARGUMENT.toString(), Fax4jExeConstants.SUBMIT_ACTION_FAX4J_EXE_COMMAND_LINE_ARGUMENT_VALUE.toString());
        this.addCommandLineArgument(buffer, Fax4jExeConstants.SERVER_FAX4J_EXE_COMMAND_LINE_ARGUMENT.toString(), this.faxServerName);
        this.addCommandLineArgument(buffer, Fax4jExeConstants.TARGET_ADDRESS_FAX4J_EXE_COMMAND_LINE_ARGUMENT.toString(), targetAddress);
        this.addCommandLineArgument(buffer, Fax4jExeConstants.TARGET_NAME_FAX4J_EXE_COMMAND_LINE_ARGUMENT.toString(), targetName);
        this.addCommandLineArgument(buffer, Fax4jExeConstants.SENDER_NAME_FAX4J_EXE_COMMAND_LINE_ARGUMENT.toString(), senderName);
        this.addCommandLineArgument(buffer, Fax4jExeConstants.FILE_NAME_FAX4J_EXE_COMMAND_LINE_ARGUMENT.toString(), fileName);
        String commandArguments = buffer.toString();
        return commandArguments;
    }

    protected String createProcessCommandArgumentsForExistingFaxJob(String faxActionTypeArgument, FaxJob faxJob) {
        String faxJobID = faxJob.getID();
        StringBuilder buffer = new StringBuilder();
        this.addCommandLineArgument(buffer, Fax4jExeConstants.ACTION_FAX4J_EXE_COMMAND_LINE_ARGUMENT.toString(), faxActionTypeArgument);
        this.addCommandLineArgument(buffer, Fax4jExeConstants.SERVER_FAX4J_EXE_COMMAND_LINE_ARGUMENT.toString(), this.faxServerName);
        this.addCommandLineArgument(buffer, Fax4jExeConstants.FAX_JOB_ID_FAX4J_EXE_COMMAND_LINE_ARGUMENT.toString(), String.valueOf(faxJobID));
        String commandArguments = buffer.toString();
        return commandArguments;
    }

    protected String createSubmitFaxJobProcessCommand(FaxJob faxJob) {
        String commandArguments = this.createProcessCommandArgumentsForSubmitFaxJob(faxJob);
        String command = this.createProcessCommand(commandArguments);
        return command;
    }

    protected String createSuspendFaxJobProcessCommand(FaxJob faxJob) {
        String commandArguments = this.createProcessCommandArgumentsForExistingFaxJob(Fax4jExeConstants.SUSPEND_ACTION_FAX4J_EXE_COMMAND_LINE_ARGUMENT_VALUE.toString(), faxJob);
        String command = this.createProcessCommand(commandArguments);
        return command;
    }

    protected String createResumeFaxJobProcessCommand(FaxJob faxJob) {
        String commandArguments = this.createProcessCommandArgumentsForExistingFaxJob(Fax4jExeConstants.RESUME_ACTION_FAX4J_EXE_COMMAND_LINE_ARGUMENT_VALUE.toString(), faxJob);
        String command = this.createProcessCommand(commandArguments);
        return command;
    }

    protected String createCancelFaxJobProcessCommand(FaxJob faxJob) {
        String commandArguments = this.createProcessCommandArgumentsForExistingFaxJob(Fax4jExeConstants.CANCEL_ACTION_FAX4J_EXE_COMMAND_LINE_ARGUMENT_VALUE.toString(), faxJob);
        String command = this.createProcessCommand(commandArguments);
        return command;
    }

    protected String createGetStatusFaxJobProcessCommand(FaxJob faxJob) {
        String commandArguments = this.createProcessCommandArgumentsForExistingFaxJob(Fax4jExeConstants.GET_STATUS_ACTION_FAX4J_EXE_COMMAND_LINE_ARGUMENT_VALUE.toString(), faxJob);
        String command = this.createProcessCommand(commandArguments);
        return command;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Fax4jExeConstants {
        FAX4J_EXE("fax4j.exe"),
        SPACE_STR(" "),
        VALUE_WRAPPER("\""),
        SUBMIT_ACTION_FAX4J_EXE_COMMAND_LINE_ARGUMENT_VALUE("submit"),
        SUSPEND_ACTION_FAX4J_EXE_COMMAND_LINE_ARGUMENT_VALUE("suspend"),
        RESUME_ACTION_FAX4J_EXE_COMMAND_LINE_ARGUMENT_VALUE("resume"),
        CANCEL_ACTION_FAX4J_EXE_COMMAND_LINE_ARGUMENT_VALUE("cancel"),
        GET_STATUS_ACTION_FAX4J_EXE_COMMAND_LINE_ARGUMENT_VALUE("getstatus"),
        ACTION_FAX4J_EXE_COMMAND_LINE_ARGUMENT("-action"),
        SERVER_FAX4J_EXE_COMMAND_LINE_ARGUMENT("-server"),
        FAX_JOB_ID_FAX4J_EXE_COMMAND_LINE_ARGUMENT("-job"),
        TARGET_ADDRESS_FAX4J_EXE_COMMAND_LINE_ARGUMENT("-target_address"),
        TARGET_NAME_FAX4J_EXE_COMMAND_LINE_ARGUMENT("-target_name"),
        SENDER_NAME_FAX4J_EXE_COMMAND_LINE_ARGUMENT("-sender_name"),
        FILE_NAME_FAX4J_EXE_COMMAND_LINE_ARGUMENT("-file"),
        OPERATION_OUTPUT_DONE("fax.operation.done=true"),
        FAX_JOB_ID_OUTPUT_PREFIX("fax.job.id="),
        FAX_JOB_STATUS_OUTPUT_PREFIX("fax.job.status="),
        FAX_ERROR_OUTPUT_PREFIX("fax.error=");

        private String value;

        private Fax4jExeConstants(String value) {
            this.value = value;
        }

        public final String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FaxClientSpiConfigurationConstants {
        WINDOWS_PROPERTY_PART_DEFAULT_VALUE("windows");

        private String value;

        private FaxClientSpiConfigurationConstants(String value) {
            this.value = value;
        }

        public final String toString() {
            return this.value;
        }
    }
}

